/*
 *  aatv - a program to watch TV on a text-based console
 *  Copyright (C) 2000 Florent de Lamotte
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _AATV_H

struct capture_type {
	char *name;
	int type, pixel_width;
};

extern char *grab_device; 
extern int   grab_width; 
extern int   grab_height;
extern int   grab_input;
extern int   grab_norm;
extern struct capture_type *capture_type;
extern unsigned long presets [10];

/* variables from graber, still used in aatv.c */
struct video_picture	grab_pict;

/* Function prototypes. */
extern void exit_aatv (int);
extern void parse_config (void);
extern int show_image_std (unsigned char *data, int width, int height);
extern int show_image_invert (unsigned char *data, int width, int height);
extern void grab_init (void);
extern void grab_free (void);
extern unsigned char* grab_one(int *width, int *height);
extern unsigned long get_freq (void);
extern int change_freq (unsigned long freq);
extern void set_picture_properties (void);
extern void get_picture_properties (void);
extern int set_video_source (int);
extern int get_video_source (void);
extern int set_video_norm (int);
extern int get_video_norm (void);

#endif /* _AATV_H not defined */ 
	 
