// file      : CCF/IDL2/SemanticGraph/Struct.hpp
// author    : Boris Kolpackov <boris@dre.vanderbilt.edu>
// cvs-id    : Struct.hpp,v 1.1 2003/12/22 22:26:39 boris Exp

#ifndef CCF_IDL2_SEMANTIC_GRAPH_STRUCT_HPP
#define CCF_IDL2_SEMANTIC_GRAPH_STRUCT_HPP

#include "CCF/IDL2/SemanticGraph/Elements.hpp"

namespace CCF
{
  namespace IDL2
  {
    namespace SemanticGraph
    {
      class Struct : public virtual Type, public virtual Scope
      {
      public:
        virtual bool
        complete () const
        {
          return defined ();
        }

        static Introspection::TypeInfo const&
        static_type_info ();

      protected:
        friend class Graph<Node, Edge>;

        Struct ()
        {
          type_info (static_type_info ());
        }

        using Type::add_edge_right;
        using Scope::add_edge_left;
      };
    }
  }
}

#endif  // CCF_IDL2_SEMANTIC_GRAPH_STRUCT_HPP
