// -*- C++ -*-

//=============================================================================
/**
 *  @file   SSLIOP_SSL.h
 *
 *  OpenSSL @c SSL data structure specializations and typedefs.
 *
 *  SSLIOP_SSL.h,v 1.5 2004/08/19 08:56:21 ossama Exp
 *
 *  @author Ossama Othman <ossama@dre.vanderbilt.edu>
 */
//=============================================================================

#ifndef TAO_SSLIOP_SSL_H
#define TAO_SSLIOP_SSL_H

#include /**/ "ace/pre.h"

#include "ace/config-all.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
#pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "SSLIOP_OpenSSL_st_T.h"

#include <openssl/ssl.h>
#include <openssl/crypto.h>


namespace TAO
{
  namespace SSLIOP
  {
    // OpenSSL @c SSL structure traits specialization.
    template <>
    struct OpenSSL_traits< ::SSL >
    {
      /// OpenSSL lock ID for use in OpenSSL CRYPTO_add() reference
      /// count manipulation function.
      enum { LOCK_ID = CRYPTO_LOCK_SSL };

      /// Increase the reference count on the given OpenSSL structure.
      /**
       * @note This used to be in a function template but MSVC++ 6
       *       can't handle function templates correctly so reproduce
       *       the code in each specialization.  *sigh*
       */
      static ::SSL * _duplicate (::SSL * st)
      {
        if (st != 0)
          CRYPTO_add (&(st->references),
                      1,
                      LOCK_ID);

        return st;
      }

      /// Perform deep copy of the given OpenSSL structure.
      static ::SSL * copy (::SSL const & st)
      {
        return ::SSL_dup (const_cast< ::SSL * > (&st));
      }

      /// Decrease the reference count on the given OpenSSL
      /// structure.
      static void release (::SSL * st)
      {
        ::SSL_free (st);
      }
    };

    typedef OpenSSL_st_var< ::SSL > SSL_var;

  }  // End SSLIOP namespace.
}  // End TAO namespace.


#include /**/ "ace/post.h"

#endif  /* TAO_SSLIOP_SSL_H */
