/* <!-- copyright */
/*
 * aria2 - The high speed download utility
 *
 * Copyright (C) 2006 Tatsuhiro Tsujikawa
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
/* copyright --> */
#ifndef _D_DOWNLOAD_CONTEXT_H_
#define _D_DOWNLOAD_CONTEXT_H_

#include "common.h"
#include "FileEntry.h"

class DownloadContext
{
protected:
  string _dir;

public:
  DownloadContext():_dir(".") {}

  virtual ~DownloadContext() {}


  enum FILE_MODE {
    SINGLE,
    MULTI
  };

  virtual string getPieceHash(int32_t index) const = 0;
  
  virtual const Strings& getPieceHashes() const = 0;

  virtual int64_t getTotalLength() const = 0;

  virtual FILE_MODE getFileMode() const = 0;

  virtual FileEntries getFileEntries() const = 0;

  virtual string getName() const = 0;
  
  virtual int32_t getPieceLength() const = 0;

  virtual int32_t getNumPieces() const = 0;

  virtual string getPieceHashAlgo() const = 0;

  /**
   * Returns an actual file path.
   * If this contains a single file entry, then returns its file path,
   * for example, "/tmp/downloads/aria2.txt"
   * If this contains multiple file entries(i,e /tmp/downloads/aria2.txt,
   * /tmp/downloads/aria2.bin), then returns its base dir path,
   * for example, "/tmp/downloads"
   */
  virtual string getActualBasePath() const = 0;

  string getDir() const
  {
    return _dir;
  }

  void setDir(const string& dir)
  {
    _dir = dir;
  }

};

typedef SharedHandle<DownloadContext> DownloadContextHandle;

#endif // _D_DOWNLOAD_CONTEXT_H_
