/* <!-- copyright */
/*
 * aria2 - The high speed download utility
 *
 * Copyright (C) 2006 Tatsuhiro Tsujikawa
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
/* copyright --> */
#ifndef _D_REQUEST_GROUP_MAN_H_
#define _D_REQUEST_GROUP_MAN_H_

#include "common.h"
#include "TransferStat.h"

class DownloadEngine;
class RequestGroup;
typedef SharedHandle<RequestGroup> RequestGroupHandle;
typedef deque<RequestGroupHandle> RequestGroups;
class Command;
typedef deque<Command*> Commands;
class Logger;
class DownloadResult;
typedef SharedHandle<DownloadResult> DownloadResultHandle;
typedef deque<DownloadResultHandle> DownloadResults;

class RequestGroupMan {
private:
  RequestGroups _requestGroups;
  RequestGroups _reservedGroups;
  DownloadResults _downloadResults;
  const Logger* _logger;
  int32_t _maxSimultaneousDownloads;
  int32_t _gidCounter;

  string formatDownloadResult(const string& status,
			      const DownloadResultHandle& downloadResult) const;

public:
  RequestGroupMan(const RequestGroups& requestGroups, int32_t maxSimultaneousDownloads = 1);

  bool downloadFinished();

  void save();

  void closeFile();
  
  void halt();

  void forceHalt();

  Commands getInitialCommands(DownloadEngine* e);

  void removeStoppedGroup();

  void fillRequestGroupFromReserver(DownloadEngine* e);

  void addRequestGroup(const RequestGroupHandle& group);

  void addReservedGroup(const RequestGroups& groups);

  void addReservedGroup(const RequestGroupHandle& group);

  int32_t countRequestGroup() const;
		  
  RequestGroupHandle getRequestGroup(int32_t index) const;
		  
  void showDownloadResults(ostream& o) const;

  bool isSameFileBeingDownloaded(RequestGroup* requestGroup) const;

  TransferStat calculateStat();
};

typedef SharedHandle<RequestGroupMan> RequestGroupManHandle;

#endif // _D_REQUEST_GROUP_MAN_H_
