/* Evil wrapper hack to get OSS apps to cooperate with NAS
 * (C) 2000-2002 Erik Inge Bols <knan@mo.himolde.no>
 *
 * With some evil assistance from Jon Trulson ;-)
 *   ... and Tobias Diedrich
 *
 * Written with little knowledge of the OSS API, so a lot of
 * this is based on observed behaviour of OSS programs and not
 * on theory of how things should work according to OSS.
 * So expect incompatibilities, and please report and/or fix them.
 *                                    -- Erik
 *
 ***************************************************************************
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

/* 1 to enable debug output and diagnostic code */
#define DSP_DEBUG 0

/* Hack so that if you open a standalone mixer app, you're likely
   to modify the volume of the device you want.
   Undefine this if your NAS box can't handle 16-bit 44khz stereo.
   Convenience hack. */
#define MIXER_HACK 

/* You'll probably start breaking programs if you fiddle with the constants
   below. But by all means, have a try! */

#define YELL	if (arg == NULL) { DPRINTF("ioctl with argp == NULL, returning -1\n"); errno = EINVAL; return -1; }

#ifdef LINUX_IOCTL
#include <linux/ioctl.h>
#endif
#include <dlfcn.h>
#include <stdarg.h>
#include <unistd.h>

#include "soundcard.h"
#include "nasaudio.h"

typedef struct _nasInfo {
  unsigned int format;
  unsigned int rate;
  unsigned int channels;
} nasInfo, *nasInfoPtr;

				/* setup some defaults */
static nasInfo NASInfo = { AuFormatLinearUnsigned8, 8000, 1} ;
static int selectcounter = 0;                   /* For calling select() with multiple fd sets */
pthread_mutex_t nas_mutex = PTHREAD_MUTEX_INITIALIZER;

#if defined(RTLD_NEXT)
#define REAL_LIBC RTLD_NEXT
#else
#define REAL_LIBC ((void *) -1L)
#endif

#define MAGIC_FD_NUM 501
#define MIXER_FD_NUM 502

extern int bytes_written;

typedef int request_t;

static int sndfd = -1;
static int mixerfd = -1;

static void rebuildElements(nasInfoPtr info);

static unsigned char aformat_to_auformat(unsigned int fmt)
{
  switch (fmt)
    {
    case AFMT_MU_LAW:
      return AuFormatULAW8;
    case AFMT_U8:
      return AuFormatLinearUnsigned8;
    case AFMT_S8:
      return AuFormatLinearSigned8;
    case AFMT_U16_LE:
      return AuFormatLinearUnsigned16LSB;
    case AFMT_U16_BE:
      return AuFormatLinearUnsigned16MSB;
    case AFMT_S16_LE:
      return AuFormatLinearSigned16LSB;
    case AFMT_S16_BE:
      return AuFormatLinearSigned16MSB;
    }
  return AuNone;
}

static unsigned int auformat_to_aformat(unsigned char fmt)
{
  switch (fmt)
    {
    case AuFormatULAW8:
      return AFMT_MU_LAW;
    case AuFormatLinearUnsigned8:
      return AFMT_U8;
    case AuFormatLinearSigned8:
      return AFMT_S8;
    case AuFormatLinearUnsigned16LSB:
      return AFMT_U16_LE;
    case AuFormatLinearSigned16LSB:
      return AFMT_S16_LE;
    case AuFormatLinearUnsigned16MSB:
      return AFMT_U16_BE;
    case AuFormatLinearSigned16MSB:
      return AFMT_S16_BE;
    }
  return AFMT_QUERY;
}

static void rebuildElements(nasInfoPtr info)
{
  DPRINTF ("inside rebuildElements()\n");

  nas_set_format(info->format);
  nas_set_rate(info->rate);
  nas_set_nch(info->channels);
}

ssize_t
write (int fd, const void *buf, size_t len)
{
  static int (*func) (int, const void *, size_t) = NULL;
  
  if (!func)
    func = (int (*) (int, const void *, size_t)) dlsym (REAL_LIBC, "write");

  if ((fd != sndfd) || (sndfd == -1))
  {
    return (*func) (fd, buf, len);
  }

  DPRINTF("WRITE: called for %d bytes\n", len);
  len = nas_write((void *)buf, len);

  return len;
}

int
open (const char *pathname, int flags, ...)
{
  static int (*func) (const char *, int, mode_t) = NULL;
  va_list args;
  mode_t mode;
  
  if (!func)
    func = (int (*) (const char *, int, mode_t)) dlsym (REAL_LIBC, "open");

  va_start (args, flags);
  mode = va_arg (args, mode_t);
  va_end (args);

  /* Do not intercept sunos /dev/audioctl access */
  if ( pathname && strncmp (pathname, "/dev/audioctl", 13) && ((!strncmp (pathname, "/dev/dsp", 8)) || (!strncmp (pathname, "/dev/adsp", 9)) || (!strncmp (pathname, "/dev/audio", 10))))
    {
      if (!strncmp (pathname, "/dev/audio", 10))
	{
	NASInfo.format = AuFormatULAW8;
	DPRINTF("%s: NASInfo.format set to AuFormatULAW8\n", pathname);
	}

      /* Only one snd device open at a time, to avoid trouble with
        programs that open all available devices at startup. */
      if (sndfd == MAGIC_FD_NUM) { errno = EACCES; return -1; }

      if (mixerfd == -1) {
      	if (!nas_open(NASInfo.format, NASInfo.rate, NASInfo.channels))
		return -1;
      }

      sndfd = MAGIC_FD_NUM;
      DPRINTF("OPEN called, pathname = '%s': RETURNING sndfd %d\n", pathname, 
	      sndfd);

      return (sndfd);
    }
  if (pathname && (!strncmp (pathname, "/dev/mixer", 10)))
    {
      /* Only one mixer device open at a time, to avoid trouble with
        programs that open all available devices at startup.
	Example: gmix */
      if (mixerfd == MIXER_FD_NUM) { errno = EACCES; return -1; }

      /* Hack so that if you open a standalone mixer app, you're likely
         to modify the volume of the device you want. */
      if (sndfd == -1) {
#ifdef MIXER_HACK
        nas_open(AuFormatLinearSigned16LSB, 44100, 2);
#else
      	nas_open(NASInfo.format, NASInfo.rate, NASInfo.channels);
#endif
      }

      mixerfd = MIXER_FD_NUM;
      DPRINTF("OPEN called, pathname = '%s': RETURNING mixerfd %d\n", pathname, 
	      mixerfd);
      return (mixerfd);
    }
  else
    {
      int rv = 0;
      rv = (*func) (pathname, flags, mode);
      return(rv);
    }
}

static int
dspctl (int fd, request_t request, void *argp)
{
  int *arg = (int *) argp;
  struct audio_buf_info *info;
  int need_to_rebuild = 1;
  struct mixer_info *m;
  int tempvol = 0;

  DPRINTF ("hijacking /dev/dsp ioctl "
	   "(%d : %x - %p)\n", fd, request, argp);

  /* default is to run rebuildElements(), individual ioctl can override */

  switch (request)
    {
    case SNDCTL_DSP_RESET:
      DPRINTF("DSP: reset\n");
      nas_reset();
      break;

    case SNDCTL_DSP_SYNC:
      DPRINTF("DSP: syncing (unhandled)\n");
      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_POST:
      DPRINTF("DSP: POST (unhandled)\n");
      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_SETFMT:
    case SOUND_PCM_READ_BITS:
      DPRINTF("DSP: set format to: ");
      YELL;
      if (*arg == AFMT_QUERY)
      {
	DPRINTF("Query current format\n");
        *arg = auformat_to_aformat(NASInfo.format);
	break;
      }
      if (*arg & AFMT_MU_LAW) DPRINTF("MULAW ");
      if (*arg & AFMT_A_LAW) DPRINTF("ALAW ");
      if (*arg & AFMT_IMA_ADPCM) DPRINTF("IMA_ADPCM ");
      if (*arg & AFMT_U8) DPRINTF("U8 ");
      if (*arg & AFMT_S16_LE) DPRINTF("S16_LE ");
      if (*arg & AFMT_S16_BE) DPRINTF("S16_BE ");
      if (*arg & AFMT_S8) DPRINTF("S8 ");
      if (*arg & AFMT_U16_LE) DPRINTF("U16_LE ");
      if (*arg & AFMT_U16_BE) DPRINTF("U16_BE ");
      if (*arg & AFMT_MPEG) DPRINTF("MPEG ");
      if (*arg & AFMT_AC3) DPRINTF("AC3 ");
      DPRINTF("\n");
      NASInfo.format = aformat_to_auformat(*arg);
      break;

    case SNDCTL_DSP_SPEED:
    case SOUND_PCM_READ_RATE:
      DPRINTF("DSP: read rate or set rate to ");
      YELL;
      DPRINTF("%d\n", *arg);
      if (*arg == 0)
      {
	*arg = NASInfo.rate;
	break;
      }
      NASInfo.rate = *arg;
      break;

    case SNDCTL_DSP_GETFMTS:
      DPRINTF("DSP: reply: get formats\n");
      YELL;
      *arg = (AFMT_MU_LAW | AFMT_U8 | AFMT_S8 | AFMT_U16_LE | AFMT_U16_BE | AFMT_S16_LE |
	      AFMT_S16_BE);
      if (*arg & AFMT_MU_LAW) DPRINTF("MULAW ");
      if (*arg & AFMT_A_LAW) DPRINTF("ALAW ");
      if (*arg & AFMT_IMA_ADPCM) DPRINTF("IMA_ADPCM ");
      if (*arg & AFMT_U8) DPRINTF("U8 ");
      if (*arg & AFMT_S16_LE) DPRINTF("S16_LE ");
      if (*arg & AFMT_S16_BE) DPRINTF("S16_BE ");
      if (*arg & AFMT_S8) DPRINTF("S8 ");
      if (*arg & AFMT_U16_LE) DPRINTF("U16_LE ");
      if (*arg & AFMT_U16_BE) DPRINTF("U16_BE ");
      if (*arg & AFMT_MPEG) DPRINTF("MPEG ");
      if (*arg & AFMT_AC3) DPRINTF("AC3 ");
      DPRINTF("\n");
      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_STEREO:
      DPRINTF("DSP: set stereo");
      YELL;
      DPRINTF(" (arg = %d)\n", *arg);
      if ((*arg < 0) || (*arg > 1)) *arg = 1;
      NASInfo.channels = (*arg)+1;
      break;

    case SNDCTL_DSP_CHANNELS:
    case SOUND_PCM_READ_CHANNELS:
      DPRINTF("DSP: set or read channels");
      YELL;
      DPRINTF(" (arg = %d)\n", *arg);
      if (*arg == 0)
      {
	*arg = NASInfo.channels;
	break;
      }
      if ((*arg < 1) || (*arg > 2)) *arg = 2;
      NASInfo.channels = (*arg);
      break;

    case SNDCTL_DSP_SUBDIVIDE:
      DPRINTF("DSP: subdivide (unhandled)\n");
      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_SETFRAGMENT:
      DPRINTF("DSP: request: setfragment");
      YELL;
      DPRINTF(" (arg: %x)\n", *arg);
      DPRINTF(" fragments: %d, size: %d\n", (*arg >> 16) & 0x7fff, 1 << (*arg & 0xFFFF));
      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_GETBLKSIZE:
      DPRINTF("DSP: getblksize (exp), returning %d\n", nas_frag_size());
      YELL;
      *arg = nas_frag_size();
      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_GETCAPS:
      DPRINTF("DSP: reply: getcaps\n");
      YELL;
      *arg = DSP_CAP_BATCH;
      if (*arg & DSP_CAP_DUPLEX) DPRINTF("DUPLEX ");
      if (*arg & DSP_CAP_REALTIME) DPRINTF("REALTIME ");
      if (*arg & DSP_CAP_BATCH) DPRINTF("BATCH ");
      if (*arg & DSP_CAP_COPROC) DPRINTF("COPROC ");
      if (*arg & DSP_CAP_TRIGGER) DPRINTF("TRIGGER ");
      if (*arg & DSP_CAP_MMAP) DPRINTF("MMAP ");
      if (*arg & DSP_CAP_MULTI) DPRINTF("MULTI ");
      if (*arg & DSP_CAP_BIND) DPRINTF("BIND ");
      DPRINTF("\n");
      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_GETOSPACE:
      DPRINTF("DSP: reply: getospace\n");
      YELL;

      info = (struct audio_buf_info *) arg;

      info->fragments = nas_free_frags();
      info->fragstotal= nas_frag_count();
      info->fragsize= nas_frag_size();
      info->bytes= (info->fragsize * info->fragments) ;

      DPRINTF("fragments = %d, fragstotal = %d, fragsize = %d, bytes = %d\n",
	info->fragments, info->fragstotal, info->fragsize, info->bytes);

      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_GETISPACE:
      DPRINTF("DSP: reply: getispace\n");
      YELL;

      info = (struct audio_buf_info *) arg;

      info->fragments = 0;
      info->fragstotal = 0;
      info->fragsize = 0;
      info->bytes= (info->fragsize * info->fragments) ;

      DPRINTF("fragments = %d, fragstotal = %d, fragsize = %d, bytes = %d\n",
	info->fragments, info->fragstotal, info->fragsize, info->bytes);

      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_GETOPTR:
      DPRINTF("DSP: reply: getoptr\n");
      YELL;
      {
      	count_info *info = (count_info *) arg;

	/* Only partly implemented, but enough to work for JDK 1.3 linux ... */

        if (info == NULL) { errno = EINVAL; return -1; }
	info->bytes = bytes_written;
	info->blocks = 0;
	info->ptr = 0;
	
	DPRINTF("bytes = %d\n", info->bytes);
      }
      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_GETIPTR:
      DPRINTF("DSP: getiptr (unhandled)\n");
      YELL;
      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_NONBLOCK:
      DPRINTF("DSP: nonblock (unhandled)\n");
      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_GETTRIGGER:
      DPRINTF("DSP: gettrigger (unhandled)\n");
      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_SETTRIGGER:
      DPRINTF("DSP: settrigger (unhandled)\n");
      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_SETSYNCRO:
      DPRINTF("DSP: setsyncro (unhandled)\n");
      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_SETDUPLEX:
      DPRINTF("DSP: setduplex (unhandled)\n");
      need_to_rebuild = 0;
      break;

    case SNDCTL_DSP_GETODELAY: /* Realplayer's "new" OSS driver uses this */
      DPRINTF("DSP: getodelay");
      YELL;
      *arg = nas_getdelay(NASInfo.format, NASInfo.rate, NASInfo.channels);
      DPRINTF("reply = %d\n", *arg);
      need_to_rebuild = 0;
      break;

#if DSP_DEBUG == 1
    case SNDCTL_DSP_MAPINBUF:
      DPRINTF("DSP: mapinbuf (unhandled, returning EINVAL)\n");
      need_to_rebuild = 0;
      errno = EINVAL; return -1;

    case SNDCTL_DSP_MAPOUTBUF:
      DPRINTF("DSP: mapoutbuf (unhandled, returning EINVAL)\n");
      need_to_rebuild = 0;
      errno = EINVAL; return -1;

    case SNDCTL_DSP_GETCHANNELMASK:
      DPRINTF("DSP: getchannelmask (unhandled, returning EINVAL)\n");
      need_to_rebuild = 0;
      errno = EINVAL; return -1;

    case SNDCTL_DSP_BIND_CHANNEL:
      DPRINTF("DSP: bind_channel (unhandled, returning EINVAL)\n");
      need_to_rebuild = 0;
      errno = EINVAL; return -1;

    case SNDCTL_DSP_PROFILE:
      DPRINTF("DSP: profile (unhandled, returning EINVAL)\n");
      need_to_rebuild = 0;
      errno = EINVAL; return -1;

    case SOUND_PCM_WRITE_FILTER:
      DPRINTF("DSP: sound_pcm_write_filter -- what is this?\n");
      YELL;
      need_to_rebuild = 0;
      break;

    case SOUND_PCM_READ_FILTER:
      DPRINTF("DSP: sound_pcm_read_filter -- what is this?\n");
      YELL;
      need_to_rebuild = 0;
      break;

#endif /* if dsp_debug == 1 */

    case OSS_GETVERSION:
      DPRINTF("OSS_GETVERSION called, returning %x\n", SOUND_VERSION);
      YELL;
      *arg = SOUND_VERSION;
      need_to_rebuild = 0;
      break;

    case SOUND_MIXER_READ_BASS:
    case SOUND_MIXER_READ_TREBLE:
    case SOUND_MIXER_READ_SYNTH:
    case SOUND_MIXER_READ_SPEAKER:
    case SOUND_MIXER_READ_LINE:
    case SOUND_MIXER_READ_MIC:
    case SOUND_MIXER_READ_CD:
    case SOUND_MIXER_READ_IMIX:
    case SOUND_MIXER_READ_ALTPCM:
    case SOUND_MIXER_READ_RECLEV:
    case SOUND_MIXER_READ_IGAIN:
    case SOUND_MIXER_READ_OGAIN:
    case SOUND_MIXER_READ_LINE1:
    case SOUND_MIXER_READ_LINE2:
    case SOUND_MIXER_READ_LINE3:
    case SOUND_MIXER_READ_MUTE:

      DPRINTF("MIXER: read %x\n", request);
      errno = EINVAL;
      return -1;

    case SOUND_MIXER_WRITE_BASS:
    case SOUND_MIXER_WRITE_TREBLE:
    case SOUND_MIXER_WRITE_SYNTH:
    case SOUND_MIXER_WRITE_SPEAKER:
    case SOUND_MIXER_WRITE_LINE:
    case SOUND_MIXER_WRITE_MIC:
    case SOUND_MIXER_WRITE_CD:
    case SOUND_MIXER_WRITE_IMIX:
    case SOUND_MIXER_WRITE_ALTPCM:
    case SOUND_MIXER_WRITE_RECLEV:
    case SOUND_MIXER_WRITE_IGAIN:
    case SOUND_MIXER_WRITE_OGAIN:
    case SOUND_MIXER_WRITE_LINE1:
    case SOUND_MIXER_WRITE_LINE2:
    case SOUND_MIXER_WRITE_LINE3:
    case SOUND_MIXER_WRITE_MUTE:
    case SOUND_MIXER_WRITE_RECSRC:

      DPRINTF("MIXER: write %x\n", request);
      errno = EINVAL;
      return -1;

    case SOUND_MIXER_ACCESS:
    case SOUND_MIXER_AGC:
    case SOUND_MIXER_3DSE:
    case SOUND_MIXER_PRIVATE1:
    case SOUND_MIXER_PRIVATE2:
    case SOUND_MIXER_PRIVATE3:
    case SOUND_MIXER_PRIVATE4:
    case SOUND_MIXER_PRIVATE5:
      DPRINTF("MIXER: sound_mixer r/w obscure ioctl %x\n", request);
      errno = EINVAL;
      return -1;

    case SOUND_MIXER_READ_DEVMASK:
      DPRINTF("MIXER: read devmask\n");
      YELL;
      tempvol = nas_get_volume();
      if (tempvol != -1) {
        *arg = 0x00000011; /* NAS main volume */
	}
      else
      {
      	*arg = 0x00000000; /* NAS device does not support setting gain */
	errno = ENXIO;
	return -1;
      }
      need_to_rebuild = 0;
      break;

    case SOUND_MIXER_READ_RECSRC:
    case SOUND_MIXER_READ_CAPS:
    case SOUND_MIXER_READ_STEREODEVS:
    case SOUND_MIXER_READ_RECMASK:
      DPRINTF("MIXER: read stereodevs || recmask || recsrc || caps, all dummy and zero\n");
      YELL;
      *arg = 0x00000000; /* No stereo devices & no recording, we pretend */
      need_to_rebuild = 0;
      break;

    case SOUND_MIXER_WRITE_PCM:
    case SOUND_MIXER_WRITE_VOLUME:
      DPRINTF("MIXER: write main volume, arg = ");
      YELL;
      DPRINTF("%x\n", *arg);
      nas_set_volume(MIN(100, (*arg) & 0x000000FF));
      need_to_rebuild = 0;
      break;

    case SOUND_MIXER_READ_PCM:
    case SOUND_MIXER_READ_VOLUME:
      DPRINTF("MIXER: read main volume\n");
      YELL;
      tempvol = nas_get_volume();
      if (tempvol != -1)
        *arg = tempvol | (tempvol << 8); /* Dummy main volume */
      else
      {
	*arg = 0x00000000; errno = ENXIO; return -1;
      }
      need_to_rebuild = 0;
      break;

    case SOUND_MIXER_INFO:
      DPRINTF("MIXER: info\n");
      YELL;
      m = (struct mixer_info *) arg;
      strcpy (m->id,"NAS");
      strcpy (m->name,"libaudiooss mixer");
      need_to_rebuild = 0;
      break;

#if DSP_DEBUG == 1
    case 0x0000541B:
      DPRINTF("TIOCINQ - shouldn't happen. This is a networking ioctl. Something is probably using our fd number.\n");
      *arg = 0x00000000;
      need_to_rebuild = 0;
      break;
#endif

    default:
      DPRINTF ("unhandled /dev/dsp ioctl (%x - %p)\n", request, argp);
      need_to_rebuild = 0;
      break;
    }

  if (need_to_rebuild) rebuildElements(&NASInfo);

  return 0;
}

int
ioctl (int fd, request_t request, ...)
{
  static int (*func) (int, request_t, void *) = NULL;
  va_list args;
  void *argp;

  if (!func)                                                                    
    func = (int (*) (int, request_t, void *)) dlsym (REAL_LIBC, "ioctl");             
  va_start (args, request);
  argp = va_arg (args, void *);
  va_end (args);

  if ((fd != -1) && ((fd == mixerfd) || (fd == sndfd)) )
    return dspctl (fd, request, argp);
  else /* (fd != sndfd && fd != mixfd) */
    return (*func) (fd, request, argp); 
}

/* fcntl: needed for MPEGTV - now mtvp works, woohoo! :-) */

int
fcntl(int fd, int cmd, ...)
{
  static int (*func) (int, int, void *) = NULL;
  va_list args;
  void *argp;

  if (!func)                                                                    
    func = (int (*) (int, int, void *)) dlsym (REAL_LIBC, "fcntl");

  va_start (args, cmd);
  argp = va_arg (args, void *);
  va_end (args);

  if ((fd != -1) && (fd == sndfd))
  {
    DPRINTF ("hijacking /dev/dsp fcntl() "
	     "(%d : %x - %p)\n", fd, cmd, argp);
    if (cmd == F_GETFL) return O_RDWR;
    if (cmd == F_DUPFD)
    {
	DPRINTF("fcntl F_DUPFD (%d,%ld) called\n", fd, *((long *)argp));

    	sndfd = *((long *)argp);
	return *((long *)argp);
    }
    return 0;
  }
  else
  {
    return (*func) (fd, cmd, argp);
  }
  return 0;
}

int
select (int n, fd_set *readfds, fd_set *writefds,
	fd_set *exceptfds, struct timeval *timeout)
{
  static int (*func) (int, fd_set *, fd_set *, fd_set *, struct timeval *) = NULL;

  if (!func)                                                                    
    func = (int (*) (int, fd_set *, fd_set *, fd_set *, struct timeval *)) dlsym (REAL_LIBC, "select");

  if ((sndfd != -1) && (writefds != NULL) && (FD_ISSET(sndfd, writefds)))
  {
    /* No, no exceptions happened. */
    if (exceptfds != NULL) FD_ZERO(exceptfds);

    /* If there are other files being watched via the select(), like a buffering read
       pipe, give it every other select(). */
    if ((selectcounter == 1) && (readfds != NULL))
	{
	    FD_CLR(sndfd, writefds);
	    selectcounter = 0;
	    DPRINTF("audiooss: select() with both read and write part. Defering to the read part, probably our bufferer.\n");
            return (*func) (n, readfds, writefds, exceptfds, timeout);
	}
    else if ((selectcounter == 0) && (readfds != NULL))
	{
	    FD_ZERO(readfds);
	    FD_ZERO(writefds);
	    FD_SET(sndfd, writefds);
	    selectcounter = 1;
	    DPRINTF("audiooss: select() with both read and write part. My turn now.\n");
	}
    DPRINTF ("audiooss: hijacking /dev/dsp select() [output]\n");
    return 1;
  }
  else
  {
    return (*func) (n, readfds, writefds, exceptfds, timeout);
  }
}

int
close (int fd)
{
  static int (*func) (int) = NULL;

  if (!func)
    func = (int (*) (int)) dlsym (REAL_LIBC, "close");

  if ((fd != -1) && (fd == sndfd))
  {
    DPRINTF("CLOSE() (fd == sndfd) called\n");

    sndfd = -1;

    if (mixerfd == -1)
    	nas_close();
    
    return 0;
  }
 
  /* if sndfd != MAGIC_FD_NUM anymore, and someone try to close MAGIC_FD_NUM,
     we don't need to do anything. Reference counts and fd tables is overkill. */
  if (fd == MAGIC_FD_NUM) return 0;

  if ((fd != -1) && (fd == mixerfd))
  {
    DPRINTF("CLOSE() (fd == mixerfd) called\n");

    mixerfd = -1;

    if (sndfd == -1)
    	nas_close();

    return 0;
  }

  return (*func) (fd);
}

int
dup2 (int oldfd, int newfd)
{
  static int (*func) (int, int) = NULL;

  if (!func)
    func = (int (*) (int, int)) dlsym (REAL_LIBC, "dup2");

  if ((oldfd == sndfd) && (oldfd != -1) && (newfd != -1))
  {
    DPRINTF("dup2(%d,%d) (oldfd == sndfd) called\n", oldfd, newfd);

    /* Do not close(newfd) as that would mark it available for reuse by the system -
       just tell the program that yes, we got the fd you asked for. Hackish. */
    sndfd = newfd;
    return newfd;
  }
  return (*func) (oldfd, newfd);
}

# define strong_alias(name, aliasname) \
  extern __typeof (name) aliasname __attribute__ ((alias (#name)))
strong_alias(open, __open);
strong_alias(close, __close);
strong_alias(write, __write);
strong_alias(ioctl, __ioctl);
strong_alias(fcntl, __fcntl);
strong_alias(select, __select);
