package ClamTk::App;

use strict;
use Carp qw/croak/;
$|++;

use encoding 'utf8';

my ( $num_of_sigs, $date_of_sigs );
my ( $DAILY_PATH,  $MAIN_PATH );
my ( $INFO_MAIN,   $INFO_DATE, $INFO_DAILY );

sub new {
    my ( $class, $self ) = @_;

    $self->{directory} = $ENV{HOME} || glob "~";
    $self->{clamtk}    = $self->{directory} . "/.clamtk";
    $self->{viruses}   = $self->{clamtk} . "/viruses";
    $self->{history}   = $self->{clamtk} . "/history";
    $self->{prefs}     = $self->{clamtk} . "/prefs";
    $self->{db}        = $self->{clamtk} . "/db";

    $self->{freshclam}
        = ( -e '/usr/bin/freshclam' ) ? '/usr/bin/freshclam'
        : ( -e '/usr/local/bin/freshclam' ) ? '/usr/local/bin/freshclam'
        : ( -e '/opt/local/bin/freshclam' ) ? '/opt/local/bin/freshclam'
        :                                     croak "freshclam not found!\n";

    $self->{clampath}
        = ( -e '/usr/bin/clamscan' ) ? '/usr/bin/clamscan'
        : ( -e '/usr/local/bin/clamscan' ) ? '/usr/local/bin/clamscan'
        : ( -e '/opt/local/bin/clamscan' ) ? '/opt/local/bin/clamscan'
        :                                    croak "clamscan not found!\n";

    $self->{clamscan} = $self->{clampath};

    # Below is a stupid hack because Debian ripped
    # rar/unrar and apparently unzip functionality from ClamAV.
    # And CentOS. And OpenSuse. And...
    # Just removing it altogether for now.
    #if ( -e '/etc/issue' ) {
    #    if ( open( my $issue, "<", '/etc/issue' ) ) {
    #        my $slurp = do {
    #            local $/ = undef;
    #            <$issue>;
    #        };
    #        close($issue);
    #        if ( $slurp !~ /Debian|Ubuntu|CentOS/gi ) {
    #            $self->{clamscan} .=
    #                  ( -e '/usr/bin/unrar' ) ? ' --unrar=/usr/bin/unrar'
    #                : ( -e '/usr/bin/rar' )   ? ' --unrar=/usr/bin/rar'
    #                : ( -e '/usr/local/bin/unrar' )
    #                ? '--unrar=/usr/local/bin/unrar'
    #                : ( -e '/usr/local/bin/rar' )
    #                ? '--unrar=/usr/local/bin/rar'
    #                : '';
    #
    #            $self->{clamscan} .=
    #                  ( -e '/usr/bin/unzip' ) ? ' --unzip=/usr/bin/unzip'
    #                : ( -e '/usr/local/bin/unzip' )
    #                ? ' --unzip=/usr/local/bin/unzip'
    #                : '';
    #        }
    #    }
    #}

    # End of stupid hack

    $self->{clamscan} .= " --no-summary --block-encrypted ";

    return bless( $self, $class );
}

sub def_paths {

    # There are 3 formats:
    # 1. The .cld files
    # 2. The .cvd files
    # 3. The {daily,main}.info directories
    # The .cld seems to be popular now, so check for that first.

    my @dirs = qw#
        /var/lib/clamav
        /var/clamav
        /opt/local/share/clamav
        /usr/share/clamav
        /usr/local/share/clamav
        #;

    my $user_set = 0;
    if ( ClamTk::Prefs->get_property( $main::scanner, "Update" ) eq 'single' )
    {
        $user_set = 1;
        unshift( @dirs, $main::scanner->{db} );
    }

    for my $dir_list (@dirs) {
        if ( -e "$dir_list/daily.cld" ) {
            $DAILY_PATH = "$dir_list/daily.cld";
        }
        elsif ( -e "$dir_list/daily.cvd" ) {
            $DAILY_PATH = "$dir_list/daily.cvd";
        }
        if ( -e "$dir_list/main.cld" ) {
            $MAIN_PATH = "$dir_list/main.cld";
        }
        elsif ( -e "$dir_list/main.cvd" ) {
            $MAIN_PATH = "$dir_list/main.cvd";
        }
        last if ( $DAILY_PATH && $MAIN_PATH );

        # the user may have set single - may need to update db
        last if ($user_set);
    }

    if ( !$DAILY_PATH && !$MAIN_PATH ) {
        for my $dir_list (
            '/var/lib/clamav',         '/var/clamav',
            '/opt/local/share/clamav', '/usr/share/clamav',
            '/usr/local/share/clamav'
            )
        {
            if ( -e "$dir_list/daily.inc/daily.info" ) {
                $DAILY_PATH = "$dir_list/daily.inc/daily.info";
            }
            if ( -e "$dir_list/main.inc/main.info" ) {
                $MAIN_PATH = "$dir_list/main.inc/main.info";
            }
        }

    }
}

sub get_AV_version {
    my ($class)   = shift;
    my ($self)    = shift;
    my ($version) = `$self->{clampath} -V`;
    $version =~ s/ClamAV\s(.*?)\/.*/$1/;
    chomp($version);
    return $version;
}

sub get_AV_remote {
    my ($class)  = shift;
    my ($self)   = shift;
    my $host_cmd = '/usr/bin/host';
    if ( not -e $host_cmd ) {
        return 'unavailable';
    }
    my $rmt_host = 'current.cvd.clamav.net';

    # set the alarm in case we're not connected to the
    # worldwide intertubes
    my $get;
    eval {
        local $SIG{ALRM} = sub { die "failed\n" };
        alarm 3;
        ($get) = `$host_cmd -t txt $rmt_host`;
        alarm 0;
    };
    if ( $@ && $@ eq "failed\n" ) {
        return 'undef';
    }
    chomp($get);

    if ( $get =~ /.*?"(.*?):/ ) {
        return $1;
    }
    else {
        return 'undef';
    }
}

sub get_num_sigs {
    get_sig_info();
    return ( $INFO_MAIN + $INFO_DAILY );
}

sub get_date_sigs {
    get_sig_info();
    return $INFO_DATE;
}

sub get_sig_info {
    def_paths();
    warn "I don't have any paths!\n" unless ( $MAIN_PATH && $DAILY_PATH );
    if ($MAIN_PATH) {
        my $FILE;
        if ( open( $FILE, "<", $MAIN_PATH ) ) {
            while (<$FILE>) {
                if (/ClamAV-VDB:\S+\s+\S+\s+\S+.*?\+\d+:\d+:(\d+)/) {
                    $INFO_MAIN = $1;
                    last;
                }
                close($FILE);
            }
        }
        else {
            $INFO_MAIN = 0;
        }
    }
    else {
        $INFO_MAIN = 0;
    }

    if ($DAILY_PATH) {
        my $FILE;
        if ( open( $FILE, "<", $DAILY_PATH ) ) {
            while (<$FILE>) {
                if (/ClamAV-VDB:(\S+\s+\S+\s+\S+).*\+\d+:\d+:(\d+)/) {
                    $INFO_DATE  = $1;
                    $INFO_DAILY = $2;
                    last;
                }
            }
            close($FILE);
        }
        else {
            $INFO_DATE  = '01 Jan 1970';
            $INFO_DAILY = 0;
        }
    }
}

1;
