package ClamTk::Prefs;

use strict;
$|++;

use encoding 'utf8';

use File::Path;
use Config::Tiny;
use Locale::gettext;
use POSIX qw/locale_h/;
textdomain("clamtk");
setlocale( LC_MESSAGES, "" );
bind_textdomain_codeset( "clamtk", "UTF-8" );

my $pkg;

sub start_up {
    my ($class) = shift;
    my ($self)  = shift;
    if ( !-d $self->{viruses} ) {
        eval { mkpath( $self->{viruses}, 0, oct(777) ); };
        return 0 if ($@);
    }
    else {
        chmod oct(777), $self->{viruses};
    }
    if ( !-d $self->{history} ) {
        eval { mkpath( $self->{history}, 0, oct(777) ); };
        return 0 if ($@);
    }
    else {
        chmod oct(777), $self->{history};
    }
    if ( !-d $self->{db} ) {
        eval { mkpath( $self->{db}, 0, oct(777) ); };
        warn $@  if $@;
        return 0 if ($@);
    }
    else {
        chmod oct(777), $self->{db};
    }
    if ( !-e $self->{prefs} ) {
        eval { create_prefs() };
        return 0 if ($@);
    }

    return 1;
}

sub custom_prefs {

   # ensure prefs have normalized variables, especially for 3.11 -> 4.00 users
    my ($class) = shift;
    my ($self)  = shift;
    $pkg = Config::Tiny->read( $self->{prefs} );
    my $sl     = $pkg->{_}->{SaveToLog}     ||= 0;
    my $sh     = $pkg->{_}->{ScanHidden}    ||= 0;
    my $limit  = $pkg->{_}->{SizeLimit}     ||= 0;
    my $t      = $pkg->{_}->{Thorough}      ||= 0;
    my $ls     = $pkg->{_}->{LastScan}      ||= gettext('Never');
    my $li     = $pkg->{_}->{LastInfection} ||= gettext('Never');
    my $update = $pkg->{_}->{Update}        ||= 'undef';

    my $count
        = ClamTk::Prefs->set_all( $main::scanner, $sl, $sh, $limit, $t, $ls,
        $li, $update );
    return $count;
}

sub create_prefs {
    my ($class) = shift;
    my ($self)  = shift;
    $pkg                       = Config::Tiny->new();
    $pkg->{_}->{SaveToLog}     = 0;
    $pkg->{_}->{ScanHidden}    = 0;
    $pkg->{_}->{SizeLimit}     = 0;
    $pkg->{_}->{Thorough}      = 0;
    $pkg->{_}->{LastScan}      = gettext('Never');
    $pkg->{_}->{LastInfection} = gettext('Never');
    $pkg->{_}->{Update}        = 'undef';               # shared or single
    $pkg->write( $self->{prefs} ) or do {
        warn $Config::Tiny::errstr, "\n";
        return "failed";
    };
}

sub get_all_prefs {
    my ($class) = shift;
    my ($self)  = shift;
    $pkg = Config::Tiny->read( $self->{prefs} );
    return $pkg if $pkg;
}

sub set_all {
    my ($class) = shift;
    my ($self)  = shift;
    my ( $save_log, $hidden, $size_set, $thorough, $last_scan, $last_infected,
        $update )
        = @_;
    $pkg                       = Config::Tiny->new();
    $pkg->{_}->{SaveToLog}     = $save_log;
    $pkg->{_}->{ScanHidden}    = $hidden;
    $pkg->{_}->{SizeLimit}     = $size_set;
    $pkg->{_}->{Thorough}      = $thorough;
    $pkg->{_}->{LastScan}      = $last_scan;
    $pkg->{_}->{LastInfection} = $last_infected;
    $pkg->{_}->{Update}        = $update;
    $pkg->write( $self->{prefs} ) or do {
        warn $Config::Tiny::errstr, "\n";
        return 0;
    };
    return 1;
}

sub get_property {
    my ($class)  = shift;
    my ($self)   = shift;
    my ($wanted) = shift;
    $pkg = Config::Tiny->read( $self->{prefs} );
    return unless $pkg;
    return $pkg->{_}->{$wanted} || '';
}

1;
