package ClamTk::Results;

use strict;
use File::Basename;
use File::Copy;

use encoding 'utf8';

use Gtk2;
use Gtk2::SimpleList;
use Glib qw/TRUE FALSE/;

use ClamTk::GUI;

use Locale::gettext;
use POSIX qw/locale_h/;
textdomain("clamtk");
setlocale( LC_MESSAGES, "" );
bind_textdomain_codeset( "clamtk", "UTF-8" );

my $popup;
my $slist;
my $hover_label;

sub display {
    my ($class) = shift;
    my ($self)  = shift;
    my ($cmd_scan) = shift;
    my ($hash)  = @_;

    $popup = Gtk2::Window->new();
    $popup->signal_connect( destroy => sub { $popup->destroy } );
    $popup->set_default_size( 600, 250 );
    $popup->set_title( gettext('Scanning Results') );

    my $pbox = Gtk2::VBox->new();
    $popup->add($pbox);
    $hover_label = 
	($cmd_scan == 0) ?
        Gtk2::Label->new( gettext('Possible infections have been found.') ) :
	($cmd_scan == 1) ?
        Gtk2::Label->new( gettext('The scan is complete.') ) :
	'';
    $pbox->pack_start( $hover_label, FALSE, FALSE, 5 );

    # This scrolled window holds the slist
    my $scrolled_win = Gtk2::ScrolledWindow->new;
    $pbox->pack_start( $scrolled_win, TRUE, TRUE, 0 );
    $scrolled_win->set_shadow_type('etched_in');
    $scrolled_win->set_policy( 'never', 'automatic' );

    $slist = Gtk2::SimpleList->new(
        gettext('File')         => 'markup',
        gettext('Status')       => 'markup',
        gettext('Action Taken') => 'markup',
    );
    $scrolled_win->add($slist);
    $scrolled_win->grab_focus();
    $slist->get_selection->set_mode('single');
    $slist->set_rules_hint(TRUE);
    $slist->set_headers_clickable(TRUE);

    # can't be reorderable - messes up the \&row_clicked function
    $slist->set_reorderable(FALSE);
    map { $_->set_resizable(TRUE) } $slist->get_columns;

    #map { $_->set_fixed_width(250) } $slist->get_columns;
    #map { $_->set_sizing('fixed') } $slist->get_columns;

    $slist->set(
        hover_selection => TRUE,
        hover_expand    => TRUE
    );

    # Display the possible infections
    for my $keys ( sort keys %$hash ) {
        push @{ $slist->{data} },
            [
            $hash->{$keys}->{name}, $hash->{$keys}->{status},
            $hash->{$keys}->{action},
            ];
        Gtk2->main_iteration while ( Gtk2->events_pending );
    }

    my $tooltips = Gtk2::Tooltips->new;
    $tooltips->set_tip( $slist,
        gettext("Select a file and right-click for options...") );
    $tooltips->disable;

    # below: the right-click functionality. also uses 'sub confirm'.
    $slist->signal_connect(
        button_press_event => sub {
            my ( $widget, $event ) = @_;
            return FALSE unless $event->button == 3;
            my @sel   = $slist->get_selected_indices;
            my $deref = $sel[0];
            defined $deref or return;

            my $menu = Gtk2::Menu->new();
            my $quar_pop
                = Gtk2::ImageMenuItem->new( gettext('Quarantine this file') );
            my $quar_image
                = Gtk2::Image->new_from_stock( 'gtk-refresh', 'menu' );
            $quar_pop->set_image($quar_image);
            if ( $hash->{$deref}->{name}
                =~ /\.(thunderbird|mozilla-thunderbird|evolution|mozilla)/ )
            {
                $hover_label->set_text(
                    gettext(
                        'Possible email file - please manually quarantine or delete it.'
                    )
                );
            } elsif( -d $hash->{$deref}->{name} ) {
		return;
	    }
            else {
                $quar_pop->signal_connect(
                    activate => sub { main_confirm( $deref, "q", \$hash ) } );
            }
            $quar_pop->show();
            $menu->append($quar_pop)
                unless dirname( $hash->{$deref}->{name} )
                    =~ /^\/(proc|sys|dev)/;

            my $delete_pop
                = Gtk2::ImageMenuItem->new( gettext('Delete this file') );
            my $del_image
                = Gtk2::Image->new_from_stock( 'gtk-delete', 'menu' );
            $delete_pop->set_image($del_image);
            if ( $hash->{$deref}->{name}
                =~ /\.(thunderbird|mozilla-thunderbird|evolution|mozilla)/ )
            {
                $hover_label->set_text(
                    gettext(
                        'Possible email file - please manually quarantine or delete it.'
                    )
                );
            } elsif( -d $hash->{$deref}->{name} ) {
		return;
	    }
            else {
                $delete_pop->signal_connect(
                    activate => sub { main_confirm( $deref, "d", \$hash ) } );
            }
            $delete_pop->show();
            $menu->append($delete_pop)
                unless dirname( $hash->{$deref}->{name} )
                    =~ /^\/(proc|sys|dev)/;

            my $save_pop
                = Gtk2::ImageMenuItem->new_from_stock( 'gtk-save-as', undef );
            $save_pop->signal_connect(
                activate => sub {
		    return if(-d $hash->{$deref}->{name});
                    my $save_dialog = Gtk2::FileChooserDialog->new(
                        gettext('Save As...'), undef, 'save',
                        'gtk-cancel' => 'cancel',
                        'gtk-ok'     => 'ok',
                    );
                    $save_dialog->set_do_overwrite_confirmation(TRUE);
                    $save_dialog->set_default_response('ok');

                    if ( "ok" eq $save_dialog->run ) {
                        my $tmp = $save_dialog->get_filename;
                        $save_dialog->destroy();
                        move( $hash->{$deref}->{name}, $tmp )
                            or do {
                            show_message_dialog( $popup, 'error', 'close',
                                gettext("Could not save that file.") );
                            return FALSE;
                            };
			$hash->{$deref}->{action} = gettext('Moved');
			main_confirm( $deref, "s", \$hash );
                        show_message_dialog( $popup, 'info', 'close',
                            gettext("File saved.") );
                            return FALSE;
                    }
                    else {
                        $save_dialog->destroy();
                    }
                }
            );
            $save_pop->show();
            $menu->append($save_pop);

            my $cancel_pop
                = Gtk2::ImageMenuItem->new_from_stock( 'gtk-cancel', undef );
            $cancel_pop->signal_connect( activate => sub { return; } );
            $cancel_pop->show();
            $menu->append($cancel_pop);

            $menu->popup( undef, undef, undef, undef, $event->button,
                $event->time );

            return TRUE;
        }
    );
    $popup->show_all();
}

sub main_confirm {
    my $number  = shift;
    my $do_this = shift;
    my ($found) = shift;

    if ( $do_this eq "q" ) {
        if ( not -e $$found->{$number}->{name} ) {
            $hover_label->set_text(
                sprintf gettext("File has been moved or deleted already.") );
            $slist->{data}[$number][0]
                = "<span foreground='#CCCCCC'>$$found->{$number}->{name}</span>";
            $slist->{data}[$number][1]
                = "<span foreground='#CCCCCC'>$$found->{$number}->{status}</span>";
            $slist->{data}[$number][2]
                = "<span foreground='#CCCCCC'>$$found->{$number}->{action}</span>";
            return;
        }
        if ( move_to_quarantine( $number, $found ) ) {
            $hover_label->set_text( gettext("File has been quarantined.") );
            $$found->{$number}->{action}
                = sprintf gettext("<b>Quarantined</b>");
        }
        else {
            $hover_label->set_text(
                gettext("File could not be quarantined.") );
            return;
        }
    }
    elsif ( $do_this eq "d" ) {
        if ( not -e $$found->{$number}->{name} ) {
            $hover_label->set_text(
                gettext("File has been moved or deleted already.") );
            $slist->{data}[$number][0]
                = "<span foreground='#CCCCCC'>$$found->{$number}->{name}</span>";
            $slist->{data}[$number][1]
                = "<span foreground='#CCCCCC'>$$found->{$number}->{status}</span>";
            $slist->{data}[$number][2]
                = "<span foreground='#CCCCCC'>$$found->{$number}->{action}</span>";
            return;
        }
        my $confirm_message = gettext("Really delete this file?");
        my $confirm
            = Gtk2::MessageDialog->new( $popup,
            [qw(modal destroy-with-parent)],
            'question', 'ok-cancel', $confirm_message );

        if ( "cancel" eq $confirm->run ) {
            $confirm->destroy;
            return;
        }
        else {
            $confirm->destroy;
            if ( unlink( $$found->{$number}->{name} ) ) {
                $hover_label->set_text( gettext("File has been deleted.") );
                $$found->{$number}->{action}
                    = sprintf gettext("<b>Deleted</b>");
            }
            else {
                $hover_label->set_text(
                    gettext("File could not be deleted.") );
                return;
            }
        }
    } elsif( $do_this eq 's' ) {
        #if ( not -e $$found->{$number}->{name} ) {
            #$hover_label->set_text(
            #    sprintf gettext("File has been moved or deleted already.") );
            $slist->{data}[$number][0]
                = "<span foreground='#CCCCCC'>$$found->{$number}->{name}</span>";
            $slist->{data}[$number][1]
                = "<span foreground='#CCCCCC'>$$found->{$number}->{status}</span>";
            $slist->{data}[$number][2]
                = "<span foreground='#CCCCCC'>$$found->{$number}->{action}</span>";
            return;
        }
    main_slist_delete( $number, $found );
}

sub main_slist_delete {
    my $number = shift;
    my ($found) = shift;
    $slist->{data}[$number][0]
        = "<span foreground='#CCCCCC'>$$found->{$number}->{name}</span>";
    $slist->{data}[$number][1]
        = "<span foreground='#CCCCCC'>$$found->{$number}->{status}</span>";
    $slist->{data}[$number][2]
        = "<span foreground='#CCCCCC'>$$found->{$number}->{action}</span>";
    $popup->queue_draw;
}

sub move_to_quarantine {
    my $number   = shift;
    my ($found)  = shift;
    my $basename = basename( $$found->{$number}->{name} );
    if (   not -e $main::scanner->{viruses}
        or not -d $main::scanner->{viruses} )
    {
        show_message_dialog( $popup, 'info', 'close',
            gettext("Quarantine directory does not exist.") );
        return;
    }
    chmod oct(600), $$found->{$number}->{name};
    system(
        "mv",
        $$found->{$number}->{name},
        "$main::scanner->{viruses}/$basename"
    );
    rename(
        "$main::scanner->{viruses}/$basename",
        "$main::scanner->{viruses}/$basename.VIRUS"
    );
    if ( not -e $$found->{$number}->{name} ) {
        return 1;
    }
    else {
        return -1;
    }
}

sub show_message_dialog {
    my ( $parent, $type, $button, $message ) = @_;

    my $dialog;
    $dialog
        = Gtk2::MessageDialog->new_with_markup( $parent,
        [qw(modal destroy-with-parent)],
        $type, $button, $message );

    $dialog->run;
    $dialog->destroy;
    return;
}

1;
