# -*- coding: ascii -*-

###########################################################################
# clive, video extraction utility
# Copyright (C) 2007-2008 Toni Gundogdu
#
# This file is part of clive.
#
# clive is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# clive is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with clive.  If not, see <http://www.gnu.org/licenses/>.
###########################################################################

__all__ = ['touni', 'tostr']

from clive.opts import Options

## Convert object to unicode string (utf-8 by default)
def touni(s, encoding='utf-8'):
    if isinstance(s,basestring):
        if not isinstance(s,unicode):
            s = unicode(s,encoding)
    return s

## Convert unicode string to locale encoding
def tostr(s):
    if not isinstance(s, unicode):
        s = touni(s)
    s = s.encode(Options()._opts.encoding,'ignore')
    return s
