/*
                               Editable GtkCList

	A GtkCList with menu and buttons for editing.

	Uses the Floating Prompt for cell editing.
 */

#ifndef EDITCLIST_H
#define EDITCLIST_H

#include <gtk/gtk.h>


typedef struct _editclist_struct        editclist_struct;


/*
 *	Editable GtkCList:
 */
struct _editclist_struct {

	GtkWidget	*toplevel,
			*add_btn,
			*edit_btn,
			*remove_btn,
			*up_btn,
			*down_btn,
			*clist,
			*menu,
			*add_mi,
			*edit_mi,
			*remove_mi,
			*up_mi,
			*down_mi;

	/* Last selected row and column */
	gint		sel_row,
			sel_column;

	/* Row and column that the float prompt is mapped over */
	gint		fprompt_row,
			fprompt_column;


	/* Cell Selected Callback */
	void		(*cell_selected_cb)(
		editclist_struct *,	/* Edit CList */
		gint, gint,		/* Row, Column */
		gpointer		/* Data */
	);
	gpointer	cell_selected_data;

	/* Cell Unselected Callback */
	void		(*cell_unselected_cb)(
		editclist_struct *,	/* Edit CList */
		gint, gint,		/* Row, Column */
		gpointer		/* Data */
	);
	gpointer	cell_unselected_data;

	/* Row Added Callback */
	void		(*row_added_cb)(
		editclist_struct *,	/* Edit Clist */
		gint,			/* Row */
		gpointer		/* Data */
	);
	gpointer	row_added_data;

	/* Cell Changed Callback */
	void		(*cell_changed_cb)(
		editclist_struct *,	/* Edit CList */
		gint, gint,		/* Row, Column */
		gpointer		/* Data */
	);
	gpointer	cell_changed_data;

	/* Row Removed Callback */
	void		(*row_removed_cb)(
		editclist_struct *,	/* Edit CList */
		gint,			/* Row */
		gpointer		/* Data */
	);
	gpointer	row_removed_data;

};
#define EDITCLIST(p)	((editclist_struct *)(p))
#define EDITCLIST_TOPLEVEL(p)	(((p) != NULL) ? \
 (EDITCLIST(p)->toplevel) : NULL)
#define EDITCLIST_CLIST(p)	(((p) != NULL) ? \
 (EDITCLIST(p)->clist) : NULL)


extern GtkWidget *EditCListGetCList(editclist_struct *ec);

extern gint EditCListInsertRow(editclist_struct *ec, gint row);
extern gint EditCListAppendRow(editclist_struct *ec);
extern void EditCListSetCellText(
	editclist_struct *ec, gint row, gint column,
	const gchar *text
);
extern void EditCListSetCellPixText(
	editclist_struct *ec, gint row, gint column,
	const gchar *text, gint spacing,
	GdkPixmap *pixmap, GdkBitmap *mask
);
extern void EditCListSetCellPixmap(
	editclist_struct *ec, gint row, gint column,
	GdkPixmap *pixmap, GdkBitmap *mask
);
extern void EditCListGetCellText(
	editclist_struct *ec, gint row, gint column,
	gchar **text
);
extern void EditCListGetCellPixText(
	editclist_struct *ec, gint row, gint column,
	gchar **text, gint *spacing,
	GdkPixmap **pixmap, GdkBitmap **mask
);
extern void EditCListGetCellPixmap(
	editclist_struct *ec, gint row, gint column,
	GdkPixmap **pixmap, GdkBitmap **mask
);
extern void EditCListRemoveRow(editclist_struct *ec, gint row);
extern void EditCListClear(editclist_struct *ec);

extern void EditCListSetRowData(
	editclist_struct *ec, const gint row,
	gpointer data, GtkDestroyNotify destroy_func_cb
);
extern gpointer EditCListGetRowData(editclist_struct *ec, const gint row);

extern editclist_struct *EditCListNew(
	GtkWidget *parent,		/* GtkBox or GtkContainer */
	gint width, gint height,
	gboolean expand, gboolean fill, guint padding,
	gchar **heading, gint columns
);
extern void EditCListSetCellSelectedCB(
	editclist_struct *ec,
	void (*func_cb)(editclist_struct *, gint, gint, gpointer),
	gpointer data
);
extern void EditCListSetCellUnselectedCB(
	editclist_struct *ec,
	void (*func_cb)(editclist_struct *, gint, gint, gpointer),
	gpointer data
);
extern void EditCListSetRowAddedCB(
	editclist_struct *ec,
	void (*func_cb)(editclist_struct *, gint, gpointer),
	gpointer data
);
extern void EditCListSetCellChangedCB(
	editclist_struct *ec,
	void (*func_cb)(editclist_struct *, gint, gint, gpointer),
	gpointer data
);
extern void EditCListSetRowRemovedCB(
	editclist_struct *ec,
	void (*func_cb)(editclist_struct *, gint, gpointer),
	gpointer data
);
extern void EditCListUpdateMenus(editclist_struct *ec);
extern void EditCListMap(editclist_struct *ec);
extern void EditCListUnmap(editclist_struct *ec);
extern void EditCListDelete(editclist_struct *ec);


#endif	/* EDITCLIST_H */
