#ifndef EDV_CONFIRM_H
#define EDV_CONFIRM_H

#include <gtk/gtk.h>

#include "url.h"
#include "edv_types.h"


/* Basic */
extern gint EDVConfirmLink(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path, const gint nobjs,
	const gchar *tar_path
);
extern gint EDVConfirmMove(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path, const gint nobjs,
	const gchar *tar_path
);
extern gint EDVConfirmCopy(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path, const gint nobjs,
	const gchar *tar_path
);
extern gint EDVConfirmDelete(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path, const gint nobjs
);

/* Archive */
extern gint EDVConfirmArchiveAdd(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path, const gint nobjs,
	const gchar *arch_path
);
extern gint EDVConfirmArchiveExtract(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path, const gint nobjs,
	const gchar *tar_path
);
extern gint EDVConfirmArchiveDelete(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path, const gint nobjs
);

/* Recover & Purge */
extern gint EDVConfirmRecover(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path,
	const gint nobjs,
	const gchar *tar_path
);
extern gint EDVConfirmPurge(
	edv_core_struct *core, GtkWidget *toplevel,
	const gchar *src_path,
	const gint nobjs
);

/* DND */
extern gint EDVConfirmDND(
	edv_core_struct *core,
	const gint gdk_action, const guint info,
	GtkWidget *toplevel,
	GList *url_list,
	const gchar *tar_path
);


#endif	/* EDV_CONFIRM_H */
