/*
			Endeavour Object Finding
 */

#ifndef EDV_FIND_H
#define EDV_FIND_H

#include <sys/stat.h>
#include <glib.h>


/*
 *	Relativity:
 */
typedef enum {
	EDV_FIND_EQUAL_TO,
	EDV_FIND_NOT_EQUAL_TO,
	EDV_FIND_LESS_THAN,
	EDV_FIND_GREATER_THAN
} edv_find_relativity;


/* Archive Object */
extern gint EDVFindArchiveObjectByName(
	edv_core_struct *core,
	const gchar *arch_path,
	const gchar *expression,
	const gboolean case_sensitive,
	gint (*progress_cb)(const gchar *, const gfloat, gpointer),
	gpointer progress_data,
	void (*match_cb)(const gchar *, struct stat *, gpointer),
	gpointer match_data
);
extern gint EDVFindArchiveObjectBySize(
	edv_core_struct *core,
	const gchar *arch_path,
        const gulong size,
        const edv_find_relativity relativity,
        gint (*progress_cb)(const gchar *, const gfloat, gpointer),
        gpointer progress_data,
        void (*match_cb)(const gchar *, struct stat *, gpointer),
        gpointer match_data
);
extern gint EDVFindArchiveObjectByModifyTime(
	edv_core_struct *core,
	const gchar *arch_path,
        const gulong t,
        const edv_find_relativity relativity,
        gint (*progress_cb)(const gchar *, const gfloat, gpointer),
        gpointer progress_data,
        void (*match_cb)(const gchar *, struct stat *, gpointer),
        gpointer match_data
);

/* Recycled Object */
extern gint EDVFindRecycledObjectByName(
	const gchar *index_path,
	const gchar *expression,
	const gboolean case_sensitive,
	gint (*progress_cb)(const gchar *, const gfloat, gpointer),
	gpointer progress_data,
	void (*match_cb)(const gchar *, struct stat *, gpointer),
	gpointer match_data
);
extern gint EDVFindRecycledObjectByContent(
	const gchar *index_path,
	const gchar *expression,
	const gboolean case_sensitive,
	gint (*progress_cb)(const gchar *, const gfloat, gpointer),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *, struct stat *,
		const gchar *, const gint,
		gpointer
	),
	gpointer match_data
);
extern gint EDVFindRecycledObjectBySize(
        const gchar *index_path,
        const gulong size,
        const edv_find_relativity relativity,
        gint (*progress_cb)(const gchar *, const gfloat, gpointer),
        gpointer progress_data,
        void (*match_cb)(const gchar *, struct stat *, gpointer),
        gpointer match_data
);
extern gint EDVFindRecycledObjectByModifyTime(
        const gchar *index_path,
        const gulong t,
        const edv_find_relativity relativity,
        gint (*progress_cb)(const gchar *, const gfloat, gpointer),
        gpointer progress_data,
        void (*match_cb)(const gchar *, struct stat *, gpointer),
        gpointer match_data
);

/* Object */
extern gint EDVFindObjectByName(
	const gchar *start_path,
	const gchar *expression,
	const gboolean recursive,
	const gboolean follow_links,
	const gboolean case_sensitive,
	gint (*progress_cb)(const gchar *, const gfloat, gpointer),
	gpointer progress_data,
	void (*match_cb)(const gchar *, struct stat *, gpointer),
	gpointer match_data
);
extern gint EDVFindObjectByContent(
	const gchar *start_path,
	const gchar *expression,
	const gboolean recursive,
	const gboolean follow_links,
	const gboolean case_sensitive,
	gint (*progress_cb)(const gchar *, const gfloat, gpointer),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *, struct stat *,
		const gchar *, const gint,
		gpointer
	),
	gpointer match_data
);
extern gint EDVFindObjectBySize(
	const gchar *start_path,
	const gulong size,
	const gboolean recursive,
	const gboolean follow_links,
	const edv_find_relativity relativity,
	gint (*progress_cb)(const gchar *, const gfloat, gpointer),
	gpointer progress_data,
	void (*match_cb)(const gchar *, struct stat *, gpointer),
	gpointer match_data
);
extern gint EDVFindObjectByModifyTime(
	const gchar *start_path,
	const gulong t,
	const gboolean recursive,
	const gboolean follow_links,
	const edv_find_relativity relativity,
	gint (*progress_cb)(const gchar *, const gfloat, gpointer),
	gpointer progress_data,
	void (*match_cb)(const gchar *, struct stat *, gpointer),
	gpointer match_data
);


#endif	/* EDV_FIND_H */
