/*
                        Endeavour Recycled Object
 */

#ifndef EDV_RECYCLED_OBJ_H
#define EDV_RECYCLED_OBJ_H

#include <sys/stat.h>
#include <glib.h>
#include "edv_types.h"


typedef struct _edv_recycled_object_struct	edv_recycled_object_struct;
#define EDV_RECYCLED_OBJECT(p)			((edv_recycled_object_struct *)(p))


/*
 *	Recycled Object:
 */
struct _edv_recycled_object_struct {

	/* Type */
	edv_object_type	type;

	/* Recycle bin index number, a unique identifier used to
	 * reference this recycled object
	 */
	guint		index;

	/* Original name of object */
	gchar		*name;

	/* Full path to the original location excluding the object's name */
	gchar		*original_path;

	/* Deleted Time (in seconds since EPOCH) */
	gulong		deleted_time;

	/* Size (in bytes) */
	gulong		size;

	/* Link (only for EDV_OBJECT_TYPE_LINK) )*/
	gchar		*link_target;

	/* Permissions */
	edv_permission_flags permissions;

	/* Time Stamps (in seconds since EPOCH) */
	gulong		access_time,
			modify_time,
			change_time;

	/* Ownership */
	gint		owner_id,
			group_id;

};


extern edv_recycled_object_struct *EDVRecycledObjectNew(void);
extern edv_recycled_object_struct *EDVRecycledObjectCopy(
	edv_recycled_object_struct *obj
);
extern void EDVRecycledObjectSetStat(
        edv_recycled_object_struct *obj,
	struct stat *lstat_buf
);
extern void EDVRecycledObjectSetToStat(
        struct stat *lstat_buf,
	edv_recycled_object_struct *obj
);
extern void EDVRecycledObjectClear(edv_recycled_object_struct *obj);
extern void EDVRecycledObjectDelete(edv_recycled_object_struct *obj);


#endif	/* EDV_RECYCLED_OBJ_H */
