/*
		    Endeavour Utilities (GTK+ Dependent)
 */

#ifndef EDV_UTILS_GTK_H
#define EDV_UTILS_GTK_H

#include <gtk/gtk.h>

#include "cfg.h"
#include "edv_types.h"
#include "edv_cursor.h"
#include "edv_device.h"
#include "edv_mime_type.h"
#include "edv_obj.h"


/* Accelerator Key Matching */
extern gint EDVMatchAccelKeyOPID(
	const cfg_item_struct *cfg_list, const gchar *parm,
	const guint accel_key, const guint accel_mods
);
extern cfg_accelkey_struct *EDVMatchAccelKey(
	const cfg_item_struct *cfg_list, const gchar *parm,
	const gint opid
);

/* Pixmaps */
extern void EDVResizePixmap(
	GdkPixmap *pixmap, GdkBitmap *mask,
	const gint width, const gint height, 
	GdkPixmap **pixmap_rtn, GdkBitmap **mask_rtn
);
extern gboolean EDVLoadPixmap(
	edv_core_struct *core,
	guint8 **data, const gchar *name,
	GdkPixmap **pixmap_rtn, GdkBitmap **mask_rtn
);
extern GdkPixmap *EDVNewProgressPixmap(
	const gint width, const gint height,
	const gfloat coeff,
	const gboolean draw_value,
	const GtkOrientation orientation, const gboolean reverse,
	GtkStyle *style,
	GdkBitmap **mask_rtn
);
extern GtkWidget *EDVNewPixmapWidget(
	edv_core_struct *core,
	guint8 **data, const gchar *name
);

/* Cursors */
extern GdkCursor *EDVGetCursor(
	edv_core_struct *core, const edv_cursor_code code
);

/* GtkCTree Nodes */
extern gint EDVNodeGetLevel(GtkCTreeNode *node);
extern GtkCTreeNode *EDVNodeGetParent(GtkCTreeNode *node);
extern GtkCTreeNode *EDVNodeGetChild(GtkCTreeNode *node);
extern GtkCTreeNode *EDVNodeGetSibling(GtkCTreeNode *node);
extern GtkCTreeNode *EDVNodeGetToplevel(GtkCTree *ctree);

/* GtkCList & GtkCTree Utilities */
extern gint EDVCListGetSelectedLast(
	GtkCList *clist, GtkCListRow **row_ptr_rtn
);
extern GtkCTreeNode *EDVCTreeGetSelectedLast(
	GtkCTree *ctree, GtkCTreeRow **row_ptr_rtn
);
extern gboolean EDVNodeGetIndex(
	GtkCTree *ctree, GtkCTreeNode *node,
	gint *row_rtn, gint *column_rtn
);
extern GtkCTreeNode *EDVNodeGetByCoordinates(
	GtkCTree *ctree, const gint x, const gint y
);
extern void EDVScrollCListToPosition(
	GtkCList *clist, gfloat hpos, gfloat vpos
);

/* Endeavour Window Matching */
extern gboolean EDVMatchWindowFromToplevel(
	edv_core_struct *core, GtkWidget *toplevel,
	gint *browser_num,
	gint *imbr_num,
	gint *archiver_num,
	gint *recbin_num
);

/* Object Checking */
extern gboolean EDVIsObjectNameValid(const gchar *name);
extern gboolean EDVIsObjectNameHidden(const gchar *name); 
extern gboolean EDVIsObjectHidden(edv_object_struct *obj);

/* Write Protect Utilities */
extern gboolean EDVCheckWriteProtect(
	edv_core_struct *core,
	const gboolean verbose, GtkWidget *toplevel
);

/* Permission Checking */
extern gboolean EDVCheckUIDIsOwner(gint effective_uid, gint owner_id);
extern gboolean EDVCheckIsOwner(edv_core_struct *core, gint owner_id);
extern gboolean EDVIsObjectAccessable(
	edv_core_struct *core, edv_object_struct *obj
);
extern gboolean EDVIsObjectReadable(
	edv_core_struct *core, edv_object_struct *obj
);
extern gboolean EDVIsObjectWriteable(
	edv_core_struct *core, edv_object_struct *obj
);
extern gboolean EDVIsObjectExecutable(
	edv_core_struct *core, edv_object_struct *obj
);

/* Internal Supported Object Type Checking */
extern gboolean EDVCheckImlibImage(
	edv_core_struct *core, const gchar *name
);
extern gboolean EDVCheckEDVArchiverArchive(
	edv_core_struct *core, const gchar *name
);

/* Object MIME Type Matching Utilities */
extern gint EDVMatchObjectIcon(
	edv_device_struct **device, const gint total_devices,
	edv_mime_type_struct **mimetype, const gint total_mimetypes,
	const edv_object_type type,
	const gchar *path,	/* Full path or just the name */
	const gboolean link_valid,
	const edv_permission_flags permissions,
	const gint icon_size,	/* 0 = small, 1 = medium, 2 = large */
	GdkPixmap **pixmap_closed, GdkBitmap **mask_closed,
	GdkPixmap **pixmap_opened, GdkBitmap **mask_opened,
	GdkPixmap **pixmap_extended, GdkBitmap **mask_extended,
	GdkPixmap **pixmap_hidden, GdkBitmap **mask_hidden
);
extern gint EDVMatchObjectTypeString(
	edv_mime_type_struct **mimetype, const gint total_mimetypes,
	const edv_object_type type,
	const edv_permission_flags permissions,
	const gchar *path,	/* Full path or just the name */
	gchar **type_str
);

/* Message Output */
extern void EDVMessage(
	const gchar *title, const gchar *message, const gchar *details,
	GtkWidget *toplevel
);
extern void EDVMessageInfo(
	const gchar *title, const gchar *message, const gchar *details,
	GtkWidget *toplevel
);
extern void EDVMessageWarning(
	const gchar *title, const gchar *message, const gchar *details,
	GtkWidget *toplevel
);
extern void EDVMessageError(
	const gchar *title, const gchar *message, const gchar *details,
	GtkWidget *toplevel
);
extern void EDVMessageObjectOPError(
	const gchar *title,
	const gchar *message,
	const gchar *path,
	GtkWidget *toplevel
);
extern void EDVMessageFromFile(
	const gchar *path, const gchar *title,
	gint cdialog_icon,
	GtkWidget *toplevel
);

/* Play Sound */
extern void EDVBeep(edv_core_struct *core);
extern void EDVPlaySoundBeep(edv_core_struct *core);
extern void EDVPlaySoundInfo(edv_core_struct *core);
extern void EDVPlaySoundQuestion(edv_core_struct *core);
extern void EDVPlaySoundWarning(edv_core_struct *core);
extern void EDVPlaySoundError(edv_core_struct *core);
extern void EDVPlaySoundCompleted(edv_core_struct *core);

/* Menu & Button Interaction */
extern void EDVMenuButtonMapMenu(GtkWidget *menu, GtkWidget *button);

/* Window Centering */
extern void EDVCenterWindowToWindow(GtkWidget *w1, GtkWidget *w2);
extern void EDVCenterWindowToWindowOffset(
	GtkWidget *w1, GtkWidget *w2, gint x_offset, gint y_offset
);

/* GtkEditable & GtkEntry Endowments */
extern void EDVEntrySetDND(edv_core_struct *core, GtkWidget *w);
extern void EDVEntrySetCompletePath(edv_core_struct *core, GtkWidget *w);

/* Scrolled Window Setup Utilities */
extern GtkWidget *EDVScrolledWindowNew(
	GtkPolicyType hscrollbar_policy,
	GtkPolicyType vscrollbar_policy,
	GtkWidget **event_box_rtn,
	GtkWidget **vbox_rtn
);

/* Copy Object Path Utilities */
extern void EDVCopyDiskObjectsToDDEPath(
	edv_core_struct *core,
	GList *objs_list,
	GtkWidget *owner
);
extern void EDVCopyDiskObjectsToDDEURL(
	edv_core_struct *core,
	GList *objs_list,
	GtkWidget *owner
);

/* Style Utilities */
extern GtkRcStyle *EDVCreateRCStyleFromCfg(
	const cfg_style_struct *style
);

/* History Utilities */
extern void EDVAppendHistory(
	edv_core_struct *core,
	const edv_history_type type,
	const gulong time_start,
	const gulong time_end,
	const gint status,
	const gchar *src_path,
	const gchar *tar_path,
	const gchar *comments
);


#endif	/* EDV_UTILS_GTK_H */
