/*
		    Endeavour Image Browser Callbacks
 */

#ifndef IMBR_CB_H
#define IMBR_CB_H

#include <sys/stat.h>
#include <gtk/gtk.h>
#include "edv_device.h"
#include "edv_mime_type.h"
#include "imbr.h"


/* GTK+ Signal Callbacks */
extern void EDVImbrCmdDestroyCB(gpointer data);
extern void EDVImbrTListItemDestroyCB(gpointer data);

extern gint EDVImbrDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern gint EDVImbrKeyEventCB(
	 GtkWidget *widget, GdkEventKey *key, gpointer data
);
extern gint EDVImbrButtonPressEventCB(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);

extern void EDVImbrHandleChildAttachedCB(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);
extern void EDVImbrHandleChildDetachedCB(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);

extern void EDVImbrTListSelectCB(
	tlist_struct *tlist, GdkEventButton *button, gint thumb_num,
	gpointer data
);
extern void EDVImbrTListUnselectCB(
	tlist_struct *tlist, GdkEventButton *button, gint thumb_num,
	gpointer data
);

extern void EDVImbrComboActivateCB(GtkWidget *widget, gpointer data);

extern gint EDVImbrLoadThumbsPassiveTOCB(gpointer data);

/* Menu Item Callbacks */
extern void EDVImbrMenuItemCB(GtkWidget *widget, gpointer data);
extern gint EDVImbrMenuItemEnterCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVImbrMenuItemLeaveCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern void EDVImbrMenuItemCmdObjectOpCB(GtkWidget *widget, gpointer data);
extern void EDVImbrMenuItemCmdNewObjectCB(GtkWidget *widget, gpointer data);
extern gint EDVImbrMenuItemCmdEnterCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVImbrMenuItemCmdLeaveCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);

/* Paths List Get Callback */
extern GList *EDVImbrGetSelectedPathsListCB(gpointer data);

/* Go To Directory Callback */
extern void EDVImbrGotoDirectoryCB(gpointer data, const gchar *path);

/* Mount Bar Callbacks */
extern void EDVImbrMountBarMountCB(
	edv_mount_bar_struct *mb, gint dev_num, edv_device_struct *dev,
	gpointer data
);
extern void EDVImbrMountBarEjectCB(
	edv_mount_bar_struct *mb, gint dev_num, edv_device_struct *dev,
	gpointer data
);
extern void EDVImbrMountBarGoToCB(
	edv_mount_bar_struct *mb, gint dev_num, edv_device_struct *dev,
	gpointer data
);

/* Find Bar Callbacks */
extern const gchar *EDVImbrFindBarLocationCB(
	edv_find_bar_struct *fb,
	gpointer data
);
extern void EDVImbrFindBarStartCB(
	edv_find_bar_struct *fb,
	gpointer data
);
extern void EDVImbrFindBarEndCB(
	edv_find_bar_struct *fb,
	const gint nmatches,
	gpointer data
);
extern void EDVImbrFindBarMatchCB(
	const gchar *path,
	struct stat *lstat_buf,
	const gchar *excerpt,
	const gint line_index,
	gpointer data
);

/* Status Bar Callbacks */
extern void EDVImbrStatusMessageCB(const gchar *message, gpointer data);
extern void EDVImbrStatusProgressCB(const gfloat progress, gpointer data);

/* Write Protect Changed Callback */
extern void EDVImbrWriteProtectChangedCB(
	edv_imbr_struct *imbr, gboolean state
);

/* Object Callbacks */
extern void EDVImbrObjectAddedNotifyCB(
	edv_imbr_struct *imbr, const gchar *path,
	struct stat *lstat_buf
);
extern void EDVImbrObjectModifiedNotifyCB(
	edv_imbr_struct *imbr, const gchar *path,
	const gchar *new_path,
	struct stat *lstat_buf
);
extern void EDVImbrObjectRemovedNotifyCB(
	edv_imbr_struct *imbr, const gchar *path
);

/* Mount/Unmount Callback */
extern void EDVImbrMountNotifyCB(
	edv_imbr_struct *imbr,
	const gint dev_num, edv_device_struct *dev,
	const gboolean is_mounted
);

/* Recycled Object Callbacks */
extern void EDVImbrRecycledObjectAddedNotifyCB(
	edv_imbr_struct *imbr, const guint index
);
extern void EDVImbrRecycledObjectModifiedNotifyCB(
	edv_imbr_struct *imbr, const guint index
);
extern void EDVImbrRecycledObjectRemovedNotifyCB(
	edv_imbr_struct *imbr, const guint index
);

/* Reconfigured Callback */
extern void EDVImbrReconfiguredNotifyCB(edv_imbr_struct *imbr);

/* MIME Type Callbacks */
extern void EDVImbrMimeTypeAddedCB(
	edv_imbr_struct *imbr,
	const gint mt_num, edv_mime_type_struct *mt
);
extern void EDVImbrMimeTypeModifiedCB(
	edv_imbr_struct *imbr,
	const gint mt_num, edv_mime_type_struct *mt
);
extern void EDVImbrMimeTypeRemovedCB(
	edv_imbr_struct *imbr,
	const  gint mt_num
);

/* Device Callbacks */
extern void EDVImbrDeviceAddedCB(
	edv_imbr_struct *imbr,
	const gint dev_num, edv_device_struct *dev
);
extern void EDVImbrDeviceModifiedCB(
	edv_imbr_struct *imbr,
	const gint dev_num, edv_device_struct *dev
);
extern void EDVImbrDeviceRemovedCB(
	edv_imbr_struct *imbr,
	const gint dev_num
);


#endif	/* IMBR_CB_H */
