/*
			 Window Creation & Mapping
 */

#ifndef EDV_WINDOW_H
#define EDV_WINDOW_H

#include <glib.h>
#include "edv_context.h"

/*
 *	Creates a new File Browser.
 */
extern void EDVWindowBrowserNew(
	edv_context_struct *ctx, const gchar *path
);
#define EDVWindowFileBrowserNew		EDVWindowBrowserNew

/*
 *	Creates a new Image Browser.
 */
extern void EDVWindowImageBrowserNew(
	edv_context_struct *ctx, const gchar *path
);

/*
 *	Creates a new Archiver.
 */
extern void EDVWindowArchiverNew(
	edv_context_struct *ctx, const gchar *path
);

/*
 *	Maps the Recycle Bin.
 */
extern void EDVWindowRecycleBinMap(edv_context_struct *ctx);


/*
 *	Creates a new Properties Dialog.
 */
extern void EDVWindowPropertiesDialogNewWithPage(
	edv_context_struct *ctx, const gchar *path,
	const gchar *page_name
);
extern void EDVWindowPropertiesDialogNew(
	edv_context_struct *ctx, const gchar *path
);


/*
 *	Maps the Options Window.
 */
extern void EDVWindowOptionsWindowMapWithPage(
	edv_context_struct *ctx, const gchar *page_name
);
extern void EDVWindowOptionsWindowMap(edv_context_struct *ctx);


/*
 *      Maps the Customize Window.
 */
extern void EDVWindowCustomizeWindowMapWithPage(
	edv_context_struct *ctx, const gchar *page_name
);
extern void EDVWindowCustomizeWindowMap(edv_context_struct *ctx);


/*
 *      Maps the Devices Window.
 */
extern void EDVWindowDevicesWindowMap(edv_context_struct *ctx);

/*
 *      Maps the MIME Types Window.
 */
extern void EDVWindowMIMETypesWindowMap(edv_context_struct *ctx);


/*
 *      Maps the Run Dialog.
 */
extern void EDVWindowRunDialogMapWithCommand(
	edv_context_struct *ctx, const gchar *command
);
extern void EDVWindowRunDialogMap(edv_context_struct *ctx);


/*
 *	Maps the Find Window.
 */
extern void EDVWindowFindWindowMapWithLocation(
	edv_context_struct *ctx, const gchar *location
);
extern void EDVWindowFindWindowMap(edv_context_struct *ctx);


/*
 *      Maps the About Dialog.
 */
extern void EDVWindowAboutDialogMapWithPage(
	edv_context_struct *ctx, const gchar *page_name
);
extern void EDVWindowAboutDialogMap(edv_context_struct *ctx);
#define EDVWindowAbout	EDVWindowAboutDialogMap
#define EDVAbout	EDVWindowAboutDialogMap

#endif	/* EDV_WINDOW_H */
