/*
	Endeavour Mark II API compile time configuration reporter

	Prints compile time locations to stdout.
 */

#include <stdio.h>
#include <string.h>
#include "config.h"

#ifdef PROG_USAGE_MESG
# undef PROG_USAGE_MESG
#endif
#define PROG_USAGE_MESG	"\
Usage: endeavour2-config [options]\n\
\n\
    Where [options] can be any of the following:\n\
\n\
	--cflags                Prints compiler flags.\n\
	--libs                  Prints libraries and library paths.\n\
	--help                  Prints (this) help screen and exits.\n\
	--version               Prints version information and exits.\n\
\n"


#define CFLAGS	"\
-I/usr/lib/endeavour2/include"

#define LIBS	"\
-lendeavour2"


int main(int argc, char *argv[])
{
	int i;
	char *arg_ptr;

	if(argc <= 1)
	{
	    printf("%s", PROG_USAGE_MESG);
	    fflush(stdout);
	    return(0);
	}

	for(i = 1; i < argc; i++)
	{
	    arg_ptr = argv[i];
	    if(arg_ptr == NULL)
		continue;

	    /* Print help? */
	    if(!strcmp(arg_ptr, "--help") ||
	       !strcmp(arg_ptr, "-help") ||
	       !strcmp(arg_ptr, "--h") ||
	       !strcmp(arg_ptr, "-h") ||
	       !strcmp(arg_ptr, "-?") ||
	       !strcmp(arg_ptr, "/?")
	    )
	    {
		printf("%s", PROG_USAGE_MESG);
		fflush(stdout);
	    }
	    /* Print version? */
	    else if(!strcmp(arg_ptr, "--version") ||
		     !strcmp(arg_ptr, "-version") ||
		     !strcmp(arg_ptr, "--v") ||
		     !strcmp(arg_ptr, "-v")
	    )
	    {
		printf("%s\n", PROG_VERSION);
		fflush(stdout);
	    }
	    /* Print cflags? */
	    else if(!strcmp(arg_ptr, "--cflags") ||
		     !strcmp(arg_ptr, "-cflags") ||
		     !strcmp(arg_ptr, "--c") ||
		     !strcmp(arg_ptr, "-c")
	    )
	    {
		printf("%s\n", CFLAGS);
		fflush(stdout);
	    }
	    /* Print libs? */
	    else if(!strcmp(arg_ptr, "--libs") ||
		     !strcmp(arg_ptr, "-libs") ||
		     !strcmp(arg_ptr, "--l") ||
		     !strcmp(arg_ptr, "-l")
	    )
	    {
		printf("%s\n", LIBS);
		fflush(stdout);
	    }
	    /* All else print help. */
	    else
	    {
		printf("%s", PROG_USAGE_MESG);
		fflush(stdout);
	    }
	}

	return(0);
}
