/* pygphoto.i */
%module pygphoto_lowlevel
%include "typemaps.i"
%include exception.i
%{
/* Put header files here (optional) */
#include <gphoto2/gphoto2-abilities-list.h>
#include <gphoto2/gphoto2-camera.h>
#include <gphoto2/gphoto2-list.h>
%}

extern int gp_list_count( CameraList * );

enum  CameraFileType {
  GP_FILE_TYPE_PREVIEW, GP_FILE_TYPE_NORMAL, GP_FILE_TYPE_RAW, GP_FILE_TYPE_AUDIO,
  GP_FILE_TYPE_EXIF, GP_FILE_TYPE_METADATA
};

%{

#define MAX_MSG_LEN 1024


static unsigned int progress_start (GPContext *context, float target,
                         const char *format, va_list args, void *data) {

	char message[MAX_MSG_LEN + 1];

        /* get the python context */
        PyObject* pyContext = (PyObject*)data;
        /* create the argument list */
        vsnprintf (message, MAX_MSG_LEN, format, args);
        /* call */
	PyObject* pyResult = PyObject_CallMethod(pyContext, "progress_start", 
						 "(fs)", target, message);
	/* turn result into a C uint */
        unsigned int id = 0;
        PyArg_Parse(pyResult, "I", &id);
        /* cleanup */
	Py_DECREF(pyResult);
	return id;
}


static void
progress_update (GPContext *context, unsigned int id,
                          float current, void * data)
{
        /* get the python context */
        PyObject* pyContext = (PyObject*)data;
        /* call */
	PyObject* dummy = PyObject_CallMethod(pyContext, "progress_update", 
						 "(If)", id, current);
        /* cleanup */
	Py_XDECREF(dummy);
}

static void
progress_stop (GPContext *context, unsigned int id, void *data)
{
        /* get the python context */
        PyObject* pyContext = (PyObject*)data;
        /* call */
	PyObject* dummy = PyObject_CallMethod(pyContext, "progress_stop", 
						 "(I)", id);
        /* cleanup */
	Py_XDECREF(dummy);
}


static GPContext* context_map(PyObject* pyContext){
/* create a GPContext from a pygphoto Context */

/* if pyContext is null or Py_None, return Null */
	if( !pyContext || pyContext == Py_None )
		return NULL;
/* else create a Context with the wrapper functions as progress
   functions and the pyContext as data */
	GPContext* context = gp_context_new();
	gp_context_set_progress_funcs(context, progress_start, 
				      progress_update, progress_stop, (void*)pyContext);
/* increment ref count to pyContext */
	Py_INCREF(pyContext);
	return context;
}


static void context_free(GPContext* gpContext, PyObject* pyContext){

/* do nothing if gpContext is Null */
	if(!gpContext)
		return;
/* unref gpContext */
	gp_context_unref(gpContext);
/* decrement reference count to pyContext */
	Py_XDECREF(pyContext);
}


static int errorcode = 0;

%}


%exception {
	errorcode = 0;
	$function
	if ( errorcode < 0 ){
		SWIG_exception(SWIG_IOError, gp_result_as_string(errorcode));
	};
}


%inline %{

CameraList * gp_detectcameras( )
{
        CameraList * pList = NULL ; 
        gp_list_new( &pList ) ;
        CameraAbilitiesList *al;
        GPPortInfoList *il;

        gp_abilities_list_new (&al);
        gp_abilities_list_load (al, NULL);
        gp_port_info_list_new (&il);
        gp_port_info_list_load (il);
        gp_abilities_list_detect (al, il, pList, NULL);
        gp_abilities_list_free (al);
        gp_port_info_list_free (il); 
        return pList ;
}

const char* gp_name( CameraList * pList, int index )
{
	const char * name ;
	gp_list_get_name( pList, index, &name ) ;
	return name ;
} 

const char * gp_value( CameraList * pList, int index )
{
	const char * value ;
	gp_list_get_value( pList, index, &value ) ;
	return value ;
}

Camera * gp_camera( const char * name, const char * port )
{
	Camera * pCamera ;
        int x, count ;
        CameraAbilitiesList *al ;
	CameraAbilities a ;
        GPPortInfoList *il ;
	GPPortInfo info ;

        gp_abilities_list_new(&al) ;
        gp_abilities_list_load(al, NULL) ;
        gp_port_info_list_new(&il) ;
        gp_port_info_list_load(il) ;
	x = gp_abilities_list_lookup_model (al, name);
	gp_abilities_list_get_abilities (al, x, &a);
	gp_port_info_list_get_info( il, x, &info ) ;
	x = gp_port_info_list_lookup_path (il, port);
	gp_port_info_list_get_info (il, x, &info);

	gp_camera_new( &pCamera ) ;
	gp_camera_set_abilities( pCamera, a ) ;
	gp_camera_set_port_info( pCamera, info ) ;

        gp_abilities_list_free(al) ;
        gp_port_info_list_free(il) ; 
	return pCamera ;
}


void gp_init(Camera* camera, PyObject* pyContext){ 
	GPContext* context = context_map(pyContext);
	errorcode = gp_camera_init(camera, context);
	context_free(context, pyContext);
}


void gp_exit(Camera* camera, PyObject* pyContext ){
	GPContext* context = context_map(pyContext);
	gp_camera_exit(camera, context);
	context_free(context, pyContext);
}



CameraList * gp_newlist( )
{
	CameraList * pList ;
	gp_list_new( &pList ) ;
	return pList ;
}

CameraList * gp_getsubfolders( Camera * pCamera, const char * pFolder, PyObject* pyContext )
{
	CameraList * pList ;
	GPContext* context = context_map(pyContext);

	gp_list_new( &pList ) ;
	errorcode = gp_camera_folder_list_folders( pCamera, pFolder, pList, context );
	context_free(context, pyContext);
	if(errorcode < 0){
		gp_list_unref(pList);
		return NULL;
	};
	return pList ;
}

CameraList * gp_getfiles( Camera * pCamera, const char * pFolder, PyObject* pyContext )
{
	CameraList * pList ;
	GPContext* context = context_map(pyContext);
	gp_list_new( &pList ) ;
	errorcode = gp_camera_folder_list_files( pCamera, pFolder, pList, context ) ;
	context_free(context, pyContext);
	if(errorcode < 0){
		gp_list_unref(pList);
		return NULL;
	};
	return pList ;
}


CameraFile * gp_getfile( Camera * pCamera, const char * pFolder, 
                         const char * pFilename, CameraFileType filetype, PyObject* pyContext  )
{
	CameraFile * file ;	
	GPContext* context = context_map(pyContext);
	gp_file_new(&file) ;
	errorcode = gp_camera_file_get (pCamera, pFolder, pFilename, filetype,
			    file, context);
	context_free(context, pyContext);
	if(errorcode < 0){
		gp_file_unref(file);
                return NULL;
	};
	return file;
}


PyObject * gp_readfile( CameraFile * pFile )
{
	const char * data ;
	unsigned long length ;
 	errorcode = gp_file_get_data_and_size( pFile, &data, &length ) ;
	return PyString_FromStringAndSize( data, length ) ;
}


PyObject* gp_getmimetype(Camera* pCamera, const char* pFolder, 
                           const char* pFilename, PyObject* pyContext){
	CameraFileInfo info;
	GPContext* context = context_map(pyContext);
	errorcode = gp_camera_file_get_info(pCamera, pFolder, pFilename, &info, context);
	context_free(context, pyContext);
	if(errorcode < 0)
		return NULL;
	return Py_BuildValue("s", info.file.type);
}


%}



