/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  displaysignals.cc - Gdk::Display virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "display.hh"
#include "displaysignals.hh"
#include "private/displayclass.hh"

using namespace GFC;

/*  Gdk::DisplaySignals
 */

Gdk::DisplaySignals::DisplaySignals(Display *display)
: G::ObjectSignals(display)
{
	Gdk::DisplayClass::init(GDK_DISPLAY_GET_CLASS(display->gdk_display()));
}

Gdk::DisplaySignals::~DisplaySignals()
{
}
	
void
Gdk::DisplaySignals::on_closed(bool is_error)
{
	GdkDisplayClass *g_class = DisplayClass::get_parent_class(instance_);
	if (g_class->closed)
		g_class->closed((GdkDisplay*)instance_, is_error);
}

/*  Gdk::DisplayClass
 */

void
Gdk::DisplayClass::init(GdkDisplayClass *g_class)
{
	g_class->closed = &closed_proxy;
}

GdkDisplayClass*
Gdk::DisplayClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GDK_DISPLAY_GET_CLASS(instance));
	return static_cast<GdkDisplayClass*>(ptr);
}

GType
Gdk::DisplayClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GDK_TYPE_DISPLAY);
	}
	return type;
}

void*
Gdk::DisplayClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gdk::DisplayClass::closed_proxy(GdkDisplay *display, gboolean is_error)
{
	void *ptr = g_object_get_qdata((GObject*)display, G::ObjectSignals::quark());
	if (ptr)
		static_cast<DisplaySignals*>(ptr)->on_closed(is_error);
	else
	{
		GdkDisplayClass *g_class = DisplayClass::get_parent_class(display);
		if (g_class->closed)
			g_class->closed(display, is_error);
	}
}

