/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  treemodelsignals.cc - Gtk::TreeModel virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "treemodel.hh"
#include "treemodelsignals.hh"
#include "private/treemodeliface.hh"
#include <gfc/glib/object.hh>
#include <gfc/glib/objectsignals.hh>

using namespace GFC;

/*  Gtk::TreeModelSignals
 */

Gtk::TreeModelSignals::TreeModelSignals(TreeModel *tree_model)
{
	Gtk::TreeModelIface::init(GTK_TREE_MODEL_GET_IFACE(tree_model->gtk_tree_model()));
}

Gtk::TreeModelSignals::~TreeModelSignals()
{
}

void
Gtk::TreeModelSignals::on_row_changed(const TreePath& path, const TreeIter& iter)
{
	GtkTreeModelIface *g_iface = TreeModelIface::get_parent_iface(instance_);
	if (g_iface->row_changed)
		g_iface->row_changed((GtkTreeModel*)instance_, path.gtk_tree_path(), iter.gtk_tree_iter());
}

void
Gtk::TreeModelSignals::on_row_inserted(const TreePath& path, const TreeIter& iter)
{
	GtkTreeModelIface *g_iface = TreeModelIface::get_parent_iface(instance_);
	if (g_iface->row_inserted)
		g_iface->row_inserted((GtkTreeModel*)instance_, path.gtk_tree_path(), iter.gtk_tree_iter());
}

void
Gtk::TreeModelSignals::on_row_has_child_toggled(const TreePath& path, const TreeIter& iter)
{
	GtkTreeModelIface *g_iface = TreeModelIface::get_parent_iface(instance_);
	if (g_iface->row_has_child_toggled)
		g_iface->row_has_child_toggled((GtkTreeModel*)instance_, path.gtk_tree_path(), iter.gtk_tree_iter());
}

void
Gtk::TreeModelSignals::on_row_deleted(const TreePath& path)
{
	GtkTreeModelIface *g_iface = TreeModelIface::get_parent_iface(instance_);
	if (g_iface->row_deleted)
		g_iface->row_deleted((GtkTreeModel*)instance_, path.gtk_tree_path());
}

void
Gtk::TreeModelSignals::on_rows_reordered(const TreePath& path, const TreeIter& iter, int *new_order)
{
	GtkTreeModelIface *g_iface = TreeModelIface::get_parent_iface(instance_);
	if (g_iface->rows_reordered)
		g_iface->rows_reordered((GtkTreeModel*)instance_, path.gtk_tree_path(), iter.gtk_tree_iter(), new_order);
}

/*  Gtk::TreeModelIface
 */

void
Gtk::TreeModelIface::init(GtkTreeModelIface *g_iface)
{
	g_iface->row_changed = &row_changed_proxy;
	g_iface->row_inserted = &row_inserted_proxy;
	g_iface->row_has_child_toggled = &row_has_child_toggled_proxy;
	g_iface->row_deleted = &row_deleted_proxy;
	g_iface->rows_reordered = &rows_reordered_proxy;
}

GtkTreeModelIface*
Gtk::TreeModelIface::get_parent_iface(void *instance)
{
	void *ptr = g_type_interface_peek_parent(GTK_TREE_MODEL_GET_IFACE(instance));
	return static_cast<GtkTreeModelIface*>(ptr);
}

void
Gtk::TreeModelIface::row_changed_proxy(GtkTreeModel *tree_model, GtkTreePath *path, GtkTreeIter *iter)
{
	void *ptr = g_object_get_qdata((GObject*)tree_model, G::ObjectSignals::quark());
	if (ptr)
	{
		TreePath tmp_path(path);
		TreeIter tmp_iter(iter);
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TreeModelSignals*>(object)->on_row_changed(tmp_path, tmp_iter);
	}
	else
	{
		GtkTreeModelIface *g_iface = TreeModelIface::get_parent_iface(tree_model);
		if (g_iface->row_changed)
			g_iface->row_changed(tree_model, path, iter);
	}
}

void
Gtk::TreeModelIface::row_inserted_proxy(GtkTreeModel *tree_model, GtkTreePath *path, GtkTreeIter *iter)
{
	void *ptr = g_object_get_qdata((GObject*)tree_model, G::ObjectSignals::quark());
	if (ptr)
	{
		TreePath tmp_path(path);
		TreeIter tmp_iter(iter);
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TreeModelSignals*>(object)->on_row_inserted(tmp_path, tmp_iter);
	}
	else
	{
		GtkTreeModelIface *g_iface = TreeModelIface::get_parent_iface(tree_model);
		if (g_iface->row_inserted)
			g_iface->row_inserted(tree_model, path, iter);
	}
}

void
Gtk::TreeModelIface::row_has_child_toggled_proxy(GtkTreeModel *tree_model, GtkTreePath *path, GtkTreeIter *iter)
{
	void *ptr = g_object_get_qdata((GObject*)tree_model, G::ObjectSignals::quark());
	if (ptr)
	{
		TreePath tmp_path(path);
		TreeIter tmp_iter(iter);
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TreeModelSignals*>(object)->on_row_has_child_toggled(tmp_path, tmp_iter);
	}
	else
	{
		GtkTreeModelIface *g_iface = TreeModelIface::get_parent_iface(tree_model);
		if (g_iface->row_has_child_toggled)
			g_iface->row_has_child_toggled(tree_model, path, iter);
	}
}

void
Gtk::TreeModelIface::row_deleted_proxy(GtkTreeModel *tree_model, GtkTreePath *path)
{
	void *ptr = g_object_get_qdata((GObject*)tree_model, G::ObjectSignals::quark());
	if (ptr)
	{
		TreePath tmp_path(path);
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TreeModelSignals*>(object)->on_row_deleted(tmp_path);
	}
	else
	{
		GtkTreeModelIface *g_iface = TreeModelIface::get_parent_iface(tree_model);
		if (g_iface->row_deleted)
			g_iface->row_deleted(tree_model, path);
	}
}

void
Gtk::TreeModelIface::rows_reordered_proxy(GtkTreeModel *tree_model, GtkTreePath *path, GtkTreeIter *iter, gint *new_order)
{
	void *ptr = g_object_get_qdata((GObject*)tree_model, G::ObjectSignals::quark());
	if (ptr)
	{
		TreePath tmp_path(path);
		TreeIter tmp_iter(iter);
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TreeModelSignals*>(object)->on_rows_reordered(tmp_path, tmp_iter, new_order);
	}
	else
	{
		GtkTreeModelIface *g_iface = TreeModelIface::get_parent_iface(tree_model);
		if (g_iface->rows_reordered)
			g_iface->rows_reordered(tree_model, path, iter, new_order);
	}
}

