import docutils.writers
import docutils
import parser
import docutils.core
import os
import sys

# TODO : pack .IP a bit more. actually, adding a '\n' must be more
# 'contextual'
#######################################################################
# Custom writers
#######################################################################

class Translator(docutils.nodes.NodeVisitor):
    def __init__(self, d, f):
        docutils.nodes.NodeVisitor.__init__(self,d)
        self.file = f
        self.section = 0
        self.stacklist = []
        self.depth = 0

    def visit_section(self, node):
        self.section += 1

    def depart_section(self, node):
        self.section -= 1

    def visit_title(self, node):
        if self.section == 2:
            self.file.write('.SH %s\n'%(str(node[0]).upper()))
        elif self.section == 3:
            self.file.write('.SS %s\n'%(str(node[0]).upper()))
        elif self.section > 3:
            print '<WARNING: section too deep>'
        raise docutils.nodes.SkipNode

    def visit_Text(self, node):
        self.file.write(str(node))

    def visit_system_message(self, node):
        raise docutils.nodes.SkipNode
        print '<system_message>'

    def visit_paragraph(self, node):
        pass

    def depart_paragraph(self, node):
        self.file.write('\n')
        extra = [ docutils.nodes.paragraph,
                  docutils.nodes.literal_block ]
        # add a second \n if next sibling is a paragraph or a section
        try:
            n = node.parent[node.parent.index(node)+1]
            if extra.count(n.__class__): self.file.write('\n')
        except:
            # last node
            pass

    def visit_literal(self, node):
        self.file.write('\\fB%s\\fR'%str(node[0]))
        raise docutils.nodes.SkipNode

    def visit_literal_block(self, node):
        self.file.write('.nb\n')

    def depart_literal_block(self, node):
        self.file.write('\n.fi\n')
        
    def visit_term(self, node):
        pass

    def visit_definition(self, node):
        self.file.write('\n')

    def depart_definition(self, node):
        self.file.write('\n')

    def visit_emphasis(self, node):
        self.file.write('\\fI%s\\fR'%(node[0]))
        raise docutils.nodes.SkipNode
    
    def visit_strong(self, node):
        self.file.write('\\*fB%s*\\fR'%(node[0]))
        raise docutils.nodes.SkipNode
    def visit_block_quote(self, node):
        print '<block-quote>'
        self.file.write('.RS\n')
    def depart_block_quote(self, node):
        self.file.write('.RE\n')

    def visit_definition_list_item(self, node):
        self.file.write('.TP\n')
        self.enter_li()
        
    def depart_definition_list_item(self, node):
        self.leave_li()
        
    def visit_list_item(self, node):
        self.enter_li()
        if isinstance(self.stacklist[-1][0],int):
            self.stacklist[-1][0] += 1
            self.file.write('.IP %i 4\n'%self.stacklist[-1][0])
        elif isinstance(self.stacklist[-1][0],str):
            self.file.write('.IP %s 4\n'%self.stacklist[-1][0])
        else:
            print '<WARNING: strange list item>'
            
    def depart_list_item(self, node):
        self.leave_li()
        
    def enter_li(self):
        pass
        
    def leave_li(self):
        # if we have been forced to indent, indent back
        if self.stacklist[-1][1]:
            self.file.write('.RE\n')
        self.stacklist[-1][1] = 0
    
    def enter_list(self, t):
        # if we're in a list, that has not been
        #indented yet, we force an indent
        if len(self.stacklist) and self.stacklist[-1][1] == 0:
            self.stacklist[-1][1] = 1
            self.file.write('.RS\n')
        self.stacklist.append([t, 0])
        
    def leave_list(self):
        # back to normal para flow
        self.file.write('.PP\n')
        del self.stacklist[-1]
        
    def visit_definition_list(self, node):
        self.enter_list(None)
    def depart_definition_list(self, node):
        self.leave_list()
    def visit_enumerated_list(self, node):
        self.enter_list(0)
    def depart_enumerated_list(self, node):
        self.leave_list()
    def visit_bullet_list(self, node):
        self.enter_list('\\(bu')
    def depart_bullet_list(self, node):
        self.leave_list()
        # back to normal para flow
        # self.file.write('.PP\n')


        

    def visit_reference(self, node):
        print '<reference>', node

    def visit_target(self, node):
        print '<target>', node

    def visit_tip(self, node):
        self.file.write('.RS\n')
        self.file.write('\\fBTip:\\fR\n')

    def visit_important(self, node):
        self.file.write('.RS\n')
        self.file.write('\\fBImprotant:\\fR\n')

    def visit_note(self, node):
        self.file.write('.RS\n')
        self.file.write('\\fBNote:\\fR\n')

    def depart_tip(self, node):
        self.file.write('.RE\n')
    def depart_note(self, node):
        self.file.write('.RE\n')
    def depart_important(self, node):
        self.file.write('.RE\n')

    def unknown_departure(self, node):
        pass


class Writer(docutils.writers.Writer):
    def __init__(self, d):
        docutils.writers.Writer.__init__(self)
        self.path = d
        
    def translate(self):
        for e in [ self.document.manpages_entries[i] for i in self.document.manpages ]:
            for l in e['links']:
                fn = os.path.join(self.path,l+'.'+e['volume'])
                print "linking %s -> %s(%s) ..."%(fn, e['page'], e['volume'])
                f = open(fn,'w')
                f.write(".so man%s/%s.%s\n"%(e['volume'], e['page'], e['volume']))
                f.close()
            fn = os.path.join(self.path,e['page']+'.'+e['volume'])
            print "writing %s ..."%fn
            f = open(fn,'w')
            f.write('.TH "%s" %s GGI\n'%(e['page'], e['volume']))
            d = Translator(self.document, f)
            e['node'].walkabout(d)
            f.close()
        self.output = unicode('')
    
if __name__ == '__main__':
    docutils.core.publish_file(source = open(sys.argv[1]),
                               destination = open('/dev/null','w'),
                               writer = Writer(sys.argv[2]),
                               parser = parser.Parser())
