/*
 * print.cc
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include "print.hh"

// TODO: Are we really printing ?

Print::Print(Conf& conf) : PS(conf) {
}

Print::~Print() {
}

void Print::start_process() {
  init();
  header();
}

bool Print::end_process(std::string& err) {
  footer();
  if (PS::process(err)) {
    return PDF::process(PS::get_name(), err);
  }
  else {
    return false;
  }
}

bool Print::ok(std::string& er) {
  return PS::ok(er) ? PDF::ok(er) : false;
}

void Print::set_type(int t) {
  _type = t;
}

void Print::set_file(std::string& f) {
  _file = f;
}

void Print::set_copies(int c) {
  _copies = c;
}
