/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004, 2005  by Michael Buesch                     *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   Many very good improvements and the original implementations of       *
 *   them came from Matt Scifo <mscifo@o1.com>                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "addentrywndimpl.h"
#include "pwmexception.h"
#include "pwgenwndimpl.h"
#include "advcommeditimpl.h"
#include "htmlgen.h"

#include <kmessagebox.h>
#include <klocale.h>

#include <qpushbutton.h>
#include <qlabel.h>


AddEntryWndImpl::AddEntryWndImpl()
{
	editAdvCommentButton = 0;
	commentTextEdit = 0;
	switchComment(false);
	pwGen = new PwGenWndImpl(this);
}

AddEntryWndImpl::~AddEntryWndImpl()
{
	delete_ifnot_null(editAdvCommentButton);
	delete_ifnot_null(commentTextEdit);
	delete pwGen;
}

void AddEntryWndImpl::resizeEvent(QResizeEvent *)
{
	if (commentTextEdit)
		commentTextEdit->resize(commentDummy->size());
	if (editAdvCommentButton)
		editAdvCommentButton->resize(commentDummy->size());
}

void AddEntryWndImpl::okButton_slot()
{
	if (pwLineEdit->text().isEmpty()) {
		KMessageBox::error(this,
				   i18n("You have not set a password."),
				   i18n("No Password"));
		return;
	}
	if (descLineEdit->text().isEmpty()) {
		KMessageBox::error(this,
				   i18n
				   ("You have not set a \"Description\"."),
				   i18n("Description Not Set"));
		return;
	}
	done(1);
}

void AddEntryWndImpl::cancelButton_slot()
{
	done(2);
}

void AddEntryWndImpl::setCurrCategory(const QString &cat)
{
	int i, count = categoryComboBox->count();

	for (i = 0; i < count; ++i) {
		if (categoryComboBox->text(i) == cat) {
			categoryComboBox->setCurrentItem(i);
			return;
		}
	}
	BUG();
}

void AddEntryWndImpl::revealButton_slot()
{
	if (revealButton->isOn()) {
		pwLineEdit->setEchoMode(QLineEdit::Normal);
	} else {
		pwLineEdit->setEchoMode(QLineEdit::Password);
	}
}

void AddEntryWndImpl::generateButton_slot()
{
	if (!pwGen->exec())
		return;
	setPassword(pwGen->getPassword());
}

QString AddEntryWndImpl::getComment()
{
	if (isAdvancedComment()) {
		return advCommentDta;
	}
	return commentTextEdit->text();
}

void AddEntryWndImpl::setComment(const QString &comm)
{
	if (HtmlGen::isHtml(comm)) {
		advancedCommentButton->setOn(true);
		advCommentDta = comm;
	} else {
		advancedCommentButton->setOn(false);
		commentTextEdit->setText(comm);
	}
}

void AddEntryWndImpl::advancedCommentButton_slot(bool on)
{
	switchComment(on);
}

void AddEntryWndImpl::switchComment(bool toAdvanced)
{
	useAdvComment = toAdvanced;
	if (toAdvanced) {
		if (commentTextEdit) {
			savedCommentText = commentTextEdit->text();
			delete_and_null(commentTextEdit);
		}
		if (editAdvCommentButton)
			return;
		editAdvCommentButton = new QPushButton(i18n("Edit Advanced Comment..."),
						       commentDummy);
		editAdvCommentButton->resize(commentDummy->size().width(), 50);
		connect(editAdvCommentButton, SIGNAL(clicked()),
			this, SLOT(editAdvCommentButton_slot()));
		editAdvCommentButton->show();
	} else {
		delete_ifnot_null(editAdvCommentButton);
		if (commentTextEdit)
			return;
		commentTextEdit = new QTextEdit(commentDummy);
		commentTextEdit->setTextFormat(Qt::PlainText);
		commentTextEdit->resize(commentDummy->size());
		commentTextEdit->setText(savedCommentText);
		commentTextEdit->show();
	}
}

void AddEntryWndImpl::editAdvCommentButton_slot()
{
	AdvCommEditImpl editor(this);
	editor.setHtmlDta(advCommentDta);
	if (editor.exec())
		return;
	advCommentDta = editor.getHtmlDta();
}

#include "addentrywndimpl.moc"
