/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "configuration.h"
#if KDE_VERSION >= KDE_MAKE_VERSION(3, 2, 0)

#include <kconfigdialog.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kfontrequester.h>

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qfileinfo.h>
#include <qfontdialog.h>
#include <qspinbox.h>
#include <qvalidator.h>
#include <qsqlpropertymap.h>
#include <qlayout.h>

#include <stdlib.h>
#include <stdio.h>

#include <sys/types.h>
#include <unistd.h>

#define INITIAL_CONFWND_SIZE	(QSize(600, 450))


/*********************************************************
 **  class Configuration                                **
 *********************************************************/

Configuration * Configuration::_obj (0);

Configuration::Configuration()
{
	skel = new KConfigSkeleton;
	initSkel();
	readConfig();
}

Configuration::~Configuration()
{
	writeConfig();
	delete_ifnot_null(skel);
}

void Configuration::initSkel()
{
	skel->setCurrentGroup("GLOBAL");
	skel->addItemString("autoStart", cGlobAutoStart);
	skel->addItemString("browserCommand", cGlobBrowserCommand, CONF_DEFAULT_BROWSERCOMMAND);
	skel->addItemString("xtermCommand", cGlobXtermCommand, CONF_DEFAULT_XTERMCOMMAND);
	skel->addItemFont("entryFont", cGlobEntryFont);
	skel->addItemInt("pwTimeout", cGlobPwTimeout, CONF_DEFAULT_PWTIMEOUT);
	skel->addItemInt("lockTimeout", cGlobLockTimeout, CONF_DEFAULT_LOCKTIMEOUT);
	skel->addItemInt("compression", cGlobCompression, CONF_DEFAULT_COMPRESSION);
	skel->addItemInt("filePermissions", cGlobFilePermissions, CONF_DEFAULT_FILEPERMISSIONS);
	skel->addItemInt("minimizeLock", cGlobMinimizeLock, CONF_DEFAULT_MINIMIZELOCK);
	skel->addItemBool("unlockOnOpen", cGlobUnlockOnOpen, CONF_DEFAULT_UNLOCKONOPEN);
	skel->addItemBool("tray", cGlobTray, CONF_DEFAULT_TRAY);
	skel->addItemBool("makeFileBackup", cGlobMakeFileBackup, CONF_DEFAULT_MAKEFILEBACKUP);
	skel->addItemBool("autostartDeeplocked", cGlobAutostartDeepLocked, CONF_DEFAULT_AUTOSTART_DEEPL);
	skel->addItemBool("autoDeepLock", cGlobAutoDeepLock, CONF_DEFAULT_AUTODEEPLOCK);
	skel->addItemBool("kwalletEmu", cGlobKwalletEmu, CONF_DEFAULT_KWALLETEMU);
	skel->addItemBool("newEntrLockStat", cGlobNewEntrLockStat, CONF_DEFAULT_NEWENTRLOCKSTAT);
	skel->addItemBool("canExecAsRoot", cGlobCanExecAsRoot, CONF_DEFAULT_ALLOWROOTEXEC);
	skel->addItemBool("base64Storage", cGlobBase64Storage, CONF_DEFAULT_BASE64STORAGE);

	skel->setCurrentGroup("WND");
	skel->addItemSize("MainWndSize", cWndMainWndSize);
	skel->addItemInt("MainViewStyle", cWndMainViewStyle, CONF_DEFAULT_MAINVIEWSTYLE);
	skel->addItemBool("autoMinimizeOnStart", cWndAutoMinimizeOnStart, CONF_DEFAULT_AUTOMINIMIZE);
	skel->addItemBool("close", cWndClose, CONF_DEFAULT_WNDCLOSE);
}

bool Configuration::showConfWnd(QWidget *parent)
{
	bool ret = true;
	KConfigDialog *confDlg;
	confDlg = new KConfigDialog(parent, i18n("Main configuration").latin1(), skel,
				    KDialogBase::IconList,
				    KConfigDialog::Default | KConfigDialog::Ok |
				    KConfigDialog::Cancel | KConfigDialog::Help,
				    KConfigDialog::Ok, true);
	ConfPageGlobal *confPageGlobal = new ConfPageGlobal;
	ConfPageLookNFeel *confPageLookNFeel = new ConfPageLookNFeel;
	ConfPageFile *confPageFile = new ConfPageFile;
	ConfPageTimeouts *confPageTimeouts = new ConfPageTimeouts;
	ConfPageExtApps *confPageExtApps = new ConfPageExtApps;
	ConfPageAutostart *confPageAutostart = new ConfPageAutostart;
	confDlg->addPage(confPageGlobal, i18n("General"), "pwmanager");
	confDlg->addPage(confPageLookNFeel, i18n("Look & Feel"), "fonts");
	confDlg->addPage(confPageFile, i18n("Files"), "filesave");
	confDlg->addPage(confPageTimeouts, i18n("Timeouts"), "clock");
	confDlg->addPage(confPageExtApps, i18n("External Applications"), "gear");
	confDlg->addPage(confPageAutostart, i18n("Autostart"), "fileopen");
	confDlg->resize(INITIAL_CONFWND_SIZE);
	if (confDlg->exec() == 0)
		ret = false;
	delete confPageGlobal;
	delete confPageLookNFeel;
	delete confPageFile;
	delete confPageTimeouts;
	delete confPageExtApps;
	delete confPageAutostart;
	return ret;
}


/*********************************************************
 **  class OctLineEdit                                  **
 *********************************************************/

OctLineEdit::OctLineEdit(QWidget *parent, const char *name)
 : QLineEdit(parent, name)
{
}

OctLineEdit::~OctLineEdit()
{
}

void OctLineEdit::setText(const QString &t)
{
	bool ok;
	int tmp = t.toInt(&ok, 10);
	if (!ok)
		return;
	QString ret;
	ret.setNum(tmp, 8);
	QLineEdit::setText(ret);
}

QString OctLineEdit::text() const
{
	bool ok;
	QString ret;
	QString t(QLineEdit::text());
	int tmp = t.toInt(&ok, 8);
	if (!ok)
		return ret;
	ret.setNum(tmp, 10);
	return ret;
}

void OctLineEdit::keyPressEvent(QKeyEvent *e)
{
	int key = e->key();
	switch (key) {
	case Qt::Key_0:
	case Qt::Key_1:
	case Qt::Key_2:
	case Qt::Key_3:
	case Qt::Key_4:
	case Qt::Key_5:
	case Qt::Key_6:
	case Qt::Key_7:
	case Qt::Key_Escape:
	case Qt::Key_Backtab:
	case Qt::Key_Backspace:
	case Qt::Key_Return:
	case Qt::Key_Enter:
	case Qt::Key_Insert:
	case Qt::Key_Delete:
	case Qt::Key_Home:
	case Qt::Key_End:
	case Qt::Key_Left:
	case Qt::Key_Up:
	case Qt::Key_Right:
	case Qt::Key_Down:
		e->accept();
		QLineEdit::keyPressEvent(e);
		break;
	default:
		e->ignore();
	}
}


/*********************************************************
 **  class ConfPageGlobal                               **
 *********************************************************/

ConfPageGlobal::ConfPageGlobal(QWidget *parent, const char *name, WFlags f)
 : QWidget(parent, name, f)
{
	QCheckBox *kcfg_tray;
	QCheckBox *kcfg_autoMinimizeOnStart;
	QCheckBox *kcfg_unlockOnOpen;
	QCheckBox *kcfg_newEntrLockStat;
	QCheckBox *kcfg_close;
	QCheckBox *kcfg_canExecAsRoot;
	QComboBox *kcfg_minimizeLock;
	QLabel *kcfg_minimizeLock_label;

	QBoxLayout *l = new QVBoxLayout(this);
	l->setSpacing(4);
	kcfg_tray = new QCheckBox(i18n("Show icon in system-tray"), this, "kcfg_tray");
	l->addWidget(kcfg_tray);
	kcfg_autoMinimizeOnStart = new QCheckBox(i18n("Auto-minimize to tray on startup"),
						 this, "kcfg_autoMinimizeOnStart");
	l->addWidget(kcfg_autoMinimizeOnStart);
	kcfg_unlockOnOpen = new QCheckBox(i18n("Open document with passwords unlocked"),
					  this, "kcfg_unlockOnOpen");
	l->addWidget(kcfg_unlockOnOpen);
#ifdef CONFIG_KWALLETIF
	QCheckBox *kcfg_kwalletEmu;
	kcfg_kwalletEmu = new QCheckBox(i18n("KWallet emulation"),
					this, "kcfg_kwalletEmu");
	l->addWidget(kcfg_kwalletEmu);
#endif // CONFIG_KWALLETIF
	kcfg_newEntrLockStat = new QCheckBox(i18n("Automatically lock new entries"),
					     this, "kcfg_newEntrLockStat");
	l->addWidget(kcfg_newEntrLockStat);
	kcfg_close = new QCheckBox(i18n("Do not minimize windows into tray. (Close the window)"),
				   this, "kcfg_close");
	l->addWidget(kcfg_close);
	if (geteuid() == 0) {
		kcfg_canExecAsRoot = new QCheckBox(i18n("Allow execution of external programs"),
						   this, "kcfg_canExecAsRoot");
		l->addWidget(kcfg_canExecAsRoot);
	}
	l->addSpacing(4);
	QBoxLayout *hl = new QHBoxLayout(this);
	hl->setSpacing(10);
	kcfg_minimizeLock_label = new QLabel(i18n("Auto-lock on minimize:"), this);
	hl->addWidget(kcfg_minimizeLock_label);
	kcfg_minimizeLock = new QComboBox(this, "kcfg_minimizeLock");
	hl->addStretch();
	hl->addWidget(kcfg_minimizeLock);
	kcfg_minimizeLock->insertItem(i18n("Do not lock"));
	kcfg_minimizeLock->insertItem(i18n("Normal lock"));
	kcfg_minimizeLock->insertItem(i18n("Deep-lock"));
	l->addLayout(hl);
	l->addStretch();
}


/*********************************************************
 **  class ConfPageLookNFeel                            **
 *********************************************************/

ConfPageLookNFeel::ConfPageLookNFeel(QWidget *parent, const char *name, WFlags f)
 : QWidget(parent, name, f)
{
	QComboBox *kcfg_MainViewStyle;
	QLabel *kcfg_MainViewStyle_label;
	KFontRequester *kcfg_entryFont;
	QGroupBox *kcfg_entryFont_box;

	QBoxLayout *l = new QVBoxLayout(this);
	l->setSpacing(10);
	// font
	kcfg_entryFont_box = new QGroupBox(i18n("Font for the Password Entries:"), this);
	l->addWidget(kcfg_entryFont_box);
	kcfg_entryFont_box->setColumns(1);
	kcfg_entryFont = new KFontRequester(kcfg_entryFont_box, "kcfg_entryFont", false);
	// wnd style
	QBoxLayout *hl = new QHBoxLayout(this);
	hl->setSpacing(10);
	kcfg_MainViewStyle_label = new QLabel(i18n("Window Style:"), this);
	hl->addWidget(kcfg_MainViewStyle_label);
	kcfg_MainViewStyle = new QComboBox(this, "kcfg_MainViewStyle");
	hl->addStretch();
	hl->addWidget(kcfg_MainViewStyle);
	kcfg_MainViewStyle->insertItem(i18n("Category on top"));
	kcfg_MainViewStyle->insertItem(i18n("Categorylist left"));
	l->addLayout(hl);
	l->addStretch();
}


/*********************************************************
 **  class ConfPageFile                                 **
 *********************************************************/

ConfPageFile::ConfPageFile(QWidget *parent, const char *name, WFlags f)
 : QWidget(parent, name, f)
{
	QComboBox *kcfg_compression;
	QLabel *kcfg_compression_label;
	OctLineEdit *kcfg_filePermissions;
	QLabel *kcfg_filePermissions_label;
	QCheckBox *kcfg_makeFileBackup;

	QBoxLayout *l = new QVBoxLayout(this);
	l->setSpacing(10);
	// compression
	QBoxLayout *hl = new QHBoxLayout(this);
	hl->setSpacing(10);
	kcfg_compression_label = new QLabel(i18n("*.pwm file compression:"), this);
	hl->addWidget(kcfg_compression_label);
	kcfg_compression = new QComboBox(this, "kcfg_compression");
	hl->addStretch();
	hl->addWidget(kcfg_compression);
	kcfg_compression->insertItem(i18n("none"));
	kcfg_compression->insertItem(i18n("gzip"));
	kcfg_compression->insertItem(i18n("bzip2"));
	l->addLayout(hl);
	// permissions
	hl = new QHBoxLayout(this);
	hl->setSpacing(10);
	kcfg_filePermissions_label = new QLabel(i18n("Permissions:"), this);
	hl->addWidget(kcfg_filePermissions_label);
	kcfg_filePermissions = new OctLineEdit(this, "kcfg_filePermissions");
	hl->addStretch();
	hl->addWidget(kcfg_filePermissions);
	kcfg_filePermissions->setMaxLength(3);
	l->addLayout(hl);
	// backup
	kcfg_makeFileBackup = new QCheckBox(i18n("Make file backup before saving"),
					    this, "kcfg_makeFileBackup");
	l->addWidget(kcfg_makeFileBackup);
	l->addStretch();
}


/*********************************************************
 **  class ConfPageTimeouts                             **
 *********************************************************/

ConfPageTimeouts::ConfPageTimeouts(QWidget *parent, const char *name, WFlags f)
 : QWidget(parent, name, f)
{
	QSpinBox *kcfg_pwTimeout;
	QLabel *kcfg_pwTimeout_label;
	QSpinBox *kcfg_lockTimeout;
	QLabel *kcfg_lockTimeout_label;
	QCheckBox *kcfg_autoDeepLock;

	QBoxLayout *l = new QVBoxLayout(this);
	l->setSpacing(10);
	// pw timeout
	QBoxLayout *hl = new QHBoxLayout(this);
	hl->setSpacing(10);
	kcfg_pwTimeout_label = new QLabel(i18n("Password timeout (timeout to hold "
					       "password in memory, so you don't have "
					       "to re-enter it, if you already have "
					       "entered it) [set to 0 to disable]:"),
					  this);
	hl->addWidget(kcfg_pwTimeout_label);
	kcfg_pwTimeout_label->setAlignment(QLabel::WordBreak);
	kcfg_pwTimeout = new QSpinBox(this, "kcfg_pwTimeout");
	hl->addStretch();
	hl->addWidget(kcfg_pwTimeout);
	l->addLayout(hl);
	// lock timeout
	hl = new QHBoxLayout(this);
	hl->setSpacing(10);
	kcfg_lockTimeout_label = new QLabel(i18n("Auto-lock timeout (auto lock document "
						 "after this amount of seconds) "
						 "[set to 0 to disable]:"),
					    this);
	hl->addWidget(kcfg_lockTimeout_label);
	kcfg_lockTimeout_label->setAlignment(QLabel::WordBreak);
	kcfg_lockTimeout = new QSpinBox(this, "kcfg_lockTimeout");
	hl->addStretch();
	hl->addWidget(kcfg_lockTimeout);
	l->addLayout(hl);
	// auto deep lock checkbox
	kcfg_autoDeepLock = new QCheckBox(i18n("Deep-lock on Autolock"),
					  this, "kcfg_autoDeepLock");
	l->addWidget(kcfg_autoDeepLock);
	l->addStretch();
}


/*********************************************************
 **  class ConfPageExtApps                              **
 *********************************************************/

ConfPageExtApps::ConfPageExtApps(QWidget *parent, const char *name, WFlags f)
 : QWidget(parent, name, f)
{
	QLineEdit *kcfg_browserCommand;
	QLabel *kcfg_browserCommand_label;
	QLineEdit *kcfg_xtermCommand;
	QLabel *kcfg_xtermCommand_label;

	QBoxLayout *l = new QVBoxLayout(this);
	l->setSpacing(4);
	// browser command
	QBoxLayout *hl = new QHBoxLayout(this);
	hl->setSpacing(10);
	kcfg_browserCommand_label = new QLabel(i18n("Favourite browser:"), this);
	hl->addWidget(kcfg_browserCommand_label);
	kcfg_browserCommand = new QLineEdit(this, "kcfg_browserCommand");
	hl->addStretch();
	hl->addWidget(kcfg_browserCommand);
	l->addLayout(hl);
	// xterm command
	hl = new QHBoxLayout(this);
	hl->setSpacing(10);
	kcfg_xtermCommand_label = new QLabel(i18n("Favourite X-terminal:"), this);
	hl->addWidget(kcfg_xtermCommand_label);
	kcfg_xtermCommand = new QLineEdit(this, "kcfg_xtermCommand");
	hl->addStretch();
	hl->addWidget(kcfg_xtermCommand);
	l->addLayout(hl);
	l->addStretch();
}


/*********************************************************
 **  class ConfPageAutostart                            **
 *********************************************************/

ConfPageAutostart::ConfPageAutostart(QWidget *parent, const char *name, WFlags f)
 : QWidget(parent, name, f)
{
	QGroupBox *kcfg_autoStart_box;
	QPushButton *kcfg_autoStart_button;
	QCheckBox *kcfg_autostartDeeplocked;

	QBoxLayout *l = new QVBoxLayout(this);
	l->setSpacing(4);
	// autostart
	kcfg_autoStart_box = new QGroupBox(i18n("Open This File Automatically on Startup:"),
					   this);
	l->addWidget(kcfg_autoStart_box);
	kcfg_autoStart_box->setColumns(2);
	kcfg_autoStart = new QLineEdit(kcfg_autoStart_box, "kcfg_autoStart");
	kcfg_autoStart_button = new QPushButton("...", kcfg_autoStart_box);
	kcfg_autostartDeeplocked = new QCheckBox(i18n("Open Deeplocked"),
						 kcfg_autoStart_box, "kcfg_autostartDeeplocked");
	l->addStretch();
	// connections
	connect(kcfg_autoStart_button, SIGNAL(clicked()),
		this, SLOT(browseButton_slot()));
}

void ConfPageAutostart::browseButton_slot()
{
	QString path(KFileDialog::getOpenFileName(QString::null,
						  i18n("*.pwm|PwM Password file\n"
						       "*|All files"), this));
	if (path == QString::null)
		return;
	kcfg_autoStart->setText(path);
}

#include "configuration.moc"

#else // KDE_VERSION >= KDE_MAKE_VERSION(3, 2, 0)
  /* XXX: This is the code for KDE-3.1 compatibility. */
# include "configuration_31compat.cpp"
#endif // KDE_VERSION >= KDE_MAKE_VERSION(3, 2, 0)
