/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef __CONFIGURATION_H
#define __CONFIGURATION_H

#define CONF_DEFAULT_PWTIMEOUT		10	/* 10 sec */
#define CONF_DEFAULT_LOCKTIMEOUT	0	/* 0 == disable */
#define CONF_DEFAULT_TRAY		true
#define CONF_DEFAULT_UNLOCKONOPEN	true
#define CONF_DEFAULT_MAINVIEWSTYLE	0
#define CONF_DEFAULT_COMPRESSION	0x01	/* gzip */
#define CONF_DEFAULT_AUTOMINIMIZE	false
#define CONF_DEFAULT_BROWSERCOMMAND	""
#define CONF_DEFAULT_XTERMCOMMAND	"konsole -e"
#define CONF_DEFAULT_FILEPERMISSIONS	0600
#define CONF_DEFAULT_MAKEFILEBACKUP	false
#define CONF_DEFAULT_AUTOSTART_DEEPL	true
#define CONF_DEFAULT_AUTODEEPLOCK	true
#define CONF_DEFAULT_KWALLETEMU		true
#define CONF_DEFAULT_MINIMIZELOCK	2	/* deep-lock */
#define CONF_DEFAULT_NEWENTRLOCKSTAT	true	/* locked */
#define CONF_DEFAULT_WNDCLOSE		true	/* don't minimize to tray */
#define CONF_DEFAULT_ALLOWROOTEXEC	false
#define CONF_DEFAULT_BASE64STORAGE	false

/** This is just because I'm too lazy to always
  * type this loooong statement, when accessing
  * configuration parameters.
  */
#define conf()	Configuration::obj()

#include <kstandarddirs.h>
#include <kdeversion.h>

// Set this to 1 to debug the 3.1 compatibility interface
#if 0
# warning configuration.h KDE_VERSION debugging enabled!
# undef KDE_VERSION
# define KDE_VERSION	KDE_MAKE_VERSION(3, 1, 0)
#endif

#if !defined(KDE_VERSION) || !defined(KDE_MAKE_VERSION)
# error "KDE_VERSION or KDE_MAKE_VERSION not defined"
#endif
#if KDE_VERSION >= KDE_MAKE_VERSION(3, 2, 0)

#include <qstring.h>
#include <qsize.h>
#include <qfont.h>
#include <qwidget.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qlineedit.h>

#include <kconfigskeleton.h>

#include "pwmexception.h"

class QLabel;
class QGroupBox;
class QPushButton;
class QResizeEvent;

/** New global configuration file interface
  * using KDE-3.2 KConfigSkeleton model.
  */
class Configuration
{
public:
	Configuration();
	~Configuration();

	static Configuration * obj()
		{
			PWM_ASSERT(_obj);
			return _obj;
		}
	static void init()
		{
			PWM_ASSERT(!_obj);
			_obj = new Configuration;
		}
	static void cleanup()
			{ delete_ifnot_null(_obj); }


	/** Read the configuration from the file.
	  * Normally this function has not to be called manually.
	  */
	void readConfig()
			{ skel->readConfig(); }
	/** Write the configuration to the file.
	  * Normally this function has not to be called manually.
	  */
	void writeConfig()
			{ skel->writeConfig(); }
	/** reset the whole configuration to its defaults */
	void resetConfig()
			{ skel->setDefaults(); }
	/** show the configuration window */
	bool showConfWnd(QWidget *parent);

public:
	/* functions for reading the configuration settings */
	/* GLOBAL */
	QString confGlobAutoStart()
			{ return cGlobAutoStart; }
	QString confGlobBrowserCommand()
			{ return cGlobBrowserCommand; }
	QString confGlobXtermCommand()
			{ return cGlobXtermCommand; }
	QFont confGlobEntryFont()
			{ return cGlobEntryFont; }
	int confGlobPwTimeout()
			{ return cGlobPwTimeout; }
	int confGlobLockTimeout()
			{ return cGlobLockTimeout; }
	int confGlobCompression()
			{ return cGlobCompression; }
	int confGlobFilePermissions()
			{ return cGlobFilePermissions; }
	int confGlobMinimizeLock()
			{ return cGlobMinimizeLock; }
	bool confGlobUnlockOnOpen()
			{ return cGlobUnlockOnOpen; }
	bool confGlobTray()
			{ return cGlobTray; }
	bool confGlobMakeFileBackup()
			{ return cGlobMakeFileBackup; }
	bool confGlobAutostartDeepLocked()
			{ return cGlobAutostartDeepLocked; }
	bool confGlobAutoDeepLock()
			{ return cGlobAutoDeepLock; }
	bool confGlobKwalletEmu()
			{ return cGlobKwalletEmu; }
	bool confGlobNewEntrLockStat()
			{ return cGlobNewEntrLockStat; }
	bool confGlobCanExecAsRoot()
			{ return cGlobCanExecAsRoot; }
	bool confGlobBase64Storage()
			{ return cGlobBase64Storage; }
	/* WND */
	QSize confWndMainWndSize()
			{ return cWndMainWndSize; }
	int confWndMainViewStyle()
			{ return cWndMainViewStyle; }
	bool confWndAutoMinimizeOnStart()
			{ return cWndAutoMinimizeOnStart; }
	bool confWndClose()
			{ return cWndClose; }

public:
	/* functions for writing the configuration settings */
	/* GLOBAL */
	void confGlobAutoStart(const QString &e)
			{ cGlobAutoStart = e; }
	void confGlobBrowserCommand(const QString &e)
			{ cGlobBrowserCommand = e; }
	void confGlobXtermCommand(const QString &e)
			{ cGlobXtermCommand = e; }
	void confGlobEntryFont(const QFont &e)
			{ cGlobEntryFont = e; }
	void confGlobPwTimeout(int e)
			{ cGlobPwTimeout = e; }
	void confGlobLockTimeout(int e)
			{ cGlobLockTimeout = e; }
	void confGlobCompression(int e)
			{ cGlobCompression = e; }
	void confGlobFilePermissions(int e)
			{ cGlobFilePermissions = e; }
	void confGlobMinimizeLock(int e)
			{ cGlobMinimizeLock = e; }
	void confGlobUnlockOnOpen(bool e)
			{ cGlobUnlockOnOpen = e; }
	void confGlobTray(bool e)
			{ cGlobTray = e; }
	void confGlobMakeFileBackup(bool e)
			{ cGlobMakeFileBackup = e; }
	void confGlobAutostartDeepLocked(bool e)
			{ cGlobAutostartDeepLocked = e; }
	void confGlobAutoDeepLock(bool e)
			{ cGlobAutoDeepLock = e; }
	void confGlobKwalletEmu(bool e)
			{ cGlobKwalletEmu = e; }
	void confGlobNewEntrLockStat(bool e)
			{ cGlobNewEntrLockStat = e; }
	void confGlobCanExecAsRoot(bool e)
			{ cGlobCanExecAsRoot = e; }
	void confGlobBase64Storage(bool e)
			{ cGlobBase64Storage = e; }
	/* WND */
	void confWndMainWndSize(const QSize &e)
			{ cWndMainWndSize = e; }
	void confWndMainViewStyle(int e)
			{ cWndMainViewStyle = e; }
	void confWndAutoMinimizeOnStart(bool e)
			{ cWndAutoMinimizeOnStart = e; }
	void confWndClose(bool e)
			{ cWndClose = e; }

protected:
	/** initialize the skeleton */
	void initSkel();

protected:
	/** static instance of this class returned by obj() */
	static Configuration *_obj;
	/** main configuration access skeleton */
	KConfigSkeleton *skel;

protected:
	/* configuration variables. All prefixed with 'c'. */
	/* GLOBAL */
	QString cGlobAutoStart;
	QString cGlobBrowserCommand;
	QString cGlobXtermCommand;
	QFont cGlobEntryFont;
	int cGlobPwTimeout;
	int cGlobLockTimeout;
	int cGlobCompression;
	int cGlobFilePermissions;
	int cGlobMinimizeLock;
	bool cGlobUnlockOnOpen;
	bool cGlobTray;
	bool cGlobMakeFileBackup;
	bool cGlobAutostartDeepLocked;
	bool cGlobAutoDeepLock;
	bool cGlobKwalletEmu;
	bool cGlobNewEntrLockStat;
	bool cGlobCanExecAsRoot;
	bool cGlobBase64Storage;
	/* WND */
	QSize cWndMainWndSize;
	int cWndMainViewStyle;
	bool cWndAutoMinimizeOnStart;
	bool cWndClose;
};

/* Big fat note: Internal stuff follows.
 * ============  Don't use the following classes outside of
 *		 the Configuration code, because it's unavailable
 *		 when compiled under KDE-3.1
 */

/** class for input of octal numbers (for example file permissions) */
class OctLineEdit : public QLineEdit
{
	Q_OBJECT
	Q_OVERRIDE( QString text READ text WRITE setText )

public:
	OctLineEdit(QWidget *parent, const char *name = 0);
	~OctLineEdit();

	void setText(const QString &t);
	QString text() const;

protected:
	void keyPressEvent(QKeyEvent *e);
};

/** global configuration page */
class ConfPageGlobal : public QWidget
{
public:
	ConfPageGlobal(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
};

/** configuration page for look&feel */
class ConfPageLookNFeel : public QWidget
{
public:
	ConfPageLookNFeel(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
};

/** file configuration page */
class ConfPageFile : public QWidget
{
public:
	ConfPageFile(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
};

/** timeouts configuration page */
class ConfPageTimeouts : public QWidget
{
public:
	ConfPageTimeouts(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
};

/** configuration page for external apps */
class ConfPageExtApps : public QWidget
{
public:
	ConfPageExtApps(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
};

/** autostart configuration page */
class ConfPageAutostart : public QWidget
{
	Q_OBJECT
public:
	ConfPageAutostart(QWidget *parent = 0, const char *name = 0, WFlags f = 0);

protected slots:
	void browseButton_slot();

protected:
	QLineEdit *kcfg_autoStart;
};


#else // KDE_VERSION >= KDE_MAKE_VERSION(3, 2, 0)
  /* XXX: This is the code for KDE-3.1 compatibility. */
# include "configuration_31compat.h"
#endif // KDE_VERSION >= KDE_MAKE_VERSION(3, 2, 0)
#endif // CONFIGURATION_H
