/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef __RETWND_H
#define __RETWND_H

#include <qwidget.h>
#include <qstringlist.h>
#include <qstring.h>
#include <qvbox.h>
#include <qmap.h>

#include <kwallet.h>

class RetWnd : public QWidget
{
	Q_OBJECT
public:
	RetWnd(const char *_funcId,
	       QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	~RetWnd();

	void open_QStringList(const QStringList &d);
	void open_bool(bool d);
	void open_int(int d);
	void open_pWallet(KWallet::Wallet *d);
	void open_QString(const QString &d);
	void open_EntryType(KWallet::Wallet::EntryType d);
	void open_QMap_QString_QString(const QMap<QString,QString> &d);
	void open_QByteArray(const QByteArray &d);

protected:
	const char *funcId;
	QVBox *vbox;

protected:
	void closeEvent(QCloseEvent *e);
	void resizeEvent(QResizeEvent *);
};

#endif // __RETWND_H
