/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004, 2005  by Michael Buesch                           *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef PWMANAGER_NEWMASTERKEYWNDIMPL_H_
#define PWMANAGER_NEWMASTERKEYWNDIMPL_H_

#include "masterkey/newmasterkeywnd.h"
#include "masterkey/masterkey.h"


class NewMasterKeyWndImpl : public NewMasterKeyWnd
{
	Q_OBJECT

public:
	NewMasterKeyWndImpl(QWidget *_parent,
			    const char *name = 0,
			    bool modal = false,
			    WFlags fl = 0);
	~NewMasterKeyWndImpl();

	/** sets the allowed key type. */
	void setAllowedType(MasterKey::Type type);
	/** Returns the last key data. */
	MasterKey::Type getLastKey(QByteArray *key);

protected slots:
	/** OK button pressed. */
	void okButton_slot();
	/** Cancel button pressed. */
	void cancelButton_slot();
	/** Text in one of the password line-edits changed. */
	void pwChanged_slot();
	/** Tab switched. */
	void tabSwitched_slot();
	/** generate SmartKey button pressed. */
	void genSmartKeyButton_slot();

protected:
	/** Check if we can enable/disable the OK button. */
	void checkForOkButton();

protected:
	/** Parent widget. */
	QWidget *parent;
	/** The data for the last key. */
	QByteArray lastKey;
	/** The type of the last key. */
	MasterKey::Type lastType;
};

#endif // PWMANAGER_MASTERKEYWNDIMPL_H_
