/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004, 2005  by Michael Buesch                     *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "pwmdocui.h"
#include "pwmexception.h"
#include "pwm.h"
#include "globalstuff.h"

#include <qlineedit.h>
#include <qtabwidget.h>

#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kwin.h>


PwMDocUi::PwMDocUi(QObject *parent, const char *name)
 : QObject(parent, name)
{
}

PwMDocUi::~PwMDocUi()
{
}

void PwMDocUi::cantDeeplock_notSavedMsgBox()
{
	KMessageBox::error(getCurrentView(),
			   i18n("Cannot deep lock, because the document "
				"has not yet been saved; please save "
				"to a file and try again."),
			   i18n("Not Saved Yet"));
}

void PwMDocUi::gpmPwLenErrMsgBox()
{
	KMessageBox::error(getCurrentView(),
			   i18n("GPasman does not support passwords "
				"shorter than 4 characters; please try "
				"again with a longer password."),
			   i18n("Password too Short"));
}

int PwMDocUi::dirtyAskSave(const QString &docTitle)
{
	int ret;
	QString msg(i18n("The list \"%1\" has been modified;\n"
			 "do you want to save it?").arg(docTitle));
	QString title(i18n("Save?"));
	ret = KMessageBox::questionYesNoCancel(getCurrentView(), msg, title);
	if (ret == KMessageBox::Yes) {
		return 0;
	} else if (ret == KMessageBox::No) {
		return 1;
	}
	// cancel
	return -1;
}

bool PwMDocUi::saveDocUi(PwMDoc *doc)
{
	PWM_ASSERT(doc);
	doc->timer()->getLock(DocTimer::id_autoLockTimer);
	if (doc->isDocEmpty()) {
		KMessageBox::information(getCurrentView(),
					 i18n
					 ("Sorry, there is nothing to save;\n"
					  "please add some passwords first."),
					 i18n("Nothing to Do"));
		doc->timer()->putLock(DocTimer::id_autoLockTimer);
		return true;
	}
	PwMerror ret = doc->saveDoc(conf()->confGlobCompression());
	if (ret == e_filename) {
		doc->timer()->putLock(DocTimer::id_autoLockTimer);
		return saveAsDocUi(doc);
	} else if (ret == e_weakPw) {
		KMessageBox::error(getCurrentView(),
				   i18n("Error: this is a weak password;\n"
					"please select another password."),
				   i18n("Weak Password"));
		doc->timer()->putLock(DocTimer::id_autoLockTimer);
		return false;
	} else if (ret == e_fileBackup) {
		KMessageBox::error(getCurrentView(),
				   i18n("Error: could not make backup file."),
				   i18n("Backup Failed"));
		doc->timer()->putLock(DocTimer::id_autoLockTimer);
		return false;
	} else if (ret == e_noPw ||
		   ret == e_wrongPw ||
		   ret == e_openFile) {
		doc->timer()->putLock(DocTimer::id_autoLockTimer);
		return false;
	} else if (ret != e_success) {
		KMessageBox::error(getCurrentView(),
				   i18n("Error: unable to write to file;\n"
					"please check if you have permission to "
					"write to the file in that directory."),
				   i18n("Error While Writing"));
		doc->timer()->putLock(DocTimer::id_autoLockTimer);
		return false;
	}
	doc->timer()->putLock(DocTimer::id_autoLockTimer);
	return true;
}

bool PwMDocUi::saveAsDocUi(PwMDoc *doc)
{
	PWM_ASSERT(doc);
	doc->timer()->getLock(DocTimer::id_autoLockTimer);
	if (doc->isDocEmpty()) {
		KMessageBox::information(getCurrentView(),
					 i18n
					 ("Sorry, there is nothing to save;\n"
					  "please add some passwords first."),
					 i18n("Nothing to Do"));
		doc->timer()->putLock(DocTimer::id_autoLockTimer);
		return true;
	}
	QString fn(KFileDialog::getSaveFileName(QString(),
						i18n("*.pwm|PwManager Password file"),
						getCurrentView()));
	if (fn == "") {
		doc->timer()->putLock(DocTimer::id_autoLockTimer);
		return false;
	}
	if (fn.right(4) != ".pwm")
		fn += ".pwm";

	PwMerror ret = doc->saveDoc(conf()->confGlobCompression(), &fn);
	if (ret == e_noPw ||
	    ret == e_wrongPw ||
	    ret == e_openFile) {
		doc->timer()->putLock(DocTimer::id_autoLockTimer);
		return false;
	} else if (ret != e_success) {
		KMessageBox::error(getCurrentView(),
				   i18n("Error: unable to write to file;\n"
					"please check if you have permission to "
					"write to the file in that directory."),
				   i18n("Error While Writing"));
		doc->timer()->putLock(DocTimer::id_autoLockTimer);
		return false;
	}
	doc->timer()->putLock(DocTimer::id_autoLockTimer);
	return true;
}

bool PwMDocUi::openDocUi(PwMDoc *doc,
			 QString filename,
			 bool openDeepLocked)
{
	if (filename.isEmpty())
		filename = KFileDialog::getOpenFileName(QString(),
							i18n("*.pwm|PwManager Password file\n"
							     "*|All files"), getCurrentView());
	if (filename.isEmpty())
		goto cancelOpen;
	PwMerror ret;
	while (true) {
		int lockStat = -1;
		if (openDeepLocked) {
			lockStat = 2;
		} else {
			if (conf()->confGlobUnlockOnOpen()) {
				lockStat = 0;
			} else {
				lockStat = 1;
			}
		}
		ret = doc->openDoc(&filename, lockStat);
		if (ret != e_success) {
			if (ret == e_readFile || ret == e_openFile) {
				KMessageBox::error(getCurrentView(),
						   i18n("Could not read file:\n%1").arg(filename),
						   i18n("File Error"));
				goto cancelOpen;
			}
			if (ret == e_alreadyOpen) {
				KMessageBox::error(getCurrentView(),
						   i18n("This file is already open."),
						   i18n("Already Open"));
				goto cancelOpen;
			}
			if (ret == e_fileVer) {
				KMessageBox::error(getCurrentView(),
						   i18n
						   ("File-version is not supported.\n"
						    "Did you create this file with an older or newer version of PwManager?"),
						   i18n
						   ("Incompatible Version"));
				goto cancelOpen;
			}
			if (ret == e_wrongPw) {
				continue;
			}
			if (ret == e_noPw) {
				goto cancelOpen;
			}
			if (ret == e_fileFormat) {
				KMessageBox::error(getCurrentView(),
						   i18n
						   ("Sorry, this file has not been recognized "
						    "as a PwManager Data File.\n"
						    "Probably you have selected the wrong file."),
						   i18n
						   ("Not PwManager Data File"));
				goto cancelOpen;
			}
			if (ret == e_fileCorrupt) {
				KMessageBox::error(getCurrentView(),
						   i18n
						   ("File corrupt!\n"
						    "Maybe the media, you stored this file on, "
						    "had bad sectors?"),
						   i18n
						   ("Checksum Error"));
				goto cancelOpen;
			}
			if (ret == e_keyNotImpl) {
				KMessageBox::error(getCurrentView(),
						   i18n
						   ("No SmartCard support available.\n"
						    "This file is encrypted with a SmartCard "
						    "as MasterKey, but this version of PwManager "
						    "does not have SmartCard support. You need "
						    "to recompile PwManager with SmartCard support."),
						   i18n
						   ("No SmartCard Support"));
				goto cancelOpen;
			}
		}
		break;
	}
	return true;

      cancelOpen:
	return false;
}

QString PwMDocUi::string_defaultCategory()
{
	return i18n("Default");
}

QString PwMDocUi::string_locked()
{
	return i18n("<LOCKED>");
}

QString PwMDocUi::string_deepLockedShort()
{
	return i18n("DEEP-LOCKED");
}

QString PwMDocUi::string_deepLockedLong()
{
	return i18n("This file is deep-locked:\n"
		    "that means all data has been encrypted "
		    "and written out to the file. If you want "
		    "to see the entries, please unlock the file. "
		    "While unlocking, you will be prompted for the "
		    "master-password or the key-card.");
}

QString PwMDocUi::string_defaultTitle()
{
	return i18n("Untitled");
}

#include "pwmdocui.moc"
