/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004 by Michael Buesch                            *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef __PWMDOCUI_H
#define __PWMDOCUI_H

#include "pwminit.h"

#include <qwidget.h>
#include <klocale.h>

/** string to display, if the pw-entry
  * is locked, in place of the password.
  */
#define LOCKED_STRING		PwMDocUi::string_locked()

/** The name of the "default" category */
#define DEFAULT_CATEGORY	PwMDocUi::string_defaultCategory()

/** deep-lock message to display in main-view, if it's locked */
#define IS_DEEPLOCKED_SHORTMSG	PwMDocUi::string_deepLockedShort()
#define IS_DEEPLOCKED_MSG	PwMDocUi::string_deepLockedLong()

/** default title. Display if the doc has no title, yet */
#define DEFAULT_TITLE		PwMDocUi::string_defaultTitle()

class PwMDoc;

/** User-interface layer for PwMDoc.
  * This class handles for example all Master-password related things (asking
  * the user for the password od the chipcard) and some
  * other UI-things, that PwMDoc is not allowed to
  * handle. (PwMDoc is _NOT_ allowed to handle anything
  * UI related.)
  */
class PwMDocUi : public QObject
{
	Q_OBJECT
public:
	PwMDocUi(QObject* parent = 0, const char *name = 0);
	~PwMDocUi();

	/** return the currentView pointer */
	QWidget* getCurrentView()
			{ return PwMInit::curWidget(); }
	/** saves the document (with user dialog) */
	bool saveDocUi(PwMDoc *doc);
	/** save as (with user dialog) */
	bool saveAsDocUi(PwMDoc *doc);
	/** opens a new document (with user dialog) */
	bool openDocUi(PwMDoc *doc,
		       QString filename = QString::null,
		       bool openDeepLocked = false);

	static QString string_defaultCategory();
	static QString string_locked();
	static QString string_deepLockedShort();
	static QString string_deepLockedLong();
	static QString string_defaultTitle();

protected:
	/** display "can't deeplock, because not saved yet" msg box */
	void cantDeeplock_notSavedMsgBox();
	/** gpasman-export password length error */
	void gpmPwLenErrMsgBox();
	/** ask for saving */
	int dirtyAskSave(const QString &docTitle);
};

#endif
