/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004 by Michael Buesch                            *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef PWMANAGER_RANDOMIZER_H_
#define PWMANAGER_RANDOMIZER_H_

#include <qcstring.h>


class QFile;

/** Randomizer to get random values. */
class Randomizer
{
protected:
	enum Use
	{
		use_none,
		use_urandom,
		use_random,
		use_egd,
		use_rand
	};

public:
	Randomizer();

	void nextOffset(unsigned int off)
			{ offset = off; }
	void nextSize(unsigned int s)
			{ size = s; }

	Randomizer & operator>> (unsigned char *d)
		{ return (operator>>(reinterpret_cast<char *>(d))); }
	Randomizer & operator>> (char *d);

	Randomizer & operator>> (QByteArray &d);

	Randomizer & operator>> (unsigned int &d);
	Randomizer & operator>> (int &d)
		{ return (operator>>(reinterpret_cast<unsigned int &>(d))); }

	Randomizer & operator>> (unsigned char &d);
	Randomizer & operator>> (char &d)
		{ return (operator>>(reinterpret_cast<unsigned char &>(d))); }

protected:
	void probe();
	QFile * get_generic();
	QFile * get_generic(const char *fn);
	QFile * get_urandom()
			{ return get_generic("/dev/urandom"); }
	QFile * get_random()
			{ return get_generic("/dev/random"); }
	QFile * get_egd();
	void put_generic(QFile *f);
	Randomizer & cleanup(QFile *f)
			{
				put_generic(f);
				offset = 0;
				size = 0;
				return *this;
			}

protected:
	/** randomizer to use. */
	static Use use;
	/** next offset to start. */
	unsigned int offset;
	/** next size to randomize. */
	unsigned int size;
};

#endif // PWMANAGER_RANDOMIZER_H_
