/***************************************************************************
 *   Copyright (C) 2007, 2008 by Marcel Hasler                             *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ACCOUNTMANAGER_H
#define ACCOUNTMANAGER_H

#include <qobject.h>
#include <qstring.h>
#include <qtimer.h>

#include <kurl.h>
#include <kio/job.h>

#include "atomparser.h"

class AccountManager : public QObject
{
	Q_OBJECT
public:
	AccountManager();
	~AccountManager();

	bool isValid();

	void checkMail();
	void updateConfiguration();

	bool hasNewMail() const;
	unsigned int messageCount() const;
	const QString& lastSender() const;
	const QString& lastSubject() const;

signals:
	void connectionSuccessful();
	void connectionError(const QString errorStr);

private slots:
	void slotAbortJob();
	void slotParseData(KIO::Job *);

private:
	AccountManager(const AccountManager&);
	AccountManager& operator=(const AccountManager&);

	AtomParser *m_atomParser;

	QString m_accountName;
	QString m_accountPassword;
	unsigned int m_connectionTimeout;

	unsigned int m_lastMessageCount;
	unsigned int m_currentMessageCount;
	QString m_lastSender;
	QString m_lastSubject;

	KIO::FileCopyJob *m_fileCopyJob;
	KURL *m_atomFileUrl;
	KURL *m_tmpFileUrl;
	QTimer *m_jobTimeoutTimer;
};

#endif
