/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

#ifndef PASSWORDDIALOG_H
#define PASSWORDDIALOG_H

//KDE
#include <kpassworddialog.h>
#include <kdesu/su.h>

/**
 * @brief A password dialog.
 *
 * KPasswordDialog subclass to provide extended functionality.
 *
 * Original class: http://websvn.kde.org/trunk/KDE/kdebase/workspace/kcontrol/kfontinst/kcmfontinst/JobRunner.cpp?view=markup
 */
class PasswordDialog : public KPasswordDialog
{
public:
	/**
	* Sets the caption, the prompt and the pixmap.
	*
	* @param parent QWidget parent. Self explanatory.
	*/
	PasswordDialog( QWidget *parent = 0 );
protected:
	/**
	* Reimplemented from KPasswordDialog::checkPassword()
	* to provide password checking ability.
	*
	* @return true if the password is valid, false otherwise. 
	*/
	bool checkPassword();
private:
	KDESu::SuProcess m_suProcess;
};

#endif
