/***************************************************************************
 *   Copyright (C) 2005-2008 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <klocale.h>

#include "kfileitemext.h"

#include "komparatorcopyjob.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

KomparatorCopyJob::KomparatorCopyJob( QWidget *_parent )
	: KomparatorJob( _parent )
{
}

KomparatorCopyJob::~KomparatorCopyJob()
{
}

bool KomparatorCopyJob::initialize()
{
	m_mutex.lock();



	m_initialized = true;
	m_canceled = false;

	m_mutex.unlock();

	return true;
}

void KomparatorCopyJob::run()
{
	if ( !m_initialized ) return;

// 	KFileItemExt *curfile = NULL;
// 	KFileItemExt *match = NULL;
// 	FileTree *checktree_dupes = NULL;
// 	FileTree *checktree_comp = NULL;
// 
// 	QString status;
// 	uint current_file;
// 
// 	if ( m_size && ( m_enable_duplicates_search || m_enable_missing_search || m_enable_newer_search ) )
// 	{ // comparing duplicates by size is the minimum we can do.
// 		status = i18n( "Searching for duplicates..." );
// 		current_file = 0;
// 
// 		match = NULL;
// 		curfile = m_files;
// 
// 		while ( curfile )
// 		{
// 			if ( isCanceled() ) break;
// 
// 			emitProgress( status, (int)((current_file*100)/m_number_of_files) );
// 
// 			if ( !checktree_dupes ) 
// 				registerFile( &checktree_dupes, curfile );
// 			else 
// 				match = checkMatchDupes( &checktree_dupes, checktree_dupes, curfile );
// 
// 			if ( match != NULL )
// 			{
// 				if ( !curfile->isReadable() )
// 				{
// 					curfile = curfile->next;
// 					continue;
// 				}
// 
// 				if ( !match->isReadable() )
// 				{
// 					curfile = curfile->next;
// 					continue;
// 				}
// 
// 				if ( m_ignore_empty )  if ( match->size() == 0 )
// 				{
// 					curfile = curfile->next;
// 					continue;
// 				}
// 
// 				if ( m_binary_comparison )
// 				{
// 					if ( confirmMatchDupes( match, curfile ) )
// 					{
// 						match->hasdupes_size = 1;
// 						match->isdupe_size = 1;
// 						curfile->isdupe_size = 1;
// 						if ( match->duplicates_size )
// 						{
// 							match->duplicates_size->isdupe_size = 1;
// 							match->duplicates_size->dup_size_parent = curfile;
// 						}
// 						curfile->duplicates_size = match->duplicates_size;
// 						match->duplicates_size = curfile;
// 						curfile->dup_size_parent = match;
// 					}
// 				}
// 				else
// 				{
// 					match->hasdupes_size = 1;
// 					match->isdupe_size = 1;
// 					curfile->isdupe_size = 1;
// 					if ( match->duplicates_size )
// 					{
// 						match->duplicates_size->isdupe_size = 1;
// 						match->duplicates_size->dup_size_parent = curfile;
// 					}
// 					curfile->duplicates_size = match->duplicates_size;
// 					match->duplicates_size = curfile;
// 					curfile->dup_size_parent = match;
// 				}
// 			}
// 
// 			current_file++;
// 			curfile = curfile->next;
// 		}
// 
// 		emitProgress( status, -1 );
// 
// 		if ( m_enable_duplicates_search )
// 		{
// 			status = i18n( "Appending duplicates to list view..." );
// 			current_file = 0;
// 
// 			curfile = m_files;
// 
// 			while ( curfile )
// 			{
// 				if ( isCanceled() )  break;
// 
// 				emitProgress( status, (int)((current_file*100)/m_number_of_files) );
// 
// 				if ( curfile->hasdupes_size )
// 				{
// 					QCustomEvent *event = new QCustomEvent( RESULT_DUPLICATE );
// 					event->setData( curfile );
// 					QApplication::postEvent( m_parent, event );
// 				}
// 
// 				current_file++;
// 				curfile = curfile->next;
// 			}
// 		}
// 
// 		emitProgress( status, -1 );
// 	}
// 
// 	if ( ( m_enable_duplicates_search && !m_size ) || m_enable_missing_search || m_enable_newer_search )
// 	{
// 		status = i18n( "Searching for missing / newer files..." );
// 		current_file = 0;
// 
// 		match = NULL;
// 		curfile = m_files;
// 
// 		while ( curfile )
// 		{
// 			if ( isCanceled() )  break;
// 
// 			emitProgress( status, (int)((current_file*100)/m_number_of_files) );
// 
// 			if ( !checktree_comp )
// 				registerFile( &checktree_comp, curfile );
// 			else
// 				match = checkMatchComp( &checktree_comp, checktree_comp, curfile );
// 
// 			if ( match != NULL )
// 			{
// 				match->hasdupes_path = 1;
// 				match->isdupe_path = 1;
// 				curfile->isdupe_path = 1;
// 				curfile->duplicates_path = match->duplicates_path;
// 				match->duplicates_path = curfile;
// 				curfile->dup_path_parent = match;
// 			}
// 
// 			current_file++;
// 			curfile = curfile->next;
// 		}
// 
// 		emitProgress( status, -1 );
// 
// 		KFileItemExt *tmpfile;
// 
// 		status = i18n( "Appending missing / newer files to list views..." );
// 		current_file = 0;
// 
// 		curfile = m_files;
// 
// 		while ( curfile )
// 		{
// 			if ( isCanceled() ) break;
// 
// 			emitProgress( status, (int)((current_file*100)/m_number_of_files) );
// 
// 			QPtrList< QPair<KFileItemExt*, KFileItemExt*> > list;
// 
// 			if ( curfile->hasdupes_path )
// 			{
// 				QPair<KFileItemExt*, KFileItemExt*> *pair = new QPair<KFileItemExt*, KFileItemExt*>;
// 				*pair = qMakePair( curfile, (KFileItemExt*)NULL );
// 				list.append( pair );
// 
// 				QPair<KFileItemExt*, KFileItemExt*> *tmppair;
// 				bool inserted;
// 
// 				tmpfile = curfile->duplicates_path;
// 				while ( tmpfile )
// 				{
// 					if ( isCanceled() ) break;
// 
// 					inserted = false;
// 
// 					for ( tmppair = list.first(); tmppair; tmppair = list.next() ) // if two paths are identical, we have a pair.
// 					{                                                              // otherwise it's <item, NULL>.
// 						if ( tmppair->second == NULL )
// 						{
// 							if ( comparePath( tmpfile, tmppair->first ) == 0 ) // comparePath returns qstrcmp result; 0 if equal
// 							{
// 								tmppair->second = tmpfile;
// 								inserted = true;
// 							}
// 						}
// 					}
// 
// 					if ( !inserted )
// 					{
// 						QPair<KFileItemExt*, KFileItemExt*> *pair2 = new QPair<KFileItemExt*, KFileItemExt*>;
// 						*pair2 = qMakePair( curfile, (KFileItemExt*)NULL );
// 						list.append( pair2 );
// 					}
// 
// 					tmpfile = tmpfile->duplicates_path;
// 				}
// 
// 				for ( tmppair = list.first(); tmppair; tmppair = list.next() )
// 				{
// 					if ( tmppair->second == NULL ) // a file that has no equivalent on the other side.
// 					{
// 						if ( m_enable_missing_search )
// 						{
// 							QCustomEvent *event = new QCustomEvent( RESULT_COMP_MISSING );
// 							event->setData( tmppair->first );
// 							QApplication::postEvent( m_parent, event );
// 						}
// 					}
// 					else                          // found two identical paths. must check for newer file.
// 					{
// 						KFileItemExt *neweritem = newerItem( tmppair->first, tmppair->second );
// 						if ( neweritem != NULL )    // we have files with the same path+name, but different mod time...
// 						{
// 							QPair<KFileItemExt*, KFileItemExt*> *resultpair = new QPair<KFileItemExt*, KFileItemExt*>;
// 
// 							if ( neweritem == tmppair->first ) *resultpair = qMakePair( tmppair->first, tmppair->second );
// 							else *resultpair = qMakePair( tmppair->second, tmppair->first );
// 
// 							// check if files are duplicates.
// 							bool are_duplicates = false;
// 
// 							if ( resultpair->first->size() == 0 && resultpair->second->size() == 0 ) are_duplicates = true;
// 
// 							tmpfile = resultpair->first;
// 							while( tmpfile && !are_duplicates )
// 							{
// 								if ( tmpfile == resultpair->second ) are_duplicates = true;
// 								tmpfile = tmpfile->duplicates_size;
// 							}
// 
// 							tmpfile = resultpair->second;
// 							while( tmpfile && !are_duplicates )
// 							{
// 								if ( tmpfile == resultpair->first ) are_duplicates = true;
// 								tmpfile = tmpfile->duplicates_size;
// 							}
// 
// 							if ( m_enable_newer_search )
// 							{ // if !size we always find newer, not newer_equal
// 								QCustomEvent *event = new QCustomEvent( are_duplicates ? RESULT_COMP_NEWER_EQUAL : RESULT_COMP_NEWER );
// 								event->setData( resultpair );
// 								QApplication::postEvent( m_parent, event );
// 							}
// 							else
// 							{
// 								delete resultpair;
// 							}
// 						}
// 						else // ... find files that are different, but have the same timestamp
// 						{
// 							if ( isCanceled() ) break;
// 
// 							// check if files are duplicates.
// 							bool are_duplicates = false;
// 
// 							if ( tmppair->first->size() == 0 && tmppair->second->size() == 0 ) are_duplicates = true;
// 
// 							tmpfile = tmppair->first;
// 							while( tmpfile && !are_duplicates )
// 							{
// 								if ( tmpfile == tmppair->second ) are_duplicates = true;
// 								tmpfile = tmpfile->duplicates_size;
// 							}
// 
// 							tmpfile = tmppair->second;
// 							while( tmpfile && !are_duplicates )
// 							{
// 								if ( tmpfile == tmppair->first ) are_duplicates = true;
// 								tmpfile = tmpfile->duplicates_size;
// 							}
// 
// 							if ( !are_duplicates )  // if !size we shouldn't report all the files as different.
// 							{                       // the rare case of equal but same time isn't considered as user disabled search by size.
// 								if ( m_size )
// 								{
// 									if ( m_enable_newer_search )
// 									{
// 										QPair<KFileItemExt*, KFileItemExt*> *resultpair = new QPair<KFileItemExt*, KFileItemExt*>;
// 										*resultpair = qMakePair( tmppair->first, tmppair->second );
// 
// 										QCustomEvent *event = new QCustomEvent( RESULT_COMP_DIFFERENT );
// 										event->setData( resultpair );
// 										QApplication::postEvent( m_parent, event );
// 									}
// 								}
// 								else // we don't search for size duplicates, and the file doesn't belong to missing or newer list.
// 								{    // so we abuse the duplicates list view to display the duplicates by path. (no duplicates by size will be displayed!).
// 									if ( m_enable_duplicates_search )
// 									{
// 										tmppair->first->duplicates_size = tmppair->second;
// 										tmppair->second->dup_size_parent = tmppair->first;
// 										tmppair->first->hasdupes_size = 1;
// 										tmppair->first->isdupe_size = 1;
// 										tmppair->second->isdupe_size = 1;
// 										QCustomEvent *event = new QCustomEvent( RESULT_DUPLICATE );
// 										event->setData( tmppair->first );
// 										QApplication::postEvent( m_parent, event );
// 									}
// 								}
// 							}
// 						}
// 					}
// 				}
// 
// 				QPair<KFileItemExt*, KFileItemExt*> *delpair;
// 
// 				for ( delpair = list.first(); delpair; delpair = list.next() )
// 				{
// 					delete delpair;
// 				}
// 			}
// 			else
// 			{
// 				if ( !curfile->isdupe_path )
// 				{
// 					if ( m_enable_missing_search )
// 					{
// 						QCustomEvent *event = new QCustomEvent( RESULT_COMP_MISSING );
// 						event->setData( curfile );
// 						QApplication::postEvent( m_parent, event );
// 					}
// 				}
// 			}
// 
// 			current_file++;
// 			curfile = curfile->next;
// 		}
// 
// 		emitProgress( status, -1 );
// 	}
// 
// 	purgeTree( checktree_dupes );
// 	purgeTree( checktree_comp );
// 
// 	if ( !isCanceled() )
// 	{
// 		QCustomEvent *event = new QCustomEvent( RESULT_COMP_FINISHED );
// 		QApplication::postEvent( m_parent, event );
// 	}

	m_initialized = false;
}
