/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//KDE Includes
#include <kcombobox.h>
#include <kurlrequester.h>
#include <knuminput.h>
#include <klineedit.h>

//QT Includes
#include <qwidget.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qcheckbox.h>

//kX Generator Includes
#include "Xorg.h"

class KeyboardWidget : public QWidget
{
    Q_OBJECT
public:
KeyboardWidget(QWidget *Parent = 0, Xorg *Xorg = 0);

private:
QString Locale (int n);

KComboBox *KeyboardCombo;
KComboBox *DriverCombo;
KComboBox *LayoutCombo;
KComboBox *ModelCombo;
KComboBox *ProtocolCombo;
KLineEdit *URLLine;
KURLRequester *URL;
KIntSpinBox *DelaySpin;
KIntSpinBox *RepeatSpin;


QCheckBox *NoDevice;
QGroupBox *AutoRepeatGroup;
QLabel *DeviceLabel;


Xorg *X;

public slots:
void RefreshKeyboardCombo();
void Init();
void NoDeviceCheckBoxStateChanged();
void SaveDeviceURL();
void SaveLayout();
void SaveDriver();
void SaveProtocol();
void SaveModel();
void AutoRepeatGroupToggled();
void AutoRepeatSave();
void ChangeEntries();
};
