/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//QT Includes
#include <qfile.h>
#include <qdir.h>

//KDE Includes
#include <kmessagebox.h>

//kX Generator Includes
#include "MainWidget.h"
#include "ServerLayoutWidget.h"
#include "MouseWidget.h"
#include "KeyboardWidget.h"
#include "VideocardWidget.h"
#include "MonitorWidget.h"
#include "AdvancedWidget.h"
#include "properties.h"

ServerLayoutWidget *ServerLayout;
MouseWidget *Mouse;
KeyboardWidget *Keyboard;
VideocardWidget *Videocard;
MonitorWidget *Monitor;
AdvancedWidget *Advanced;

MainWidget :: MainWidget(QWidget *Parent, Xorg *Xorg)
    : QWidget( Parent, "Main Widget" )
{

X = Xorg;



//Setting window geometry
if (LOGO) { setGeometry(230, 182, 560, 339); }
else
{ setGeometry(230, 10, 560, 339); }

//Creating objects


ServerLayout = new ServerLayoutWidget(this, X);
Mouse = new MouseWidget(this, X);
Keyboard = new KeyboardWidget(this, X);
Videocard = new VideocardWidget(this, X);
Monitor = new MonitorWidget(this, X);
Advanced = new AdvancedWidget(this, X);



//Hiding objects
      ServerLayout->hide();
      Mouse->hide();
      Keyboard->hide();
      Videocard->hide();
      Monitor->hide();
      Advanced->hide();

}


void MainWidget :: ShowServerLayoutWidget()
  {
   Mouse->hide();
   ServerLayout->show();
   ServerLayout->Init();
   Keyboard->hide();
   Videocard->hide();
   Monitor->hide();
   Advanced->hide();
  }

void MainWidget :: ShowMouseWidget()
{
   ServerLayout->hide();
   Keyboard->hide();
   Mouse->show();
   Videocard->hide();
   Monitor->hide();
   Advanced->hide();
}

void MainWidget :: ShowKeyboardWidget()
{
   Keyboard->show();
   Mouse->hide();
   ServerLayout->hide();
   Videocard->hide();
   Monitor->hide();
   Advanced->hide();
}

void MainWidget :: ShowVideocardWidget()
{
   Keyboard->hide();
   Mouse->hide();
   ServerLayout->hide();
   Videocard->show();
   Monitor->hide();
   Advanced->hide();
}

void MainWidget :: ShowMonitorWidget()
{
   Keyboard->hide();
   Mouse->hide();
   ServerLayout->hide();
   Videocard->hide();
   Monitor->show();
   Monitor->RefreshMonitorCombo();
   Advanced->hide();
}

void MainWidget :: ShowAdvancedWidget()
{
   Keyboard->hide();
   Mouse->hide();
   ServerLayout->hide();
   Videocard->hide();
   Monitor->hide();
   Advanced->show();
}





