/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//KDE Includes
#include <kiconloader.h>
#include <ktabwidget.h>
#include <kinputdialog.h>
#include <kmessagebox.h>
//QT Includes
#include <qframe.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qtooltip.h>
#include <qlabel.h>

//kX Generator Includes
#include "PropertiesDialog.h"
#include "properties.h"

void PropertiesDialog :: CreateWindow(int x, int y, QString DriverName, QString IconName, QWidget *ParentWindow)
{
KIconLoader *Icons = new KIconLoader();
OptionsDialog = new KDialog(ParentWindow);

OptionsDialog->setMinimumSize(x, y);
OptionsDialog->setMaximumSize(x, y);
OptionsDialog->setPlainCaption(Locale(0));

  OKButton = new KPushButton(OptionsDialog);
  OKButton->setGeometry(x - 240, y - 39, 110, 29);
  OKButton->setText(Locale(1));
  OKButton->setIconSet(Icons->loadIcon("ok", KIcon::Desktop, KIcon::SizeSmall));
  OKButton->show();

  CancelButton = new KPushButton(OptionsDialog);
  CancelButton->setGeometry(x - 120, y - 39, 110, 29);
  CancelButton->setText(Locale(2));
  CancelButton->setIconSet(Icons->loadIcon("cancel", KIcon::Desktop, KIcon::SizeSmall));
  CancelButton->show();

   QFrame *LineBottom = new QFrame(OptionsDialog);
    LineBottom->setGeometry(QRect(10, y - 49, x - 20, 5));
    LineBottom->setFrameShape( QFrame::HLine );
    LineBottom->setFrameShadow( QFrame::Sunken );
    LineBottom->show();

    QLabel *Pixmap = new QLabel(OptionsDialog);
     Pixmap->setGeometry(x - 138, 10, 128, 128);
     Pixmap->setPixmap(Icons->loadIcon(IconName, KIcon::Desktop, KIcon::SizeEnormous));

   QLabel *LogoLabel = new QLabel(OptionsDialog);
    LogoLabel->setText(Locale(5).arg("<b><i>" + DriverName));
    LogoLabel->setFont(QFont("sans", 15, QFont::Normal, FALSE));
    LogoLabel->setGeometry(10, 10, x - 150, 35);

   QFrame *Line = new QFrame(OptionsDialog);
    Line->setGeometry(QRect(10, 45, x - 150, 5));
    Line->setFrameShape( QFrame::HLine );
    Line->setFrameShadow( QFrame::Sunken );

   InformationLabel = new QLabel(OptionsDialog);
    InformationLabel->setGeometry(10, 60, x - 150, 85);
    InformationLabel->setAlignment(QLabel::AlignTop | QLabel::WordBreak);

connect (CancelButton, SIGNAL(clicked()), OptionsDialog, SLOT(reject()));
}




void PropertiesDialog :: NoOptions(QString DriverName)
{
KMessageBox::sorry(this, Locale(171).arg(DriverName), Locale(170));
}



///Input Drivers

//MOUSE Driver

void PropertiesDialog :: SetOptions_MOUSE(QWidget *Parent, Xorg *Xorg, int SectionNumber)
{
CreateWindow(600, 510, "mouse", "mouse", Parent);

SecNum = SectionNumber;
X = Xorg;

  Group[0] = new QGroupBox(OptionsDialog);
   Group[0]->setGeometry(10, 150, 300, 300);
   Group[0]->setTitle(Locale(3));
   Group[0]->show();

InformationLabel->setText(Locale(6).append("<br><br>" + Locale(25) + " <b>" + X->GetValue(Xorg::InputDevice, SectionNumber, "Identifier", 1) + "</b>"));


//Protocol label
   Label[0] = new QLabel(Group[0]);
    Label[0]->setGeometry(10, 20, 130, 25);
    Label[0]->setText(Locale(4));
    Label[0]->show();

//Protocol combo
   Combo[0] = new KComboBox(Group[0]);
    Combo[0]->setGeometry(130, 20, 160, 25);
    Combo[0]->show();

//Baud rate label
   Label[1] = new QLabel(Group[0]);
    Label[1]->setGeometry(10, 50, 130, 25);
    Label[1]->setText(Locale(8));
    Label[1]->show();

//Baud Rate
   Combo[1] = new KComboBox(Group[0]);
    Combo[1]->setGeometry(130, 50, 160, 25);
    Combo[1]->show();









///Button number

//Number of buttons label
   Label[2] = new QLabel(Group[0]);
    Label[2]->setGeometry(10, 80, 170, 25);
    Label[2]->setText(Locale(9));
    Label[2]->show();

//Number of buttons spin box
   SpinBox[0] = new KIntSpinBox(Group[0]);
    SpinBox[0]->setGeometry(130, 80, 50, 25);
    SpinBox[0]->setMinValue(0);
    SpinBox[0]->setMaxValue(24);

//Autodetect buttons check box

   Check[0] = new QCheckBox(Group[0]);
    Check[0]->setGeometry(190, 80, 100, 25);
    Check[0]->setText(Locale(7));




///Sample rate
//Sample rate label
   Label[3] = new QLabel(Group[0]);
    Label[3]->setGeometry(10, 110, 130, 25);
    Label[3]->setText(Locale(10));
    Label[3]->show();

//Sample rate spin box
   SpinBox[1] = new KIntSpinBox(Group[0]);
    SpinBox[1]->setGeometry(130, 110, 50, 25);
    SpinBox[1]->setMinValue(0);
    SpinBox[1]->setMaxValue(5000);

//Autodetect sample rate check box

   Check[1] = new QCheckBox(Group[0]);
    Check[1]->setGeometry(190, 110, 100, 25);
    Check[1]->setText(Locale(7));


///Resolution

//Resolution label
   Label[4] = new QLabel(Group[0]);
    Label[4]->setGeometry(10, 140, 130, 25);
    Label[4]->setText(Locale(11));
    Label[4]->show();

//Resolution spin box
   SpinBox[2] = new KIntSpinBox(Group[0]);
    SpinBox[2]->setGeometry(130, 140, 50, 25);
    SpinBox[2]->setMinValue(0);
    SpinBox[2]->setMaxValue(5000);

//Autodetect Resolution check box

   Check[2] = new QCheckBox(Group[0]);
    Check[2]->setGeometry(190, 140, 100, 25);
    Check[2]->setText(Locale(7));





//Middle button L+R event
   Check[3] = new QCheckBox(Group[0]);
    Check[3]->setGeometry(10, 170, 280, 25);
    Check[3]->setText(Locale(12));

//Clear DTR
   Check[4] = new QCheckBox(Group[0]);
    Check[4]->setGeometry(10, 200, 140, 25);
    Check[4]->setText(Locale(13));

//Clear RTS
   Check[5] = new QCheckBox(Group[0]);
    Check[5]->setGeometry(10, 230, 140, 25);
    Check[5]->setText(Locale(14));

//Flip X
   Check[6] = new QCheckBox(Group[0]);
    Check[6]->setGeometry(140, 200, 140, 25);
    Check[6]->setText(Locale(15));

//Flip Y
   Check[7] = new QCheckBox(Group[0]);
    Check[7]->setGeometry(140, 230, 140, 25);
    Check[7]->setText(Locale(16));

//Flip Y
   Check[8] = new QCheckBox(Group[0]);
    Check[8]->setGeometry(10, 260, 140, 25);
    Check[8]->setText(Locale(26));



   Group[1] = new QGroupBox(OptionsDialog);
    Group[1]->setGeometry(320, 150, 270, 65);
    Group[1]->setTitle(Locale(17));
    Group[1]->setCheckable(TRUE);
    Group[1]->setChecked(FALSE);

   Label[5] = new QLabel(Group[1]);
    Label[5]->setGeometry(10, 25, 200, 25);
    Label[5]->setText(Locale(18));

   SpinBox[3] = new KIntSpinBox(Group[1]);
    SpinBox[3]->setGeometry(210, 25, 50, 25);
    SpinBox[3]->setMinValue(0);
    SpinBox[3]->setMaxValue(360);



   Group[2] = new QGroupBox(OptionsDialog);
    Group[2]->setGeometry(320, 230, 270, 65);
    Group[2]->setTitle(Locale(19));
    Group[2]->setCheckable(TRUE);
    Group[2]->setChecked(FALSE);

   Label[6] = new QLabel(Group[2]);
    Label[6]->setGeometry(10, 25, 200, 25);
    Label[6]->setText(Locale(20));

   SpinBox[4] = new KIntSpinBox(Group[2]);
    SpinBox[4]->setGeometry(210, 25, 50, 25);
    SpinBox[4]->setMinValue(0);
    SpinBox[4]->setMaxValue(360);



   Group[3] = new QGroupBox(OptionsDialog);
    Group[3]->setGeometry(320, 320, 270, 130);
    Group[3]->setTitle(Locale(21));
    Group[3]->setCheckable(TRUE);
    Group[3]->setChecked(FALSE);

   Label[7] = new QLabel(Group[3]);
    Label[7]->setGeometry(10, 25, 200, 25);
    Label[7]->setText(Locale(22));

   SpinBox[5] = new KIntSpinBox(Group[3]);
    SpinBox[5]->setGeometry(210, 25, 50, 25);
    SpinBox[5]->setMinValue(0);
    SpinBox[5]->setMaxValue(24);

   Label[8] = new QLabel(Group[3]);
    Label[8]->setGeometry(10, 60, 200, 25);
    Label[8]->setText(Locale(23));

   SpinBox[6] = new KIntSpinBox(Group[3]);
    SpinBox[6]->setGeometry(210, 60, 50, 25);
    SpinBox[6]->setMinValue(0);
    SpinBox[6]->setMaxValue(2000);

   Label[9] = new QLabel(Group[3]);
    Label[9]->setGeometry(10, 95, 200, 25);
    Label[9]->setText(Locale(24));

   SpinBox[7] = new KIntSpinBox(Group[3]);
    SpinBox[7]->setGeometry(210, 95, 50, 25);
    SpinBox[7]->setMinValue(20);
    SpinBox[7]->setMaxValue(2000);



//Inserting combo box entries

    Combo[0]->insertItem("Auto");
    Combo[0]->insertItem("Microsoft");
    Combo[0]->insertItem("MouseSystems");
    Combo[0]->insertItem("MMSeries");
    Combo[0]->insertItem("Logitech");
    Combo[0]->insertItem("MouseMan");
    Combo[0]->insertItem("MMHitTab");
    Combo[0]->insertItem("GlidePoint");
    Combo[0]->insertItem("IntelliMouse");
    Combo[0]->insertItem("ThinkingMouse");
    Combo[0]->insertItem("ValuMouseScroll");
    Combo[0]->insertItem("AceCad");
    Combo[0]->insertItem("PS/2");
    Combo[0]->insertItem("ImPS/2");
    Combo[0]->insertItem("ExplorerPS/2");
    Combo[0]->insertItem("ThinkingMousePS/2");
    Combo[0]->insertItem("MouseManPlusPS/2");
    Combo[0]->insertItem("GlidePointPS/2");
    Combo[0]->insertItem("NetMousePS/2");
    Combo[0]->insertItem("NetScrollPS/2");
    Combo[0]->insertItem("BusMouse");
    Combo[0]->insertItem("SysMouse");
    Combo[0]->insertItem("WSMouse");
    Combo[0]->insertItem("USB");
    Combo[0]->insertItem("Xqueue");

    Combo[1]->insertItem(Locale(7));
    Combo[1]->insertItem("300");
    Combo[1]->insertItem("1200 (default)");
    Combo[1]->insertItem("2400");
    Combo[1]->insertItem("4800");
    Combo[1]->insertItem("9600");
    Combo[1]->insertItem("19200");





//Connecting
   connect(Check[0], SIGNAL(toggled(bool)), this, SLOT(MOUSE_ButtonsCheck(bool)));
   connect(Check[1], SIGNAL(toggled(bool)), this, SLOT(MOUSE_SampleCheck(bool)));
   connect(Check[2], SIGNAL(toggled(bool)), this, SLOT(MOUSE_ResolutionCheck(bool)));
   connect(OKButton, SIGNAL(clicked()), this, SLOT(MOUSE_SaveAndExit()));




//Initializing...
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "")                  { Combo[0]->setCurrentItem(0);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "auto")              { Combo[0]->setCurrentItem(0);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "microsoft")         { Combo[0]->setCurrentItem(1);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "mousesystems")      { Combo[0]->setCurrentItem(2);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "mmseries")          { Combo[0]->setCurrentItem(3);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "logitech")          { Combo[0]->setCurrentItem(4);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "mouseman")          { Combo[0]->setCurrentItem(5);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "mmhittab")          { Combo[0]->setCurrentItem(6);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "glidepoint")        { Combo[0]->setCurrentItem(7);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "intellimouse")      { Combo[0]->setCurrentItem(8);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "thinkingmouse")     { Combo[0]->setCurrentItem(9);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "valumousescroll")   { Combo[0]->setCurrentItem(10); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "acecad")            { Combo[0]->setCurrentItem(11); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "ps/2")              { Combo[0]->setCurrentItem(12); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "imps/2")            { Combo[0]->setCurrentItem(13); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "explorerps/2")      { Combo[0]->setCurrentItem(14); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "thinkingmouseps/2") { Combo[0]->setCurrentItem(15); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "mousemanplusps/2")  { Combo[0]->setCurrentItem(16); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "glidepointps/2")    { Combo[0]->setCurrentItem(17); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "netmouseps/2")      { Combo[0]->setCurrentItem(18); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "netscrollps/2")     { Combo[0]->setCurrentItem(19); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "busmouse")          { Combo[0]->setCurrentItem(20); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "sysmouse")          { Combo[0]->setCurrentItem(21); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "wsmouse")           { Combo[0]->setCurrentItem(22); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "usb")               { Combo[0]->setCurrentItem(23); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Protocol").lower() == "xqueue")            { Combo[0]->setCurrentItem(24); }

if (X->GetOption(Xorg::InputDevice, SecNum, "BaudRate").lower() == "")                  { Combo[1]->setCurrentItem(0);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "BaudRate").lower() == "300")               { Combo[1]->setCurrentItem(1);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "BaudRate").lower() == "1200")              { Combo[1]->setCurrentItem(2);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "BaudRate").lower() == "2400")              { Combo[1]->setCurrentItem(3);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "BaudRate").lower() == "4800")              { Combo[1]->setCurrentItem(4);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "BaudRate").lower() == "9600")              { Combo[1]->setCurrentItem(5);  }
if (X->GetOption(Xorg::InputDevice, SecNum, "BaudRate").lower() == "19200")             { Combo[1]->setCurrentItem(6);  }




bool ok;

if (X->GetOption(Xorg::InputDevice, SecNum, "Buttons") == "") 
{ Check[0]->setChecked(TRUE); }
else
{ Check[0]->setChecked(FALSE); SpinBox[0]->setValue(X->GetOption(Xorg::InputDevice, SecNum, "Buttons").toInt(&ok, 10)); }



if (X->GetOption(Xorg::InputDevice, SecNum, "SampleRate") == "") 
{ Check[1]->setChecked(TRUE); }
else
{ Check[1]->setChecked(FALSE); SpinBox[1]->setValue(X->GetOption(Xorg::InputDevice, SecNum, "SampleRate").toInt(&ok, 10)); }


if (X->GetOption(Xorg::InputDevice, SecNum, "Resolution") == "") 
{ Check[2]->setChecked(TRUE); }
else
{ Check[2]->setChecked(FALSE); SpinBox[2]->setValue(X->GetOption(Xorg::InputDevice, SecNum, "Resolution").toInt(&ok, 10)); }


if (X->GetOption(Xorg::InputDevice, SecNum, "AngleOffset") == "") 
{ Group[1]->setChecked(FALSE); }
else
{ Group[1]->setChecked(TRUE); SpinBox[3]->setValue(X->GetOption(Xorg::InputDevice, SecNum, "AngleOffset").toInt(&ok, 10)); }



if (X->GetBoolOption(Xorg::InputDevice, SecNum, "Emulate3Buttons"))
{
Group[2]->setChecked(TRUE);
  if (X->GetOption(Xorg::InputDevice, SecNum, "Emulate3Timeout") != "")
   {
    SpinBox[4]->setValue(X->GetOption(Xorg::InputDevice, SecNum, "Emulate3Timeout").toInt(&ok, 10));
   }
  else
   {
    SpinBox[4]->setValue(50);                 //Default
   }

}

if (X->GetBoolOption(Xorg::InputDevice, SecNum, "EmulateWheel")) 
{
Group[3]->setChecked(TRUE);

  if (X->GetOption(Xorg::InputDevice, SecNum, "EmulateWheelButton") != "")
   {
    SpinBox[5]->setValue(X->GetOption(Xorg::InputDevice, SecNum, "EmulateWheelButton").toInt(&ok, 10));
   }
  else
   {
    SpinBox[5]->setValue(4);                 //Default
   }

  if (X->GetOption(Xorg::InputDevice, SecNum, "EmulateWheelInertia") != "")
   {
    SpinBox[6]->setValue(X->GetOption(Xorg::InputDevice, SecNum, "EmulateWheelInertia").toInt(&ok, 10));
   }
  else
   {
    SpinBox[6]->setValue(50);                 //Default
   }

  if (X->GetOption(Xorg::InputDevice, SecNum, "EmulateWheelTimeout") != "")
   {
    SpinBox[7]->setValue(X->GetOption(Xorg::InputDevice, SecNum, "EmulateWheelTimeout").toInt(&ok, 10));
   }
  else
   {
    SpinBox[7]->setValue(300);                 //Default
   }

}




if (X->GetBoolOption(Xorg::InputDevice, SecNum, "ChordMiddle"))             { Check[3]->setChecked(TRUE); }
if (!X->GetBoolOption(Xorg::InputDevice, SecNum, "ChordMiddle"))            { Check[3]->setChecked(FALSE); }
if (X->GetBoolOption(Xorg::InputDevice, SecNum, "ClearDTR"))                { Check[4]->setChecked(TRUE); }
if (!X->GetBoolOption(Xorg::InputDevice, SecNum, "ClearDTR"))               { Check[4]->setChecked(FALSE); }
if (X->GetBoolOption(Xorg::InputDevice, SecNum, "ClearRTS"))                { Check[5]->setChecked(TRUE); }
if (!X->GetBoolOption(Xorg::InputDevice, SecNum, "ClearRTS"))               { Check[5]->setChecked(FALSE); }
if (X->GetBoolOption(Xorg::InputDevice, SecNum, "InvX"))                    { Check[6]->setChecked(TRUE); }
if (!X->GetBoolOption(Xorg::InputDevice, SecNum, "InvX"))                   { Check[6]->setChecked(FALSE); }
if (X->GetBoolOption(Xorg::InputDevice, SecNum, "InvY"))                    { Check[7]->setChecked(TRUE); }
if (!X->GetBoolOption(Xorg::InputDevice, SecNum, "InvY"))                   { Check[7]->setChecked(FALSE); }
if (X->GetBoolOption(Xorg::InputDevice, SecNum, "FlipXY"))                  { Check[8]->setChecked(TRUE); }
if (!X->GetBoolOption(Xorg::InputDevice, SecNum, "FlipXY"))                 { Check[8]->setChecked(FALSE); }


//Adding tooltips

QToolTip::add(Combo[0], "<b>" + Locale(4).remove(":") + "</b><br><br>" + Locale(27));
QToolTip::add(Combo[1], "<b>" + Locale(8).remove(":") + "</b><br><br>" + Locale(28));
QToolTip::add(SpinBox[0], "<b>" + Locale(9).remove(":") + "</b><br><br>" + Locale(29));
QToolTip::add(SpinBox[1], "<b>" + Locale(10).remove(":") + "</b><br><br>" + Locale(30));
QToolTip::add(SpinBox[2], "<b>" + Locale(11).remove(":") + "</b><br><br>" + Locale(31));
QToolTip::add(Check[3], "<b>" + Locale(12).remove(":") + "</b><br><br>" + Locale(32));
QToolTip::add(Check[4], "<b>" + Locale(13).remove(":") + "</b><br><br>" + Locale(33));
QToolTip::add(Check[5], "<b>" + Locale(14).remove(":") + "</b><br><br>" + Locale(34));
QToolTip::add(Check[6], "<b>" + Locale(15).remove(":") + "</b><br><br>" + Locale(35));
QToolTip::add(Check[7], "<b>" + Locale(16).remove(":") + "</b><br><br>" + Locale(36));
QToolTip::add(Check[8], "<b>" + Locale(26).remove(":") + "</b><br><br>" + Locale(37));
QToolTip::add(Group[1], "<b>" + Locale(17).remove(":") + "</b><br><br>" + Locale(38));
QToolTip::add(SpinBox[3], "<b>" + Locale(17).remove(":") + "</b><br><br>" + Locale(38));
QToolTip::add(Group[2], "<b>" + Locale(19).remove(":") + "</b><br><br>" + Locale(39));
QToolTip::add(SpinBox[4], "<b>" + Locale(20).remove(":") + "</b><br><br>" + Locale(40));
QToolTip::add(Group[3], "<b>" + Locale(21).remove(":") + "</b><br><br>" + Locale(41));
QToolTip::add(SpinBox[5], "<b>" + Locale(22).remove(":") + "</b><br><br>" + Locale(42));
QToolTip::add(SpinBox[6], "<b>" + Locale(23).remove(":") + "</b><br><br>" + Locale(43));
OptionsDialog->exec();
}

void PropertiesDialog :: MOUSE_ButtonsCheck(bool Checked)
{
if (Checked)
  {
   Label[2]->setEnabled(FALSE);
   SpinBox[0]->setEnabled(FALSE);
  }
else
  {
   Label[2]->setEnabled(TRUE);
   SpinBox[0]->setEnabled(TRUE);
  }
}

void PropertiesDialog :: MOUSE_SampleCheck(bool Checked)
{
if (Checked)
  {
   Label[3]->setEnabled(FALSE);
   SpinBox[1]->setEnabled(FALSE);
  }
else
  {
   Label[3]->setEnabled(TRUE);
   SpinBox[1]->setEnabled(TRUE);
  }
}

void PropertiesDialog :: MOUSE_ResolutionCheck(bool Checked)
{
if (Checked)
  {
   Label[4]->setEnabled(FALSE);
   SpinBox[2]->setEnabled(FALSE);
  }
else
  {
   Label[4]->setEnabled(TRUE);
   SpinBox[2]->setEnabled(TRUE);
  }
}

void PropertiesDialog :: MOUSE_SaveAndExit()
{
QString Num;

    if (Combo[0]->currentItem() == 0)            { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "Auto"); }
    if (Combo[0]->currentItem() == 1)            { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "Microsoft"); }
    if (Combo[0]->currentItem() == 2)            { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "MouseSystems"); }
    if (Combo[0]->currentItem() == 3)            { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "MMSeries"); }
    if (Combo[0]->currentItem() == 4)            { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "Logitech"); }
    if (Combo[0]->currentItem() == 5)            { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "MouseMan"); }
    if (Combo[0]->currentItem() == 6)            { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "MMHitTab"); }
    if (Combo[0]->currentItem() == 7)            { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "GlidePoint"); }
    if (Combo[0]->currentItem() == 8)            { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "IntelliMouse"); }
    if (Combo[0]->currentItem() == 9)            { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "ThinkingMouse"); }
    if (Combo[0]->currentItem() == 10)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "ValuMouseScroll"); }
    if (Combo[0]->currentItem() == 11)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "AceCad"); }
    if (Combo[0]->currentItem() == 12)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "PS/2"); }
    if (Combo[0]->currentItem() == 13)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "ImPS/2"); }
    if (Combo[0]->currentItem() == 14)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "ExplorerPS/2"); }
    if (Combo[0]->currentItem() == 15)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "ThinkingMousePS/2"); }
    if (Combo[0]->currentItem() == 16)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "MouseManPlusPS/2"); }
    if (Combo[0]->currentItem() == 17)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "GlidePointPS/2"); }
    if (Combo[0]->currentItem() == 18)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "NetMousePS/2"); }
    if (Combo[0]->currentItem() == 19)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "NetScrollPS/2"); }
    if (Combo[0]->currentItem() == 20)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "BusMouse"); }
    if (Combo[0]->currentItem() == 21)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "SysMouse"); }
    if (Combo[0]->currentItem() == 22)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "WSMouse"); }
    if (Combo[0]->currentItem() == 23)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "USB"); }
    if (Combo[0]->currentItem() == 24)           { X->WriteOption(Xorg::InputDevice, SecNum, "Protocol", "Xqueue"); }


    if (Combo[1]->currentItem() == 0) { X->RemoveOption(Xorg::InputDevice, SecNum, "BaudRate");   }
    if (Combo[1]->currentItem() == 1) { X->WriteOption(Xorg::InputDevice, SecNum, "BaudRate", "300");   }
    if (Combo[1]->currentItem() == 2) { X->WriteOption(Xorg::InputDevice, SecNum, "BaudRate", "1200");  }
    if (Combo[1]->currentItem() == 3) { X->WriteOption(Xorg::InputDevice, SecNum, "BaudRate", "2400");  }
    if (Combo[1]->currentItem() == 4) { X->WriteOption(Xorg::InputDevice, SecNum, "BaudRate", "4800");  }
    if (Combo[1]->currentItem() == 5) { X->WriteOption(Xorg::InputDevice, SecNum, "BaudRate", "9600");  }
    if (Combo[1]->currentItem() == 6) { X->WriteOption(Xorg::InputDevice, SecNum, "BaudRate", "19200"); }

    if (Check[0]->isChecked()) 
     { X->RemoveOption(Xorg::InputDevice, SecNum, "Buttons"); }
    else
     { X->WriteOption(Xorg::InputDevice, SecNum, "Buttons", Num.setNum(SpinBox[0]->value(), 10)); }

    if (Check[1]->isChecked()) 
     { X->RemoveOption(Xorg::InputDevice, SecNum, "SampleRate"); }
    else
     { X->WriteOption(Xorg::InputDevice, SecNum, "SampleRate", Num.setNum(SpinBox[1]->value(), 10)); }

    if (Check[2]->isChecked()) 
     { X->RemoveOption(Xorg::InputDevice, SecNum, "Resolution"); }
    else
     { X->WriteOption(Xorg::InputDevice, SecNum, "Resolution", Num.setNum(SpinBox[2]->value(), 10)); }



    if (Check[3]->isChecked())
     { X->WriteOption(Xorg::InputDevice, SecNum, "ChordMiddle", BOOL_TRUE); }
    else
     { X->RemoveOption(Xorg::InputDevice, SecNum, "ChordMiddle"); }

    if (Check[4]->isChecked())
     { X->WriteOption(Xorg::InputDevice, SecNum, "ClearDTR", BOOL_TRUE); }
    else
     { X->RemoveOption(Xorg::InputDevice, SecNum, "ClearDTR"); }

    if (Check[5]->isChecked())
     { X->WriteOption(Xorg::InputDevice, SecNum, "ClearRTS", BOOL_TRUE); }
    else
     { X->RemoveOption(Xorg::InputDevice, SecNum, "ClearRTS"); }

    if (Check[6]->isChecked())
     { X->WriteOption(Xorg::InputDevice, SecNum, "InvX", BOOL_TRUE); }
    else
     { X->RemoveOption(Xorg::InputDevice, SecNum, "InvX"); }

    if (Check[7]->isChecked())
     { X->WriteOption(Xorg::InputDevice, SecNum, "InvY", BOOL_TRUE); }
    else
     { X->RemoveOption(Xorg::InputDevice, SecNum, "InvY"); }

    if (Check[8]->isChecked())
     { X->WriteOption(Xorg::InputDevice, SecNum, "FlipXY", BOOL_TRUE); }
    else
     { X->RemoveOption(Xorg::InputDevice, SecNum, "FlipXY"); }


    if (Group[1]->isChecked())
     { X->WriteOption(Xorg::InputDevice, SecNum, "AngleOffset", Num.setNum(SpinBox[3]->value(), 10)); }
    else
     { X->RemoveOption(Xorg::InputDevice, SecNum, "AngleOffset"); }

    if (Group[2]->isChecked())
     { X->WriteOption(Xorg::InputDevice, SecNum, "Emulate3Buttons", BOOL_TRUE);
       X->WriteOption(Xorg::InputDevice, SecNum, "Emulate3Timeout", Num.setNum(SpinBox[4]->value(), 10)); }
    else
     { X->RemoveOption(Xorg::InputDevice, SecNum, "Emulate3Buttons");
       X->RemoveOption(Xorg::InputDevice, SecNum, "Emulate3Timeout"); }



    if (Group[3]->isChecked())
     { X->WriteOption(Xorg::InputDevice, SecNum, "EmulateWheel", BOOL_TRUE);
       X->WriteOption(Xorg::InputDevice, SecNum, "EmulateWheelButton", Num.setNum(SpinBox[5]->value(), 10));
       X->WriteOption(Xorg::InputDevice, SecNum, "EmulateWheelInertia", Num.setNum(SpinBox[6]->value(), 10));
       X->WriteOption(Xorg::InputDevice, SecNum, "EmulateWheelTimeout", Num.setNum(SpinBox[7]->value(), 10)); }
    else
     { X->RemoveOption(Xorg::InputDevice, SecNum, "EmulateWheel");
       X->RemoveOption(Xorg::InputDevice, SecNum, "EmulateWheelButton");
       X->RemoveOption(Xorg::InputDevice, SecNum, "EmulateWheelInertia");
       X->RemoveOption(Xorg::InputDevice, SecNum, "EmulateWheelTimeout"); }










OptionsDialog->close();
}

//WACOM Driver

void PropertiesDialog :: SetOptions_WACOM(QWidget *Parent, Xorg *Xorg, int SectionNumber)
{
CreateWindow(800, 450, "wacom", "tablet", Parent);

SecNum = SectionNumber;
X = Xorg;


InformationLabel->setText(Locale(65).append("<br><br>" + Locale(25) + " <b>" + X->GetValue(Xorg::InputDevice, SectionNumber, "Identifier", 1) + "</b>"));

   Group[0] = new QGroupBox(OptionsDialog);
    Group[0]->setGeometry(10, 150, 280, 240);
    Group[0]->setTitle(Locale(3));

   Label[0] = new QLabel(Group[0]);
    Label[0]->setGeometry(10, 20, 190, 25);
    Label[0]->setText(Locale(66));

   Combo[0] = new KComboBox(Group[0]);
    Combo[0]->setGeometry(110, 20, 160, 25);

    Combo[0]->insertItem(Locale(67));
    Combo[0]->insertItem(Locale(68));
    Combo[0]->insertItem(Locale(69));

   Label[1] = new QLabel(Group[0]);
    Label[1]->setText(Locale(8));
    Label[1]->setGeometry(10, 50, 100, 25);

   Combo[1] = new KComboBox(Group[0]);
    Combo[1]->setGeometry(110, 50, 160, 25);

    Combo[1]->insertItem("38400");
    Combo[1]->insertItem("19200");
    Combo[1]->insertItem("9600 ("  + Locale(70) + ")");

   Label[2] = new QLabel(Group[0]);
    Label[2]->setText(Locale(71));
    Label[2]->setGeometry(10, 80, 100, 25);

   Combo[2] = new KComboBox(Group[0]);
    Combo[2]->setGeometry(110, 80, 160, 25);

    Combo[2]->insertItem(Locale(72));
    Combo[2]->insertItem(Locale(73));

   Check[0] = new QCheckBox(Group[0]);
    Check[0]->setGeometry(10, 110, 260, 25);
    Check[0]->setText(Locale(74));

   Check[1] = new QCheckBox(Group[0]);
    Check[1]->setGeometry(10, 140, 260, 25);
    Check[1]->setText(Locale(75));

   Check[2] = new QCheckBox(Group[0]);
    Check[2]->setGeometry(10, 170, 260, 25);
    Check[2]->setText(Locale(76));

   Check[3] = new QCheckBox(Group[0]);
    Check[3]->setGeometry(10, 200, 260, 25);
    Check[3]->setText(Locale(77));

   Group[1] = new QGroupBox(OptionsDialog);
    Group[1]->setGeometry(300, 150, 240, 240);
    Group[1]->setTitle(Locale(78));

   Check[4] = new QCheckBox(Group[1]);
    Check[4]->setGeometry(10, 20, 150, 25);
    Check[4]->setText(Locale(79));

   SpinBox[0] = new KIntSpinBox(Group[1]);
    SpinBox[0]->setGeometry(160, 20, 70, 25);

   Check[5] = new QCheckBox(Group[1]);
    Check[5]->setGeometry(10, 50, 150, 25);
    Check[5]->setText(Locale(80));

   SpinBox[1] = new KIntSpinBox(Group[1]);
    SpinBox[1]->setGeometry(160, 50, 70, 25);

   Check[6] = new QCheckBox(Group[1]);
    Check[6]->setGeometry(10, 80, 150, 25);
    Check[6]->setText(Locale(81));

   SpinBox[2] = new KIntSpinBox(Group[1]);
    SpinBox[2]->setGeometry(160, 80, 70, 25);

   Check[7] = new QCheckBox(Group[1]);
    Check[7]->setGeometry(10, 110, 150, 25);
    Check[7]->setText(Locale(82));

   SpinBox[3] = new KIntSpinBox(Group[1]);
    SpinBox[3]->setGeometry(160, 110, 70, 25);

   Label[7] = new QLabel(Group[1]);
    Label[7]->setGeometry(10, 170, 150, 25);
    Label[7]->setText(Locale(83));

   LineEdit[0] = new KLineEdit(Group[1]);
    LineEdit[0]->setGeometry(10, 200, 220, 25);

   Group[2] = new QGroupBox(OptionsDialog);
    Group[2]->setGeometry(550, 150, 240, 240);
    Group[2]->setTitle(Locale(84));
    Group[2]->setCheckable(TRUE);

   Label[9] = new QLabel(Group[2]);
    Label[9]->setGeometry(10, 20, 150, 25);
    Label[9]->setText(Locale(85));

   SpinBox[4] = new KIntSpinBox(Group[2]);
    SpinBox[4]->setGeometry(160, 20, 70, 25);

   Label[10] = new QLabel(Group[2]);
    Label[10]->setGeometry(10, 50, 150, 25);
    Label[10]->setText(Locale(86));

   SpinBox[5] = new KIntSpinBox(Group[2]);
    SpinBox[5]->setGeometry(160, 50, 70, 25);

   Label[11] = new QLabel(Group[2]);
    Label[11]->setGeometry(10, 80, 150, 25);
    Label[11]->setText(Locale(87));

   SpinBox[6] = new KIntSpinBox(Group[2]);
    SpinBox[6]->setGeometry(160, 80, 70, 25);

   Label[12] = new QLabel(Group[2]);
    Label[12]->setGeometry(10, 110, 150, 25);
    Label[12]->setText(Locale(88));

   SpinBox[7] = new KIntSpinBox(Group[2]);
    SpinBox[7]->setGeometry(160, 110, 70, 25);


///Initializing


if (X->GetOption(Xorg::InputDevice, SecNum, "Type") == "stylus")       { Combo[0]->setCurrentItem(0); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Type") == "eraser")       { Combo[0]->setCurrentItem(1); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Type") == "cursor")       { Combo[0]->setCurrentItem(2); }

if (X->GetOption(Xorg::InputDevice, SecNum, "BaudRate") == "38400")    { Combo[1]->setCurrentItem(0); }
if (X->GetOption(Xorg::InputDevice, SecNum, "BaudRate") == "19200")    { Combo[1]->setCurrentItem(1); }
if (X->GetOption(Xorg::InputDevice, SecNum, "BaudRate") == "9600")     { Combo[1]->setCurrentItem(2); }
if (X->GetOption(Xorg::InputDevice, SecNum, "BaudRate") == "")         { Combo[1]->setCurrentItem(2); }

if (X->GetOption(Xorg::InputDevice, SecNum, "Mode") == "Relative")     { Combo[2]->setCurrentItem(0); }
if (X->GetOption(Xorg::InputDevice, SecNum, "Mode") == "Absolute")     { Combo[2]->setCurrentItem(1); }

if (X->GetBoolOption(Xorg::InputDevice, SecNum, "USB"))             { Check[0]->setChecked(TRUE); }
if (!X->GetBoolOption(Xorg::InputDevice, SecNum, "USB"))            { Check[0]->setChecked(FALSE); }

if (X->GetBoolOption(Xorg::InputDevice, SecNum, "Tilt"))            { Check[1]->setChecked(TRUE); }
if (!X->GetBoolOption(Xorg::InputDevice, SecNum, "Tilt"))           { Check[1]->setChecked(FALSE); }

if (X->GetBoolOption(Xorg::InputDevice, SecNum, "AlwaysCore"))      { Check[2]->setChecked(TRUE); }
if (!X->GetBoolOption(Xorg::InputDevice, SecNum, "AlwaysCore"))     { Check[2]->setChecked(FALSE); }

if (X->GetBoolOption(Xorg::InputDevice, SecNum, "KeepShape"))       { Check[3]->setChecked(TRUE); }
if (!X->GetBoolOption(Xorg::InputDevice, SecNum, "KeepShape"))      { Check[3]->setChecked(FALSE); }

bool ok;
int Num = 0;

 if (X->GetOption(Xorg::InputDevice, SecNum, "HistorySize") != "")
  {
   Num = X->GetOption(Xorg::InputDevice, SecNum, "HistorySize").toInt(&ok, 10);
    SpinBox[0]->setEnabled(TRUE);
    Check[4]->setChecked(TRUE);
    SpinBox[0]->setValue(Num);
  }
 else
  {
   Check[4]->setChecked(FALSE);
   SpinBox[0]->setEnabled(FALSE);
  }


 if (X->GetOption(Xorg::InputDevice, SecNum, "Serial") != "")
  {
   Num = X->GetOption(Xorg::InputDevice, SecNum, "Serial").toInt(&ok, 10);
    SpinBox[1]->setEnabled(TRUE);
    Check[5]->setChecked(TRUE);
    SpinBox[1]->setValue(Num);
  }
 else
  {
   Check[5]->setChecked(FALSE);
   SpinBox[1]->setEnabled(FALSE);
  }


 if (X->GetOption(Xorg::InputDevice, SecNum, "Threshold") != "")
  {
  Num = X->GetOption(Xorg::InputDevice, SecNum, "Threshold").toInt(&ok, 10);
   SpinBox[2]->setEnabled(TRUE);
   Check[6]->setChecked(TRUE);
   SpinBox[2]->setValue(Num);
  }
 else
  {
   Check[6]->setChecked(FALSE);
   SpinBox[2]->setEnabled(FALSE);
  }


Group[2]->setChecked(FALSE);


 if (X->GetOption(Xorg::InputDevice, SecNum, "TopX") != "")
  {
   Num = X->GetOption(Xorg::InputDevice, SecNum, "TopX").toInt(&ok, 10);
   SpinBox[4]->setValue(Num);
   Group[2]->setChecked(TRUE);
  }

 if (X->GetOption(Xorg::InputDevice, SecNum, "TopY") != "")
  {
   Num = X->GetOption(Xorg::InputDevice, SecNum, "TopY").toInt(&ok, 10);
   SpinBox[5]->setValue(Num);
   Group[2]->setChecked(TRUE);
  }

 if (X->GetOption(Xorg::InputDevice, SecNum, "BottomX") != "")
  {
   Num = X->GetOption(Xorg::InputDevice, SecNum, "BottomX").toInt(&ok, 10);
   SpinBox[6]->setValue(Num);
   Group[2]->setChecked(TRUE);
  }

 if (X->GetOption(Xorg::InputDevice, SecNum, "BottomY") != "")
  {
   Num = X->GetOption(Xorg::InputDevice, SecNum, "BottomY").toInt(&ok, 10);
   SpinBox[7]->setValue(Num);
   Group[2]->setChecked(TRUE);
  }


 if (X->GetOption(Xorg::InputDevice, SecNum, "DebugLevel") != "")
  {
  Num = X->GetOption(Xorg::InputDevice, SecNum, "DebugLevel").toInt(&ok, 10);
   SpinBox[3]->setEnabled(TRUE);
   Check[7]->setChecked(TRUE);
   SpinBox[3]->setValue(Num);
  }
 else
  {
   Check[7]->setChecked(FALSE);
   SpinBox[3]->setEnabled(FALSE);
  }



 if (X->GetOption(Xorg::InputDevice, SecNum, "DeviceName") != "")
  {
   LineEdit[0]->setText(X->GetOption(Xorg::InputDevice, SecNum, "DeviceName"));
  }


   connect(OKButton, SIGNAL(clicked()), this, SLOT(WACOM_SaveAndExit()));
   connect (Check[4], SIGNAL(toggled(bool)), this, SLOT(WACOM_HistoryCheck(bool)));
   connect (Check[5], SIGNAL(toggled(bool)), this, SLOT(WACOM_SerialCheck(bool)));
   connect (Check[6], SIGNAL(toggled(bool)), this, SLOT(WACOM_ThresholdCheck(bool)));
   connect (Check[7], SIGNAL(toggled(bool)), this, SLOT(WACOM_DebugCheck(bool)));

OptionsDialog->exec();
}

void PropertiesDialog :: WACOM_HistoryCheck(bool Checked)
{
if (Checked) { SpinBox[0]->setEnabled(TRUE); } else { SpinBox[0]->setEnabled(FALSE); }
}

void PropertiesDialog :: WACOM_SerialCheck(bool Checked)
{
if (Checked) { SpinBox[1]->setEnabled(TRUE); } else { SpinBox[1]->setEnabled(FALSE); }
}

void PropertiesDialog :: WACOM_ThresholdCheck(bool Checked)
{
if (Checked) { SpinBox[2]->setEnabled(TRUE); } else { SpinBox[2]->setEnabled(FALSE); }
}

void PropertiesDialog :: WACOM_DebugCheck(bool Checked)
{
if (Checked) { SpinBox[3]->setEnabled(TRUE); } else { SpinBox[3]->setEnabled(FALSE); }
}

void PropertiesDialog :: WACOM_SaveAndExit()
{

QString Num;

if (Combo[0]->currentItem() == 0) { X->WriteOption(Xorg::InputDevice, SecNum, "Type", "stylus"); }
if (Combo[0]->currentItem() == 1) { X->WriteOption(Xorg::InputDevice, SecNum, "Type", "eraser"); }
if (Combo[0]->currentItem() == 2) { X->WriteOption(Xorg::InputDevice, SecNum, "Type", "cursor"); }

if (Combo[1]->currentItem() == 0) { X->WriteOption(Xorg::InputDevice, SecNum, "BaudRate", "38400"); }
if (Combo[1]->currentItem() == 1) { X->WriteOption(Xorg::InputDevice, SecNum, "BaudRate", "19200"); }
if (Combo[1]->currentItem() == 2) { X->WriteOption(Xorg::InputDevice, SecNum, "BaudRate", "9600"); }

if (Combo[2]->currentItem() == 0) { X->WriteOption(Xorg::InputDevice, SecNum, "Mode", "Relative"); }
if (Combo[2]->currentItem() == 1) { X->WriteOption(Xorg::InputDevice, SecNum, "Mode", "Absolute"); }

if (Check[0]->isChecked()) { X->WriteOption(Xorg::InputDevice, SecNum, "USB", BOOL_TRUE); }
if (!Check[0]->isChecked()) { X->RemoveOption(Xorg::InputDevice, SecNum, "USB"); }

if (Check[1]->isChecked()) { X->WriteOption(Xorg::InputDevice, SecNum, "Tilt", BOOL_TRUE); }
if (!Check[1]->isChecked()) { X->RemoveOption(Xorg::InputDevice, SecNum, "Tilt"); }

if (Check[2]->isChecked()) { X->WriteOption(Xorg::InputDevice, SecNum, "AlwaysCore", BOOL_TRUE); }
if (!Check[2]->isChecked()) { X->RemoveOption(Xorg::InputDevice, SecNum, "AlwaysCore"); }

if (Check[3]->isChecked()) { X->WriteOption(Xorg::InputDevice, SecNum, "KeepShape", BOOL_TRUE); }
if (!Check[3]->isChecked()) { X->RemoveOption(Xorg::InputDevice, SecNum, "KeepShape"); }

if (Check[4]->isChecked()) { X->WriteOption(Xorg::InputDevice, SecNum, "HistorySize", Num.setNum(SpinBox[0]->value())); }
if (!Check[4]->isChecked()) { X->RemoveOption(Xorg::InputDevice, SecNum, "HistorySize"); }

if (Check[5]->isChecked()) { X->WriteOption(Xorg::InputDevice, SecNum, "Serial", Num.setNum(SpinBox[1]->value())); }
if (!Check[5]->isChecked()) { X->RemoveOption(Xorg::InputDevice, SecNum, "Serial"); }

if (Check[6]->isChecked()) { X->WriteOption(Xorg::InputDevice, SecNum, "Threshold", Num.setNum(SpinBox[2]->value())); }
if (!Check[6]->isChecked()) { X->RemoveOption(Xorg::InputDevice, SecNum, "Threshold"); }

if (Check[7]->isChecked()) { X->WriteOption(Xorg::InputDevice, SecNum, "DebugLevel", Num.setNum(SpinBox[3]->value())); }
if (!Check[7]->isChecked()) { X->RemoveOption(Xorg::InputDevice, SecNum, "DebugLevel"); }

X->WriteOption(Xorg::InputDevice, SecNum, "DeviceName", LineEdit[0]->text());

if (Group[2]->isChecked()) 
  {
   X->WriteOption(Xorg::InputDevice, SecNum, "TopX", Num.setNum(SpinBox[4]->value()));
   X->WriteOption(Xorg::InputDevice, SecNum, "TopY", Num.setNum(SpinBox[5]->value()));
   X->WriteOption(Xorg::InputDevice, SecNum, "BottomX", Num.setNum(SpinBox[6]->value()));
   X->WriteOption(Xorg::InputDevice, SecNum, "BottomY", Num.setNum(SpinBox[7]->value()));
  }
 else
  {
   X->RemoveOption(Xorg::InputDevice, SecNum, "TopX");
   X->RemoveOption(Xorg::InputDevice, SecNum, "TopY");
   X->RemoveOption(Xorg::InputDevice, SecNum, "BottomX");
   X->RemoveOption(Xorg::InputDevice, SecNum, "BottomY");
  }

OptionsDialog->close();


}








///Video Drivers

//NV Driver

void PropertiesDialog :: SetOptions_NV(QWidget *Parent, Xorg *Xorg, int SectionNumber)
{
CreateWindow(600, 400, "nv", "kcmpci", Parent);

SecNum = SectionNumber;
X = Xorg;

InformationLabel->setText(Locale(44).append("<br><br>" + Locale(25) + " <b>" + X->GetValue(Xorg::Device, SectionNumber, "Identifier", 1) + "</b>"));

Group[0] = new QGroupBox(OptionsDialog);
   Group[0]->setGeometry(10, 150, 300, 180);
   Group[0]->setTitle(Locale(3));

Check[0] = new QCheckBox(Group[0]);
   Check[0]->setGeometry(10, 20, 210, 25);
   Check[0]->setText(Locale(45));

SpinBox[0] = new KIntSpinBox(Group[0]);
   SpinBox[0]->setGeometry(230, 20, 60, 25);
   SpinBox[0]->setMinValue(0);
   SpinBox[0]->setMaxValue(1);

Check[1] = new QCheckBox(Group[0]);
   Check[1]->setGeometry(10, 50, 250, 25);
   Check[1]->setText(Locale(46));

Check[2] = new QCheckBox(Group[0]);
   Check[2]->setGeometry(10, 80, 250, 25);
   Check[2]->setText(Locale(47));

Check[3] = new QCheckBox(Group[0]);
   Check[3]->setGeometry(10, 110, 250, 25);
   Check[3]->setText(Locale(48));

Check[4] = new QCheckBox(Group[0]);
   Check[4]->setGeometry(10, 140, 250, 25);
   Check[4]->setText(Locale(49));

Group[1] = new QGroupBox(OptionsDialog);
   Group[1]->setGeometry(320, 150, 270, 80);
   Group[1]->setTitle(Locale(50));
   Group[1]->setCheckable(TRUE);


Radio[0] = new QRadioButton(Group[1]);
   Radio[0]->setGeometry(10, 20, 250, 25);
   Radio[0]->setText(Locale(51));
   Radio[0]->setChecked(TRUE);

Radio[1] = new QRadioButton(Group[1]);
   Radio[1]->setGeometry(10, 50, 250, 25);
   Radio[1]->setText(Locale(52));

Group[2] = new QGroupBox(OptionsDialog);
   Group[2]->setGeometry(320, 240, 270, 90);
   Group[2]->setTitle(Locale(53));
   Group[2]->setCheckable(TRUE);

Check[5] = new QCheckBox(Group[2]);
   Check[5]->setGeometry(10, 25, 250, 25);
   Check[5] ->setText(Locale(54));

Check[6] = new QCheckBox(Group[2]);
   Check[6]->setGeometry(10, 55, 250, 25);
   Check[6]->setText(Locale(55));


//Connecting
connect (Check[0], SIGNAL(toggled(bool)), this, SLOT(NV_CRTCCheck(bool)));
connect (Radio[0], SIGNAL(clicked()), this, SLOT(NV_Radio0Clicked()));
connect (Radio[1], SIGNAL(clicked()), this, SLOT(NV_Radio1Clicked()));
connect (OKButton, SIGNAL(clicked()), this, SLOT(NV_SaveAndExit()));
///Initializing

  if (X->GetOption(Xorg::Device, SecNum, "CrtcNumber") == "") 
   { Check[0]->setChecked(FALSE); SpinBox[0]->setEnabled(FALSE); }
  else
   {
    Check[0]->setChecked(TRUE);
    bool ok;
    QString CRTC = X->GetOption(Xorg::Device, SecNum, "CrtcNumber");
    SpinBox[0]->setValue(CRTC.toInt(&ok, 10));
   }



   if (X->GetBoolOption(Xorg::Device, SecNum, "HWCursor"))
    { Check[1]->setChecked(TRUE); }
   else
    { Check[1]->setChecked(FALSE); }


   if (X->GetBoolOption(Xorg::Device, SecNum, "NoAccel"))
    { Check[2]->setChecked(FALSE); }
   else
    { Check[2]->setChecked(TRUE); }


   if (X->GetBoolOption(Xorg::Device, SecNum, "UseFBDev"))
    { Check[3]->setChecked(TRUE); }
   else
    { Check[3]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "ShadowFB"))
    { Check[4]->setChecked(TRUE); }
   else
    { Check[4]->setChecked(FALSE); }



   if (X->GetOption(Xorg::Device, SecNum, "Rotate") != "")
    {
     Group[1]->setChecked(TRUE);
     if (X->GetOption(Xorg::Device, SecNum, "Rotate") == "CW")   { Radio[0]->setChecked(TRUE); Radio[1]->setChecked(FALSE); }
     if (X->GetOption(Xorg::Device, SecNum, "Rotate") == "CCW")  { Radio[1]->setChecked(TRUE); Radio[0]->setChecked(FALSE); }
    }
   else
    { Group[1]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "FlatPanel"))
    {
     Group[2]->setChecked(TRUE);
     if (X->GetBoolOption(Xorg::Device, SecNum, "FPDither")) { Check[5]->setChecked(TRUE); }
     if (X->GetBoolOption(Xorg::Device, SecNum, "FPScale"))  { Check[6]->setChecked(TRUE); }
    }
   else
    {
     Group[2]->setChecked(FALSE);
    }





//Tooltips



QToolTip::add(Check[0], "<b>" + Locale(45).remove(":") + "</b><br><br>" + Locale(56));
QToolTip::add(SpinBox[0], "<b>" + Locale(45).remove(":") + "</b><br><br>" + Locale(56));
QToolTip::add(Check[1], "<b>" + Locale(46).remove(":") + "</b><br><br>" + Locale(57));
QToolTip::add(Check[2], "<b>" + Locale(47).remove(":") + "</b><br><br>" + Locale(58));
QToolTip::add(Check[3], "<b>" + Locale(48).remove(":") + "</b><br><br>" + Locale(59));
QToolTip::add(Check[4], "<b>" + Locale(49).remove(":") + "</b><br><br>" + Locale(60));
QToolTip::add(Group[1], "<b>" + Locale(50).remove(":") + "</b><br><br>" + Locale(61));
QToolTip::add(Group[2], "<b>" + Locale(53).remove(":") + "</b><br><br>" + Locale(62));
QToolTip::add(Check[5], "<b>" + Locale(55).remove(":") + "</b><br><br>" + Locale(63));
QToolTip::add(Check[6], "<b>" + Locale(56).remove(":") + "</b><br><br>" + Locale(64));
OptionsDialog->exec();
}

void PropertiesDialog :: NV_CRTCCheck(bool Checked)
{
  if (Checked) 
   { SpinBox[0]->setEnabled(TRUE); }
  else
   { SpinBox[0]->setEnabled(FALSE); }
}

void PropertiesDialog :: NV_Radio0Clicked()
{
Radio[1]->setChecked(FALSE);
}

void PropertiesDialog :: NV_Radio1Clicked()
{
Radio[0]->setChecked(FALSE);
}

void PropertiesDialog :: NV_SaveAndExit()
{
  if (Check[0]->isChecked())
   {
    QString Num;
    X->WriteOption(Xorg::Device, SecNum, "CrtcNumber", Num.setNum(SpinBox[0]->value(), 10));
   }
  else
   {
    X->RemoveOption(Xorg::Device, SecNum, "CrtcNumber");
   }

  if (Check[1]->isChecked())
   { X->WriteOption(Xorg::Device, SecNum, "HWCursor", BOOL_TRUE); }
  else
   { X->RemoveOption(Xorg::Device, SecNum, "HWCursor"); }

  if (Check[2]->isChecked())
   { X->WriteOption(Xorg::Device, SecNum, "NoAccel", BOOL_FALSE); }
  else
   { X->WriteOption(Xorg::Device, SecNum, "NoAccel", BOOL_TRUE); }

  if (Check[3]->isChecked())
   { X->WriteOption(Xorg::Device, SecNum, "UseFBDev", BOOL_TRUE); }
  else
   { X->RemoveOption(Xorg::Device, SecNum, "UseFBDev"); }

  if (Check[4]->isChecked())
   { X->WriteOption(Xorg::Device, SecNum, "ShadowFB", BOOL_TRUE); }
  else
   { X->RemoveOption(Xorg::Device, SecNum, "ShadowFB"); }


  if (Group[1]->isChecked())
   {
    if (Radio[0]->isChecked()) 
     { X->WriteOption(Xorg::Device, SecNum, "Rotate", "CW"); }
    else
     { X->WriteOption(Xorg::Device, SecNum, "Rotate", "CCW"); }
   }
  else
   {
    X->RemoveOption(Xorg::Device, SecNum, "Rotate");
   }


  if (Group[2]->isChecked())
   {
    X->WriteOption(Xorg::Device, SecNum, "FlatPanel", BOOL_TRUE);
     if (Check[5]->isChecked())
      { X->WriteOption(Xorg::Device, SecNum, "FPDither", BOOL_TRUE); }
     else
      { X->WriteOption(Xorg::Device, SecNum, "FPDither", BOOL_FALSE); }

     if (Check[6]->isChecked())
      { X->WriteOption(Xorg::Device, SecNum, "FPScale", BOOL_TRUE); }
     else
      { X->WriteOption(Xorg::Device, SecNum, "FPScale", BOOL_FALSE); }
   }
  else
   {
    X->RemoveOption(Xorg::Device, SecNum, "FlatPanel");
    X->RemoveOption(Xorg::Device, SecNum, "FPDither");
    X->RemoveOption(Xorg::Device, SecNum, "FPScale");
   }






   if (X->GetBoolOption(Xorg::Device, SecNum, "FlatPanel"))
    {
     Group[2]->setChecked(TRUE);
     if (X->GetBoolOption(Xorg::Device, SecNum, "FPDither")) { Check[5]->setChecked(TRUE); }
     if (X->GetBoolOption(Xorg::Device, SecNum, "FPScale"))  { Check[6]->setChecked(TRUE); }
    }
   else
    {
     Group[2]->setChecked(FALSE);
    }







OptionsDialog->close();

}


//NVIDIA Driver

void PropertiesDialog :: SetOptions_NVIDIA(QWidget *Parent, Xorg *Xorg, int SectionNumber)
{
CreateWindow(800, 510, "nvidia", "kcmpci", Parent);
SecNum = SectionNumber;
X = Xorg;
bool CheckOK;

KIconLoader *Icons = new KIconLoader();

InformationLabel->setText(Locale(44).append("<br><br>" + Locale(25) + " <b>" + X->GetValue(Xorg::Device, SectionNumber, "Identifier", 1) + "</b>"));

KTabWidget *Tab = new KTabWidget (OptionsDialog);
Tab->setGeometry(10, 160, 780, 290);

QWidget *GeneralTab = new QWidget(Tab);
QWidget *TwinViewTab = new QWidget(Tab);
QWidget *CursorTVDFPTab = new QWidget(Tab);
QWidget *OtherTab = new QWidget(Tab);


Tab->insertTab(GeneralTab, Icons->loadIcon("gear", KIcon::Desktop, KIcon::SizeSmall), Locale(89));
Tab->insertTab(TwinViewTab, Icons->loadIcon("tv", KIcon::Desktop, KIcon::SizeSmall), Locale(90));
Tab->insertTab(CursorTVDFPTab, Icons->loadIcon("mouse", KIcon::Desktop, KIcon::SizeSmall), Locale(91));
Tab->insertTab(OtherTab, Icons->loadIcon("system", KIcon::Desktop, KIcon::SizeSmall), Locale(92));


//General tab interface

for (int Num = 0; Num <= 11; Num++)                  ///Best way to make interface:)
{
Check[Num] = new QCheckBox(GeneralTab);
   Check[Num]->setGeometry(10, Num * 20 + 5, 410, 25);
   Check[Num]->setText(Locale(93 + Num));
//    cout << "Locale: " << Locale(93 + Num) << ", number: " << Num << endl;
}

Group[0] = new QGroupBox(GeneralTab);
Group[0]->setGeometry(390, 10, 370, 70);
Group[0]->setTitle(Locale(105));
Group[0]->setCheckable(TRUE);
Group[0]->setChecked(FALSE);

Combo[0] = new KComboBox(Group[0]);
Combo[0]->setGeometry(10, 30, 350, 25);

for (int N = 108; N <= 111; N++)
{
Combo[0]->insertItem(Locale(N));
}



Group[1] = new QGroupBox(GeneralTab);
Group[1]->setGeometry(390, 90, 370, 70);
Group[1]->setTitle(Locale(106));
Group[1]->setCheckable(TRUE);
Group[1]->setChecked(FALSE);

Combo[1] = new KComboBox(Group[1]);
Combo[1]->setGeometry(10, 30, 350, 25);

for (int N = 112; N <= 115; N++)
{
Combo[1]->insertItem(Locale(N));
}


Group[2] = new QGroupBox(GeneralTab);
Group[2]->setGeometry(390, 170, 370, 70);
Group[2]->setTitle(Locale(107));
Group[2]->setCheckable(TRUE);
Group[2]->setChecked(FALSE);

DVSlider = new QSlider(Group[2]);
DVSlider->setGeometry(10, 35, 290, 25);
DVSlider->setOrientation(Qt::Horizontal);
DVSlider->setMinValue(0);
DVSlider->setMaxValue(4);

LCD[0] = new QLCDNumber(Group[2]);
LCD[0]->setGeometry(310, 30, 55, 25);
LCD[0]->setSegmentStyle(QLCDNumber::Flat);






//TwinView tab interface

Group[3] = new QGroupBox(TwinViewTab);
Group[3]->setGeometry(10, 10, 755, 230);
Group[3]->setTitle(Locale(116));
Group[3]->setCheckable(TRUE);
Group[3]->setChecked(FALSE);

QLabel *TwinVLabel = new QLabel(Group[3]);
TwinVLabel->setGeometry(10, 30, 230, 25);
TwinVLabel->setText(Locale(117));

Combo[2] = new KComboBox(Group[3]);
Combo[2]->setGeometry(240, 30, 160, 25);

for (int N = 118; N <= 122; N++)
{
Combo[2]->insertItem(Locale(N));
}


QLabel *HSyncLabel = new QLabel(Group[3]);
HSyncLabel->setGeometry(10, 60, 230, 25);
HSyncLabel->setText(Locale(123));

LineEdit[0] = new KLineEdit(Group[3]);
LineEdit[0]->setGeometry(240, 60, 60, 25);

QLabel *Slash1 = new QLabel(Group[3]);
Slash1->setGeometry(310, 60, 20, 25);
Slash1->setAlignment(Qt::AlignCenter);
Slash1->setText("/");

LineEdit[1] = new KLineEdit(Group[3]);
LineEdit[1]->setGeometry(340, 60, 60, 25);




QLabel *VRefLabel = new QLabel(Group[3]);
VRefLabel->setGeometry(10, 90, 230, 25);
VRefLabel->setText(Locale(124));

LineEdit[2] = new KLineEdit(Group[3]);
LineEdit[2]->setGeometry(240, 90, 60, 25);

QLabel *Slash2 = new QLabel(Group[3]);
Slash2->setGeometry(310, 90, 20, 25);
Slash2->setAlignment(Qt::AlignCenter);
Slash2->setText("/");

LineEdit[3] = new KLineEdit(Group[3]);
LineEdit[3]->setGeometry(340, 90, 60, 25);


QLabel *FirstMonitor = new QLabel(Group[3]);
FirstMonitor->setGeometry(10, 120, 230, 25);
FirstMonitor->setText(Locale(125));

QLabel *SecondMonitor = new QLabel(Group[3]);
SecondMonitor->setGeometry(10, 150, 230, 25);
SecondMonitor->setText(Locale(126));


Combo[3] = new KComboBox(Group[3]);
Combo[3]->setGeometry(240, 120, 160, 25);

Combo[4] = new KComboBox(Group[3]);
Combo[4]->setGeometry(240, 150, 160, 25);

for (int N = 127; N < 130; N++)
{
Combo[3]->insertItem(Locale(N));
Combo[4]->insertItem(Locale(N));
}

QLabel *Note = new QLabel(Group[3]);
Note->setGeometry(10, 200, 700, 25);
Note->setText(Locale(130));

Group[4] = new QGroupBox(Group[3]);
Group[4]->setGeometry(420, 20, 320, 175);
Group[4]->setTitle(Locale(133));

ListBox[0] = new KListBox(Group[4]);
ListBox[0]->setGeometry(10, 30, 120, 100);

ListBox[1] = new KListBox(Group[4]);
ListBox[1]->setGeometry(190, 30, 120, 100);

Combo[5] = new KComboBox(Group[4]);
Combo[5]->setGeometry(10, 140, 120, 25);

Combo[6] = new KComboBox(Group[4]);
Combo[6]->setGeometry(190, 140, 120, 25);

Button[2] = new KPushButton(Group[4]);
Button[2]->setGeometry(142, 30, 32, 32);

Button[3]= new KPushButton(Group[4]);
Button[3]->setGeometry(142, 98, 32, 32);

Button[2]->setPixmap(Icons->loadIcon("add", KIcon::Desktop, KIcon::SizeSmall));
Button[3]->setPixmap(Icons->loadIcon("remove", KIcon::Desktop, KIcon::SizeSmall));

Combo[5]->insertItem("1600x1200");
Combo[5]->insertItem("1280x1024");
Combo[5]->insertItem("1152x864");
Combo[5]->insertItem("1024x768");
Combo[5]->insertItem("800x600");
Combo[5]->insertItem("640x480");
Combo[5]->insertItem("640x400");
Combo[5]->insertItem("512x384");
Combo[5]->insertItem("400x300");
Combo[5]->insertItem("320x240");
Combo[5]->insertItem("320x200");

for (int N = 0; N < 11; N++)
{
Combo[6]->insertItem(Combo[5]->text(N));
}



Check[13] = new QCheckBox(CursorTVDFPTab);
Check[13]->setGeometry(10, 200, 200, 25);
Check[13]->setText(Locale(134));

Check[14] = new QCheckBox(CursorTVDFPTab);
Check[14]->setGeometry(10, 225, 200, 25);
Check[14]->setText(Locale(135));

Group[5] = new QGroupBox(CursorTVDFPTab);
Group[5]->setGeometry(10, 10, 300, 180);
Group[5]->setTitle(Locale(136));
Group[5]->setCheckable(TRUE);
Group[5]->setChecked(FALSE);
// Group[5]->hide();
QLabel *CSAlpha = new QLabel(Group[5]);
CSAlpha->setGeometry(10, 20, 280, 25);
CSAlpha->setText(Locale(137));

Slider[1] = new QSlider(Group[5]);
Slider[1]->setGeometry(10, 45, 220, 25);
Slider[1]->setOrientation(Qt::Horizontal);
Slider[1]->setMaxValue(255);

LCD[1] = new QLCDNumber(Group[5]);
LCD[1]->setGeometry(240, 45, 50, 25);
LCD[1]->setSegmentStyle(QLCDNumber::Flat);

QLabel *XOffset = new QLabel(Group[5]);
XOffset->setGeometry(10, 70, 280, 25);
XOffset->setText(Locale(138));

Slider[2] = new QSlider(Group[5]);
Slider[2]->setGeometry(10, 95, 220, 25);
Slider[2]->setOrientation(Qt::Horizontal);
Slider[2]->setMaxValue(32);

LCD[2] = new QLCDNumber(Group[5]);
LCD[2]->setGeometry(240, 95, 50, 25);
LCD[2]->setSegmentStyle(QLCDNumber::Flat);

QLabel *YOffset = new QLabel(Group[5]);
YOffset->setGeometry(10, 120, 280, 25);
YOffset->setText(Locale(139));

Slider[3] = new QSlider(Group[5]);
Slider[3]->setGeometry(10, 145, 220, 25);
Slider[3]->setOrientation(Qt::Horizontal);
Slider[3]->setMaxValue(32);

LCD[3] = new QLCDNumber(Group[5]);
LCD[3]->setGeometry(240, 145, 50, 25);
LCD[3]->setSegmentStyle(QLCDNumber::Flat);

Group[6] = new QGroupBox(CursorTVDFPTab);
Group[6]->setGeometry(320, 10, 445, 125);
Group[6]->setTitle(Locale(140));
Group[6]->setEnabled(FALSE);


QLabel *TVS = new QLabel(Group[6]);
TVS->setGeometry(10, 25, 200, 25);
TVS->setText(Locale(141));

Combo[7] = new KComboBox(Group[6]);
Combo[7]->setGeometry(220, 25, 215, 25);

QLabel *TVO = new QLabel(Group[6]);
TVO->setGeometry(10, 55, 200, 25);
TVO->setText(Locale(142));

Combo[8] = new KComboBox(Group[6]);
Combo[8]->setGeometry(220, 55, 215, 25);

QLabel *TVOv = new QLabel(Group[6]);
TVOv->setGeometry(10, 85, 200, 25);
TVOv->setText(Locale(143));

Overscan = new KDoubleNumInput(Group[6]);
Overscan->setGeometry(220, 85, 215, 25);
Overscan->setPrecision(1);
Overscan->setMaxValue(1);

Combo[7]->insertItem("PAL-B");
Combo[7]->insertItem("PAL-D");
Combo[7]->insertItem("PAL-G");
Combo[7]->insertItem("PAL-H");
Combo[7]->insertItem("PAL-I");
Combo[7]->insertItem("PAL-K1");
Combo[7]->insertItem("PAL-M");
Combo[7]->insertItem("PAL-N");
Combo[7]->insertItem("PAL-NC");
Combo[7]->insertItem("NTSC-J");
Combo[7]->insertItem("NTSC-M");

Combo[8]->insertItem("S-Video");
Combo[8]->insertItem("Composite");

Group[7] = new QGroupBox(CursorTVDFPTab);
Group[7]->setGeometry(320, 145, 445, 105);
Group[7]->setTitle(Locale(144));
Group[7]->setEnabled(FALSE);

QLabel *Scaling = new QLabel(Group[7]);
Scaling->setGeometry(10, 25, 190, 25);
Scaling->setText(Locale(145));

Combo[9] = new KComboBox(Group[7]);
Combo[9]->setGeometry(210, 25, 225, 25);

QLabel *Dithering = new QLabel(Group[7]);
Dithering->setGeometry(10, 65, 190, 25);
Dithering->setText(Locale(146));

Combo[10] = new KComboBox(Group[7]);
Combo[10]->setGeometry(210, 65, 225, 25);

for (int a = 147; a <= 151; a++) { Combo[9]->insertItem(Locale(a)); }
Combo[10]->insertItem(Locale(147));
for (int a = 152; a <= 153; a++) { Combo[10]->insertItem(Locale(a)); }

Check[15] = new QCheckBox(OtherTab);
Check[15]->setGeometry(10, 70, 200, 25);
Check[15]->setText(Locale(154));

Check[16] = new QCheckBox(OtherTab);
Check[16]->setGeometry(10, 95, 200, 25);
Check[16]->setText(Locale(155));

Check[17] = new QCheckBox(OtherTab);
Check[17]->setGeometry(10, 120, 200, 25);
Check[17]->setText(Locale(156));

Check[18] = new QCheckBox(OtherTab);
Check[18]->setGeometry(10, 145, 200, 25);
Check[18]->setText(Locale(157));


Group[8] = new QGroupBox(OtherTab);
Group[8]->setGeometry(250, 35, 280, 180);
Group[8]->setTitle(Locale(158));
Group[8]->setCheckable(TRUE);
Group[8]->setChecked(FALSE);


ListBox[2] = new KListBox(Group[8]);
ListBox[2]->setGeometry(10, 30, 150, 140);

Button[0] = new KPushButton(Group[8]);
Button[0]->setGeometry(170, 30, 100, 25);
Button[0]->setText(Locale(159));
Button[0]->setIconSet(Icons->loadIcon("add", KIcon::Desktop, KIcon::SizeSmall));

Button[1] = new KPushButton(Group[8]);
Button[1]->setGeometry(170, 145, 100, 25);
Button[1]->setText(Locale(160));
Button[1]->setIconSet(Icons->loadIcon("remove", KIcon::Desktop, KIcon::SizeSmall));

QLabel *IgnoreInfo = new QLabel(OtherTab);
IgnoreInfo->setGeometry (540, 45, 240, 200);
IgnoreInfo->setAlignment(Qt::AlignTop | QLabel::WordBreak);
IgnoreInfo->setText(Locale(161));




connect (DVSlider, SIGNAL(valueChanged(int)), this, SLOT(NVIDIA_DigitalVibrance()));
connect (Check[10], SIGNAL(toggled(bool)), this, SLOT(NVIDIA_EDID()));
connect (Check[11], SIGNAL(toggled(bool)), this, SLOT(NVIDIA_DisableEDID()));
connect (Slider[1], SIGNAL(valueChanged(int)), this, SLOT(NVIDIA_CursorShadowSliders()));
connect (Slider[2], SIGNAL(valueChanged(int)), this, SLOT(NVIDIA_CursorShadowSliders()));
connect (Slider[3], SIGNAL(valueChanged(int)), this, SLOT(NVIDIA_CursorShadowSliders()));
connect (Combo[3], SIGNAL(activated(int)), this, SLOT(NVIDIA_MonitorsChange()));
connect (Combo[4], SIGNAL(activated(int)), this, SLOT(NVIDIA_MonitorsChange()));
connect (Check[13], SIGNAL(toggled(bool)), this, SLOT(NVIDIA_HwCursor()));
connect (Check[14], SIGNAL(toggled(bool)), this, SLOT(NVIDIA_SwCursor()));
connect (Button[2], SIGNAL(clicked()), this, SLOT(NVIDIA_AddMetaMode()));
connect (Button[3], SIGNAL(clicked()), this, SLOT(NVIDIA_RemoveMetaMode()));
connect (ListBox[0], SIGNAL(selectionChanged()), this, SLOT(NVIDIA_MetaMode1Clicked()));
connect (ListBox[1], SIGNAL(selectionChanged()), this, SLOT(NVIDIA_MetaMode2Clicked()));
connect (Button[0], SIGNAL(clicked()), this, SLOT(NVIDIA_AddIgnoreDevice()));
connect (Button[1], SIGNAL(clicked()), this, SLOT(NVIDIA_RemoveIgnoreDevice()));
connect (OKButton, SIGNAL(clicked()), this, SLOT(NVIDIA_SaveAndExit()));




// LOADING

   if (X->GetBoolOption(Xorg::Device, SecNum, "NoLogo"))
    { Check[0]->setChecked(TRUE); }
   else
    { Check[0]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "RenderAccel"))
    { Check[1]->setChecked(TRUE); }
   else
    { Check[1]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "NoRenderExtension"))
    { Check[2]->setChecked(TRUE); }
   else
    { Check[2]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "UBB"))
    { Check[3]->setChecked(TRUE); }
   else
    { Check[3]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "WindowFlip"))
    { Check[4]->setChecked(TRUE); }
   else
    { Check[4]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "PageFlip"))
    { Check[5]->setChecked(TRUE); }
   else
    { Check[5]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "Dac8Bit"))
    { Check[6]->setChecked(TRUE); }
   else
    { Check[6]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "Overlay"))
    { Check[7]->setChecked(TRUE); }
   else
    { Check[7]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "CIOverlay"))
    { Check[8]->setChecked(TRUE); }
   else
    { Check[8]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "OverlayDefaultVisual"))
    { Check[9]->setChecked(TRUE); }
   else
    { Check[9]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "UseEdidFreqs"))
    { Check[10]->setChecked(TRUE); NVIDIA_EDID(); }
   else
    { Check[10]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "IgnoreEDID"))
    { Check[11]->setChecked(TRUE); NVIDIA_DisableEDID(); }
   else
    { Check[11]->setChecked(FALSE); }


   if (X->GetOption(Xorg::Device, SecNum, "Stereo") == "1")
    {
     Group[0]->setChecked(TRUE);
     Combo[0]->setCurrentItem(0);
    }

   if (X->GetOption(Xorg::Device, SecNum, "Stereo") == "2")
    {
     Group[0]->setChecked(TRUE);
     Combo[0]->setCurrentItem(1);
    }

   if (X->GetOption(Xorg::Device, SecNum, "Stereo") == "3")
    {
     Group[0]->setChecked(TRUE);
     Combo[0]->setCurrentItem(2);
    }

   if (X->GetOption(Xorg::Device, SecNum, "Stereo") == "4")
    {
     Group[0]->setChecked(TRUE);
     Combo[0]->setCurrentItem(3);
    }

   if (X->GetOption(Xorg::Device, SecNum, "NvAGP") == "1")
    {
     Group[1]->setChecked(TRUE);
     Combo[1]->setCurrentItem(0);
    }

   if (X->GetOption(Xorg::Device, SecNum, "NvAGP") == "2")
    {
     Group[1]->setChecked(TRUE);
     Combo[1]->setCurrentItem(1);
    }

   if (X->GetOption(Xorg::Device, SecNum, "NvAGP") == "3")
    {
     Group[1]->setChecked(TRUE);
     Combo[1]->setCurrentItem(2);
    }

   if (X->GetOption(Xorg::Device, SecNum, "NvAGP") == "4")
    {
     Group[1]->setChecked(TRUE);
     Combo[1]->setCurrentItem(3);
    }

   DVSlider->setValue(X->GetOption(Xorg::Device, SecNum, "DigitalVibrance").toInt(&CheckOK, 10));
   if (X->GetOption(Xorg::Device, SecNum, "DigitalVibrance") != "") { Group[2]->setChecked(TRUE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "TwinView"))
    {
     Group[3]->setChecked(TRUE);
     if (X->GetOption(Xorg::Device, SecNum, "TwinViewOrientation") == "RightOf") { Combo[2]->setCurrentItem(0); }
     if (X->GetOption(Xorg::Device, SecNum, "TwinViewOrientation") == "LeftOf")  { Combo[2]->setCurrentItem(1); }
     if (X->GetOption(Xorg::Device, SecNum, "TwinViewOrientation") == "Above")   { Combo[2]->setCurrentItem(2); }
     if (X->GetOption(Xorg::Device, SecNum, "TwinViewOrientation") == "Below")   { Combo[2]->setCurrentItem(3); }
     if (X->GetOption(Xorg::Device, SecNum, "TwinViewOrientation") == "Clone")   { Combo[2]->setCurrentItem(4); }
    }

if (X->GetOption(Xorg::Device, SecNum, "SecondMonitorHorizSync") != "")
  {
   LineEdit[0]->setText(X->GetOption(Xorg::Device, SecNum, "SecondMonitorHorizSync").section("-", 0, 0).simplifyWhiteSpace());
   LineEdit[1]->setText(X->GetOption(Xorg::Device, SecNum, "SecondMonitorHorizSync").section("-", 1, 1).simplifyWhiteSpace());
  }
if (X->GetOption(Xorg::Device, SecNum, "SecondMonitorVertRefresh") != "")
  {
   LineEdit[2]->setText(X->GetOption(Xorg::Device, SecNum, "SecondMonitorVertRefresh").section("-", 0, 0).simplifyWhiteSpace());
   LineEdit[3]->setText(X->GetOption(Xorg::Device, SecNum, "SecondMonitorVertRefresh").section("-", 1, 1).simplifyWhiteSpace());
  }



if (X->GetOption(Xorg::Device, SecNum, "ConnectedMonitor") != "")
  {
   if (X->GetOption(Xorg::Device, SecNum, "ConnectedMonitor").section(",", 0, 0).simplifyWhiteSpace().lower() == "crt")
    {
     Combo[3]->setCurrentItem(0);
    }
   if (X->GetOption(Xorg::Device, SecNum, "ConnectedMonitor").section(",", 0, 0).simplifyWhiteSpace().lower() == "dfp")
    {
     Combo[3]->setCurrentItem(1);
    }
   if (X->GetOption(Xorg::Device, SecNum, "ConnectedMonitor").section(",", 0, 0).simplifyWhiteSpace().lower() == "tv")
    {
     Combo[3]->setCurrentItem(2);
    }


   if (X->GetOption(Xorg::Device, SecNum, "ConnectedMonitor").section(",", 1, 1).simplifyWhiteSpace().lower() == "crt")
    {
     Combo[4]->setCurrentItem(0);
    }
   if (X->GetOption(Xorg::Device, SecNum, "ConnectedMonitor").section(",", 1, 1).simplifyWhiteSpace().lower() == "dfp")
    {
     Combo[4]->setCurrentItem(1);
    }
   if (X->GetOption(Xorg::Device, SecNum, "ConnectedMonitor").section(",", 1, 1).simplifyWhiteSpace().lower() == "tv")
    {
     Combo[4]->setCurrentItem(2);
    }
  }


QString MetaModes = X->GetOption(Xorg::Device, SecNum, "MetaModes");

if (MetaModes != "")
  {
   for (int a = 0; a <= MetaModes.contains(";"); a++)
    {
     ListBox[0]->insertItem(MetaModes.section(";", a, a).section(",", 0, 0).simplifyWhiteSpace());
     ListBox[1]->insertItem(MetaModes.section(";", a, a).section(",", 1, 1).simplifyWhiteSpace());
    }
   ListBox[0]->setSelected(0, TRUE);
  }

CheckOK = false;
   if (X->GetBoolOption(Xorg::Device, SecNum, "CursorShadow"))
    {
     Group[5]->setChecked(TRUE);
     if (X->GetOption(Xorg::Device, SecNum, "CursorShadowAlpha") != "")
       { Slider[1]->setValue(X->GetOption(Xorg::Device, SecNum, "CursorShadowAlpha").toInt(&CheckOK, 10)); }
     if (X->GetOption(Xorg::Device, SecNum, "CursorShadowXOffset") != "")
       { Slider[2]->setValue(X->GetOption(Xorg::Device, SecNum, "CursorShadowXOffset").toInt(&CheckOK, 10)); }
     if (X->GetOption(Xorg::Device, SecNum, "CursorShadowYOffset") != "")
       { Slider[3]->setValue(X->GetOption(Xorg::Device, SecNum, "CursorShadowYOffset").toInt(&CheckOK, 10)); }
    }

   if (X->GetBoolOption(Xorg::Device, SecNum, "HWCursor"))
    { Check[13]->setChecked(TRUE); }
   else
    { Check[13]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "SWCursor"))
    { Check[14]->setChecked(TRUE); }
   else
    { Check[14]->setChecked(FALSE); }

NVIDIA_MonitorsChange();


   if (Group[6]->isEnabled())
    {
     if (X->GetOption(Xorg::Device, SecNum, "TVStandard") == "PAL-B")     { Combo[7]->setCurrentItem(0); }
     if (X->GetOption(Xorg::Device, SecNum, "TVStandard") == "PAL-D")     { Combo[7]->setCurrentItem(1); }
     if (X->GetOption(Xorg::Device, SecNum, "TVStandard") == "PAL-G")     { Combo[7]->setCurrentItem(2); }
     if (X->GetOption(Xorg::Device, SecNum, "TVStandard") == "PAL-H")     { Combo[7]->setCurrentItem(3); }
     if (X->GetOption(Xorg::Device, SecNum, "TVStandard") == "PAL-I")     { Combo[7]->setCurrentItem(4); }
     if (X->GetOption(Xorg::Device, SecNum, "TVStandard") == "PAL-K1")    { Combo[7]->setCurrentItem(5); }
     if (X->GetOption(Xorg::Device, SecNum, "TVStandard") == "PAL-M")     { Combo[7]->setCurrentItem(6); }
     if (X->GetOption(Xorg::Device, SecNum, "TVStandard") == "PAL-N")     { Combo[7]->setCurrentItem(7); }
     if (X->GetOption(Xorg::Device, SecNum, "TVStandard") == "PAL-NC")    { Combo[7]->setCurrentItem(8); }
     if (X->GetOption(Xorg::Device, SecNum, "TVStandard") == "NTSC-J")    { Combo[7]->setCurrentItem(9); }
     if (X->GetOption(Xorg::Device, SecNum, "TVStandard") == "NTSC-M")    { Combo[7]->setCurrentItem(10); }
     if (X->GetOption(Xorg::Device, SecNum, "TVOutFormat") == "SVIDEO")    { Combo[8]->setCurrentItem(0); }
     if (X->GetOption(Xorg::Device, SecNum, "TVOutFormat") == "COMPOSITE")    { Combo[8]->setCurrentItem(1); }

     if (X->GetOption(Xorg::Device, SecNum, "TVOverScan") != "")
       {
        Overscan->setValue(X->GetOption(Xorg::Device, SecNum, "TVOverScan").toFloat());
       }
    }

   if (Group[7]->isEnabled())
    {
     QString Scaling = X->GetOption(Xorg::Device, SecNum, "FlatPanelProperties").section("Scaling", 1, 1).
     section(",", 0, 0).remove("=").simplifyWhiteSpace();
     QString Dithering = X->GetOption(Xorg::Device, SecNum, "FlatPanelProperties").section("Dithering", 1, 1).
     section(",", 0, 0).remove("=").simplifyWhiteSpace();

     if (Scaling == "default")       { Combo[9]->setCurrentItem(0); }
     if (Scaling == "native")        { Combo[9]->setCurrentItem(1); }
     if (Scaling == "scaled")        { Combo[9]->setCurrentItem(2); }
     if (Scaling == "centered")      { Combo[9]->setCurrentItem(3); }
     if (Scaling == "aspect-scaled") { Combo[9]->setCurrentItem(4); }

     if (Dithering == "default")     { Combo[10]->setCurrentItem(0); }
     if (Dithering == "enabled")     { Combo[10]->setCurrentItem(1); }
     if (Dithering == "disabled")    { Combo[10]->setCurrentItem(2); }
    }





Check[15]->setChecked(TRUE);

   if (X->GetBoolOption(Xorg::Device, SecNum, "NoTwinViewXineramaInfo"))
    { Check[15]->setChecked(TRUE); }
   else
    { Check[15]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "UseClipIDs"))
    { Check[16]->setChecked(TRUE); }
   else
    { Check[16]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "NoBandWidthTest"))
    { Check[17]->setChecked(TRUE); }
   else
    { Check[17]->setChecked(FALSE); }

   if (X->GetBoolOption(Xorg::Device, SecNum, "MultisampleCompatibility"))
    { Check[18]->setChecked(TRUE); }
   else
    { Check[18]->setChecked(FALSE); }

   if (X->GetOption(Xorg::Device, SecNum, "IgnoreDisplayDevices") != "")
    {
     for (int a = 0; a < X->GetOption(Xorg::Device, SecNum, "IgnoreDisplayDevices").contains(",") + 1; a++)
      {
       Group[8]->setChecked(TRUE);
       ListBox[2]->insertItem (X->GetOption(Xorg::Device, SecNum, "IgnoreDisplayDevices").section(",", a, a).simplifyWhiteSpace());
      }
     ListBox[2]->setSelected(0, TRUE);
    }





OptionsDialog->show();
}

void PropertiesDialog :: NVIDIA_DigitalVibrance()
{
LCD[0]->display(DVSlider->value());
}

void PropertiesDialog :: NVIDIA_AddIgnoreDevice()
{
QStringList Items;
Items += Locale(127);
Items += Locale(128);
Items += Locale(129);

QString Output = KInputDialog::getItem(Locale(162), Locale(163), Items); 

for (int a = 0; a < 3; a++)
  {
   if (ListBox[2]->text(a) == Output) 
    {
     KMessageBox::error(this, Locale(165), Locale(164));
     return;
    }
  }

ListBox[2]->insertItem(Output);
ListBox[2]->setSelected(ListBox[2]->count() - 1, TRUE);
}

void PropertiesDialog :: NVIDIA_RemoveIgnoreDevice()
{
unsigned int CurrentItem = ListBox[2]->currentItem();
// if (CurrentItem < 1) { CurrentItem++; }
ListBox[2]->removeItem(CurrentItem);
if (CurrentItem == ListBox[2]->count()) { ListBox[2]->setSelected(CurrentItem - 1, TRUE); }
else { ListBox[2]->setSelected(CurrentItem, TRUE); }
}

void PropertiesDialog :: NVIDIA_EDID()
{
if (Check[10]->isChecked()) { Check[11]->setChecked(FALSE); }
if (Check[10]->isChecked()) 
  {
   LineEdit[0]->setEnabled(FALSE);
   LineEdit[1]->setEnabled(FALSE);
   LineEdit[2]->setEnabled(FALSE);
   LineEdit[3]->setEnabled(FALSE);
  }

if (!Check[10]->isChecked())
  {
   LineEdit[0]->setEnabled(TRUE);
   LineEdit[1]->setEnabled(TRUE);
   LineEdit[2]->setEnabled(TRUE);
   LineEdit[3]->setEnabled(TRUE);
  }


}

void PropertiesDialog :: NVIDIA_DisableEDID()
{
if (Check[11]->isChecked()) { Check[10]->setChecked(FALSE); }
if (Check[11]->isChecked()) 
  {
   LineEdit[0]->setEnabled(TRUE);
   LineEdit[1]->setEnabled(TRUE);
   LineEdit[2]->setEnabled(TRUE);
   LineEdit[3]->setEnabled(TRUE);
  }
}

void PropertiesDialog :: NVIDIA_MonitorsChange()
{

//NOTE: Ale mi się tu pojebalo :)
if (Combo[3]->currentItem() == 2 | Combo[4]->currentItem() == 2) { Group[6]->setEnabled(TRUE); }
if (Combo[3]->currentItem() != 2 & Combo[4]->currentItem() != 2) { Group[6]->setEnabled(FALSE); }

if (Combo[3]->currentItem() == 1 | Combo[4]->currentItem() == 1) { Group[7]->setEnabled(TRUE); }
if (Combo[3]->currentItem() != 1 & Combo[4]->currentItem() != 1) { Group[7]->setEnabled(FALSE); }

}

void PropertiesDialog :: NVIDIA_HwCursor()
{
Check[14]->setChecked(FALSE);
}

void PropertiesDialog :: NVIDIA_SwCursor()
{
Check[13]->setChecked(FALSE);
}

void PropertiesDialog :: NVIDIA_CursorShadowSliders()
{
LCD[1]->display(Slider[1]->value());
LCD[2]->display(Slider[2]->value());
LCD[3]->display(Slider[3]->value());
}

void PropertiesDialog :: NVIDIA_AddMetaMode()
{
ListBox[0]->insertItem(Combo[5]->text(Combo[5]->currentItem()));
ListBox[1]->insertItem(Combo[6]->text(Combo[6]->currentItem()));
ListBox[0]->setSelected(ListBox[0]->count() - 1, TRUE);
}

void PropertiesDialog :: NVIDIA_RemoveMetaMode()
{
int CurrentItem = ListBox[0]->currentItem();
ListBox[0]->removeItem(CurrentItem);
ListBox[1]->removeItem(CurrentItem);
}

void PropertiesDialog :: NVIDIA_MetaMode1Clicked()
{
ListBox[1]->setSelected(ListBox[0]->currentItem(), TRUE);
}

void PropertiesDialog :: NVIDIA_MetaMode2Clicked()
{
ListBox[0]->setSelected(ListBox[1]->currentItem(), TRUE);
}

void PropertiesDialog :: NVIDIA_SaveAndExit()
{
if (Group[3]->isChecked())
  {
   if (ListBox[0]->count() == 0)
    {
     KMessageBox::error(this, Locale(166), Locale(164));
     return;
    }
  }
if (LineEdit[0]->isEnabled())
{
     if (LineEdit[0]->text() == "") { KMessageBox::error(this, Locale(167), Locale(164)); return; }
     if (LineEdit[1]->text() == "") { KMessageBox::error(this, Locale(167), Locale(164)); return; }
     if (LineEdit[2]->text() == "") { KMessageBox::error(this, Locale(168), Locale(164)); return; }
     if (LineEdit[3]->text() == "") { KMessageBox::error(this, Locale(168), Locale(164)); return; }
}

if (Group[8]->isChecked())
  {
   if (ListBox[2]->count() == 0) { KMessageBox::error(this, Locale(169), Locale(164)); return; }
  }


if (Check[0]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "NoLogo", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "NoLogo"); }

if (Check[1]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "RenderAccel", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "RenderAccel"); }

if (Check[2]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "NoRenderExtension", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "NoRenderExtension"); }

if (Check[3]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "UBB", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "UBB"); }

if (Check[4]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "WindowFlip", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "WindowFlip"); }

if (Check[5]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "PageFlip", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "PageFlip"); }

if (Check[6]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "Dac8Bit", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "Dac8Bit"); }

if (Check[7]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "Overlay", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "Overlay"); }

if (Check[8]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "CIOverlay", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "CIOverlay"); }

if (Check[9]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "OverlayDefaultVisual", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "OverlayDefaultVisual"); }

if (Check[10]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "UseEdidFreqs", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "UseEdidFreqs"); }

if (Check[11]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "IgnoreEDID", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "IgnoreEDID"); }

if (Group[0]->isChecked())
  {
   if (Combo[0]->currentItem() == 0) { X->WriteOption(Xorg::Device, SecNum, "Stereo", "1"); }
   if (Combo[0]->currentItem() == 1) { X->WriteOption(Xorg::Device, SecNum, "Stereo", "2"); }
   if (Combo[0]->currentItem() == 2) { X->WriteOption(Xorg::Device, SecNum, "Stereo", "3"); }
   if (Combo[0]->currentItem() == 3) { X->WriteOption(Xorg::Device, SecNum, "Stereo", "4"); }
  }
if (!Group[0]->isChecked()) { X->RemoveOption(Xorg::Device, SecNum, "Stereo"); }

if (Group[1]->isChecked())
  {
   if (Combo[1]->currentItem() == 0) { X->WriteOption(Xorg::Device, SecNum, "NvAGP", "1"); }
   if (Combo[1]->currentItem() == 1) { X->WriteOption(Xorg::Device, SecNum, "NvAGP", "2"); }
   if (Combo[1]->currentItem() == 2) { X->WriteOption(Xorg::Device, SecNum, "NvAGP", "3"); }
   if (Combo[1]->currentItem() == 3) { X->WriteOption(Xorg::Device, SecNum, "NvAGP", "4"); }
  }
if (!Group[1]->isChecked()) { X->RemoveOption(Xorg::Device, SecNum, "NvAGP"); }

if (Group[2]->isChecked())
  {
   QString Num;
   Num = Num.setNum(DVSlider->value(), 10);
   X->WriteOption(Xorg::Device, SecNum, "DigitalVibrance", Num);
  }
if (!Group[2]->isChecked()) { X->RemoveOption(Xorg::Device, SecNum, "DigitalVibrance"); }


if (Group[3]->isChecked()) 
  {
   //TwinView, TwinViewOrientation
   X->WriteOption(Xorg::Device, SecNum, "TwinView", BOOL_TRUE);
   if (Combo[2]->currentItem() == 0) { X->WriteOption (Xorg::Device, SecNum, "TwinViewOrientation", "RightOf"); }
   if (Combo[2]->currentItem() == 1) { X->WriteOption (Xorg::Device, SecNum, "TwinViewOrientation", "LeftOf"); }
   if (Combo[2]->currentItem() == 2) { X->WriteOption (Xorg::Device, SecNum, "TwinViewOrientation", "Above"); }
   if (Combo[2]->currentItem() == 3) { X->WriteOption (Xorg::Device, SecNum, "TwinViewOrientation", "Below"); }
   if (Combo[2]->currentItem() == 4) { X->WriteOption (Xorg::Device, SecNum, "TwinViewOrientation", "Clone"); }

   if (LineEdit[0]->isEnabled())
    {
     X->WriteOption(Xorg::Device, SecNum, "SecondMonitorHorizSync", LineEdit[0]->text() + "-" + LineEdit[1]->text());
     X->WriteOption(Xorg::Device, SecNum, "SecondMonitorVertRefresh", LineEdit[2]->text() + "-" + LineEdit[3]->text());
    }

   X->WriteOption(Xorg::Device, SecNum, "ConnectedMonitor", Combo[3]->text(Combo[3]->currentItem()) + ", " +
   Combo[4]->text(Combo[4]->currentItem()));
   QString MetaModes = "";
  for (unsigned int a = 0; a < ListBox[0]->count(); a++)
   {
    MetaModes = MetaModes.append(ListBox[0]->text(a)).append(", ").append(ListBox[1]->text(a)).append("; ");
   }
   X->WriteOption(Xorg::Device, SecNum, "MetaModes", MetaModes);

  }


if (!Group[3]->isChecked())
  {
   X->RemoveOption(Xorg::Device, SecNum, "TwinView");
   X->RemoveOption(Xorg::Device, SecNum, "TwinViewOrientation");
   X->RemoveOption(Xorg::Device, SecNum, "SecondMonitorHorizSync");
   X->RemoveOption(Xorg::Device, SecNum, "SecondMonitorVertRefresh");
   X->RemoveOption(Xorg::Device, SecNum, "ConnectedMonitor");
   X->RemoveOption(Xorg::Device, SecNum, "MetaModes");
  }


if (Group[5]->isChecked())
  {
   QString Num = "";
   X->WriteOption(Xorg::Device, SecNum, "CursorShadow", BOOL_TRUE);
   Num = Num.setNum(Slider[1]->value(), 10);
   X->WriteOption(Xorg::Device, SecNum, "CursorShadowAlpha", Num);
   Num = Num.setNum(Slider[2]->value(), 10);
   X->WriteOption(Xorg::Device, SecNum, "CursorShadowXOffset", Num);
   Num = Num.setNum(Slider[3]->value(), 10);
   X->WriteOption(Xorg::Device, SecNum, "CursorShadowYOffset", Num);
  }

if (!Group[5]->isChecked())
  {
   X->RemoveOption(Xorg::Device, SecNum, "CursorShadow");
   X->RemoveOption(Xorg::Device, SecNum, "CursorShadowXOffset");
   X->RemoveOption(Xorg::Device, SecNum, "CursorShadowYOffset");
  }

if (Check[13]->isChecked())
  { X->WriteOption(Xorg::Device, SecNum, "HWCursor", BOOL_TRUE); }
else
  { X->RemoveOption(Xorg::Device, SecNum, "HWCursor"); }

if (Check[14]->isChecked())
  { X->WriteOption(Xorg::Device, SecNum, "SWCursor", BOOL_TRUE); }
else
  { X->RemoveOption(Xorg::Device, SecNum, "SWCursor"); }

if (Group[6]->isEnabled())
  {
   if (Combo[7]->currentItem() == 0) { X->WriteOption(Xorg::Device, SecNum, "TVStandard", "PAL-B"); }
   if (Combo[7]->currentItem() == 1) { X->WriteOption(Xorg::Device, SecNum, "TVStandard", "PAL-D"); }
   if (Combo[7]->currentItem() == 2) { X->WriteOption(Xorg::Device, SecNum, "TVStandard", "PAL-G"); }
   if (Combo[7]->currentItem() == 3) { X->WriteOption(Xorg::Device, SecNum, "TVStandard", "PAL-H"); }
   if (Combo[7]->currentItem() == 4) { X->WriteOption(Xorg::Device, SecNum, "TVStandard", "PAL-I"); }
   if (Combo[7]->currentItem() == 5) { X->WriteOption(Xorg::Device, SecNum, "TVStandard", "PAL-K1"); }
   if (Combo[7]->currentItem() == 6) { X->WriteOption(Xorg::Device, SecNum, "TVStandard", "PAL-M"); }
   if (Combo[7]->currentItem() == 7) { X->WriteOption(Xorg::Device, SecNum, "TVStandard", "PAL-N"); }
   if (Combo[7]->currentItem() == 8) { X->WriteOption(Xorg::Device, SecNum, "TVStandard", "PAL-NC"); }
   if (Combo[7]->currentItem() == 9) { X->WriteOption(Xorg::Device, SecNum, "TVStandard", "NTSC-J"); }
   if (Combo[7]->currentItem() == 10) { X->WriteOption(Xorg::Device, SecNum, "TVStandard", "NTSC-M"); }
   if (Combo[8]->currentItem() == 0) { X->WriteOption(Xorg::Device, SecNum, "TVOutFormat", "SVIDEO"); }
   if (Combo[8]->currentItem() == 1) { X->WriteOption(Xorg::Device, SecNum, "TVOutFormat", "COMPOSITE"); }
   QString Num;
   Num = Num.setNum (Overscan->value(), 'f', 1);
   X->WriteOption(Xorg::Device, SecNum, "TVOverScan", Num);
  }

if (Group[6]->isEnabled())
  {
   X->RemoveOption(Xorg::Device, SecNum, "TVStandard");
   X->RemoveOption(Xorg::Device, SecNum, "TVOutFormat");
   X->RemoveOption(Xorg::Device, SecNum, "TVOverScan");
  }
QString Scaling = "Scaling = ";
QString Dithering = "Dithering = ";
if (Group[7]->isEnabled())
  {
   if (Combo[9]->currentItem() == 0) { Scaling = Scaling + "default"; }
   if (Combo[9]->currentItem() == 1) { Scaling = Scaling + "native"; }
   if (Combo[9]->currentItem() == 2) { Scaling = Scaling + "scaled"; }
   if (Combo[9]->currentItem() == 3) { Scaling = Scaling + "centered"; }
   if (Combo[9]->currentItem() == 4) { Scaling = Scaling + "aspect-scaled"; }
   if (Combo[10]->currentItem() == 0) { Dithering = Dithering + "default"; }
   if (Combo[10]->currentItem() == 1) { Dithering = Dithering + "enabled"; }
   if (Combo[10]->currentItem() == 2) { Dithering = Dithering + "disabled"; }
   X->WriteOption(Xorg::Device, SecNum, "FlatPanelProperties", Scaling + ", " + Dithering);
  }
if (!Group[7]->isEnabled())
  {
   X->RemoveOption(Xorg::Device, SecNum, "FlatPanelProperties");
  }

if (Check[15]->isChecked()) 
  { X->WriteOption(Xorg::Device, SecNum, "NoTwinViewXineramaInfo", BOOL_TRUE); }
else
  { X->RemoveOption(Xorg::Device, SecNum, "NoTwinViewXineramaInfo"); }

if (Check[16]->isChecked()) 
  { X->WriteOption(Xorg::Device, SecNum, "UseClipIDs", BOOL_TRUE); }
else
  { X->RemoveOption(Xorg::Device, SecNum, "UseClipIDs"); }

if (Check[17]->isChecked()) 
  { X->WriteOption(Xorg::Device, SecNum, "NoBandWidthTest", BOOL_TRUE); }
else
  { X->RemoveOption(Xorg::Device, SecNum, "NoBandWidthTest"); }

if (Check[18]->isChecked()) 
  { X->WriteOption(Xorg::Device, SecNum, "MultisampleCompatibility", BOOL_TRUE); }
else
  { X->RemoveOption(Xorg::Device, SecNum, "MultisampleCompatibility"); }

if (Group[8]->isChecked())
  {
   QString Ignored = "";
   for (unsigned int a = 0; a <= ListBox[2]->count(); a++)
    {
     Ignored = Ignored.append(ListBox[2]->text(a));
     if (a == ListBox[2]->count() - 1) { break; }
     if (a < ListBox[2]->count() - 1) { Ignored = Ignored.append(", "); }
    }
   X->WriteOption(Xorg::Device, SecNum, "IgnoreDisplayDevices", Ignored);
  }
if (!Group[8]->isChecked()) { X->RemoveOption(Xorg::Device, SecNum, "IgnoreDisplayDevices"); }

OptionsDialog->close();
}

//VESA driver

void PropertiesDialog :: SetOptions_VESA(QWidget *Parent, Xorg *Xorg, int SectionNumber)
{
CreateWindow(500, 300, "vesa", "kcmpci", Parent);

SecNum = SectionNumber;
X = Xorg;

InformationLabel->setText(Locale(44).append("<br><br>" + Locale(25) + " <b>" + X->GetValue(Xorg::Device, SectionNumber, "Identifier", 1) + "</b>"));

Check[0] = new QCheckBox(OptionsDialog);
   Check[0]->setGeometry(10, 140, 210, 25);
   Check[0]->setText(Locale(172));

//Connecting
connect (OKButton, SIGNAL(clicked()), this, SLOT(VESA_SaveAndExit()));

///Initializing

   if (X->GetBoolOption(Xorg::Device, SecNum, "ShadowFB"))
    {
     Check[0]->setChecked(FALSE);
    }
   else
    {
     Check[0]->setChecked(TRUE);
    }

OptionsDialog->exec();
}

void PropertiesDialog :: VESA_SaveAndExit()
{
   if (Check[0]->isChecked())
    {
     X->WriteOption(Xorg::Device, SecNum, "ShadowFB", BOOL_FALSE);
    }
   if (!Check[0]->isChecked())
    {
     X->WriteOption(Xorg::Device, SecNum, "ShadowFB", BOOL_TRUE);
    }

OptionsDialog->close();
}

//VGA driver


void PropertiesDialog :: SetOptions_VGA(QWidget *Parent, Xorg *Xorg, int SectionNumber)
{
CreateWindow(580, 240, "vga", "kcmpci", Parent);

SecNum = SectionNumber;
X = Xorg;

InformationLabel->setText(Locale(44).append("<br><br>" + Locale(25) + " <b>" + X->GetValue(Xorg::Device, SectionNumber, "Identifier", 1) + "</b>"));


  Check[0] = new QCheckBox(OptionsDialog);
   Check[0]->setText(Locale(173));
   Check[0]->setGeometry(10, 150, 300, 25);


connect (OKButton, SIGNAL(clicked()), this, SLOT(VGA_SaveAndExit()));


   if (X->GetBoolOption(Xorg::Device, SecNum, "ShadowFB"))
     {
      Check[0]->setChecked(TRUE);
     }
   else
     {
      Check[0]->setChecked(FALSE);
     }


OptionsDialog->exec();
}

void PropertiesDialog :: VGA_SaveAndExit()
{
if (Check[0]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "ShadowFB", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "ShadowFB"); }

OptionsDialog->close();

}


//i128 driver

void PropertiesDialog :: SetOptions_i128(QWidget *Parent, Xorg *Xorg, int SectionNumber)
{
CreateWindow(600, 350, "i128", "kcmpci", Parent);

SecNum = SectionNumber;
X = Xorg;

InformationLabel->setText(Locale(44).append("<br><br>" + Locale(25) + " <b>" + X->GetValue(Xorg::Device, SectionNumber, "Identifier", 1) + "</b>"));

   Check[0] = new QCheckBox(OptionsDialog);
    Check[0]->setText(Locale(174));
    Check[0]->setGeometry(10, 150, 300, 25);

   Check[1] = new QCheckBox(OptionsDialog);
    Check[1]->setText(Locale(175));
    Check[1]->setGeometry(10, 175, 300, 25);

   Check[2] = new QCheckBox(OptionsDialog);
    Check[2]->setText(Locale(176));
    Check[2]->setGeometry(10, 200, 300, 25);

   Check[3] = new QCheckBox(OptionsDialog);
    Check[3]->setText(Locale(177));
    Check[3]->setGeometry(10, 225, 300, 25);

   Check[4] = new QCheckBox(OptionsDialog);
    Check[4]->setText(Locale(178));
    Check[4]->setGeometry(10, 250, 300, 25);


//Loading

   if (X->GetBoolOption(Xorg::Device, SecNum, "HWCursor"))
     {
      Check[0]->setChecked(TRUE);
     }
   else
     {
      Check[0]->setChecked(FALSE);
     }

   if (X->GetBoolOption(Xorg::Device, SecNum, "NoAccel"))
     {
      Check[1]->setChecked(TRUE);
     }
   else
     {
      Check[1]->setChecked(FALSE);
     }

   if (X->GetBoolOption(Xorg::Device, SecNum, "SyncOnGreen"))
     {
      Check[2]->setChecked(TRUE);
     }
   else
     {
      Check[2]->setChecked(FALSE);
     }

   if (X->GetBoolOption(Xorg::Device, SecNum, "Dac6Bit"))
     {
      Check[3]->setChecked(TRUE);
     }
   else
     {
      Check[3]->setChecked(FALSE);
     }

   if (X->GetBoolOption(Xorg::Device, SecNum, "Debug"))
     {
      Check[4]->setChecked(TRUE);
     }
   else
     {
      Check[4]->setChecked(FALSE);
     }


connect (OKButton, SIGNAL(clicked()), this, SLOT(i128_SaveAndExit()));


OptionsDialog->exec();
}

void PropertiesDialog :: i128_SaveAndExit()
{
if (Check[0]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "HWCursor", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "HWCursor"); }

if (Check[1]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "NoAccel", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "NoAccel"); }

if (Check[2]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "SyncOnGreen", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "SyncOnGreen"); }

if (Check[3]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "Dac6Bit", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "Dac6Bit"); }

if (Check[4]->isChecked()) 
{ X->WriteOption(Xorg::Device, SecNum, "Debug", BOOL_TRUE); }
else
{ X->RemoveOption(Xorg::Device, SecNum, "Debug"); }

OptionsDialog->close();

}



