/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//KDE Includes
#include <kdialog.h>
#include <kpushbutton.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <klineedit.h>
#include <klistbox.h>


//QT Includes
#include <qlabel.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qlcdnumber.h>

//kX Generator Includes
#include "Xorg.h"

class PropertiesDialog : public KDialog
{
    Q_OBJECT

public:
///Input drivers
   void SetOptions_MOUSE(QWidget *Parent = 0, Xorg *Xorg = 0, int SectionNumber = 0);
   void SetOptions_WACOM(QWidget *Parent = 0, Xorg *Xorg = 0, int SectionNumber = 0);


///Video drivers
   void SetOptions_NV(QWidget *Parent = 0, Xorg *Xorg = 0, int SectionNumber = 0);
   void SetOptions_NVIDIA(QWidget *Parent = 0, Xorg *Xorg = 0, int SectionNumber = 0);
   void SetOptions_VESA(QWidget *Parent = 0, Xorg *Xorg = 0, int SectionNumber = 0);
   void SetOptions_VGA(QWidget *Parent = 0, Xorg *Xorg = 0, int SectionNumber = 0);
   void SetOptions_i128(QWidget *Parent = 0, Xorg *Xorg = 0, int SectionNumber = 0);
   void SetOptions_i810(QWidget *Parent = 0, Xorg *Xorg = 0, int SectionNumber = 0);

//No options

   void NoOptions(QString DriverName);


private:
KDialog *OptionsDialog;
void CreateWindow(int x, int y, QString DriverName, QString IconName, QWidget *ParentWindow);

Xorg *X;

  KPushButton *OKButton;
  KPushButton *CancelButton;
  QLabel *InformationLabel;

  KPushButton *Button[5];

  KComboBox *Combo[20];
  KIntSpinBox *SpinBox[20];
  KLineEdit *LineEdit[5];
  QLabel *Label[40];
  QCheckBox *Check[40];
  QGroupBox *Group[10];
  QRadioButton *Radio[10];

  KListBox *ListBox[10];

  QSlider *DVSlider;
  QSlider *Slider[5];
  QLCDNumber *LCD[5];
  KDoubleNumInput *Overscan;

int SecNum;

QString Locale(int n);

private slots:



///Input drivers

//MOUSE driver

   void MOUSE_ButtonsCheck(bool Checked);
   void MOUSE_SampleCheck(bool Checked);
   void MOUSE_ResolutionCheck(bool Checked);
   void MOUSE_SaveAndExit();

//WACOM driver

   void WACOM_SaveAndExit();
   void WACOM_HistoryCheck(bool Checked);
   void WACOM_SerialCheck(bool Checked);
   void WACOM_ThresholdCheck(bool Checked);
   void WACOM_DebugCheck(bool Checked);


///Video drivers

//NV driver
   void NV_CRTCCheck(bool Checked);
   void NV_Radio0Clicked();
   void NV_Radio1Clicked();
   void NV_SaveAndExit();

//NVIDIA driver

   void NVIDIA_DigitalVibrance();
   void NVIDIA_AddIgnoreDevice();
   void NVIDIA_RemoveIgnoreDevice();
   void NVIDIA_EDID();
   void NVIDIA_DisableEDID();
   void NVIDIA_MonitorsChange();
   void NVIDIA_HwCursor();
   void NVIDIA_SwCursor();
   void NVIDIA_CursorShadowSliders();
   void NVIDIA_AddMetaMode();
   void NVIDIA_RemoveMetaMode();
   void NVIDIA_MetaMode1Clicked();
   void NVIDIA_MetaMode2Clicked();
   void NVIDIA_SaveAndExit();

//VESA driver

   void VESA_SaveAndExit();

//VGA driver

   void VGA_SaveAndExit();

//i128 driver

   void i128_SaveAndExit();


//i810 driver

   void i810_CheckSpinBoxes();
   void i810_CheckRotate1();
   void i810_CheckRotate2();
   void i810_SaveAndExit();

};
