require 'needle/pipeline/element'

class Class

  # Add a hook for declaring properties of an object that should be injected
  # into instances of this class. See Object#inject_attributes.
  def attr_inject( *properties )
    ( @injectable_attributes ||= [] ).concat properties.map { |p| p.to_sym }
  end
  private :attr_inject

  # Returns an array of attributes of the class that have been declared to
  # be injectable. See #attr_inject and Object#inject_attributes.
  def injectable_attributes
    if defined?(@injectable_attributes)
      @injectable_attributes
    else
      []
    end
  end

end

class Object

  # Injects all injectable attributes of the instance's class with the
  # corresponding services from the given container. Each attribute is
  # injected into an identically named instance variable of the object,
  # from an identically named service in the container.
  #
  # This returns the object itself.
  def inject_attributes( container )
    self.class.injectable_attributes.each do |attribute|
      instance_variable_set "@#{attribute}", container.get( attribute )
    end
    self
  end

end

module Needle
  module Extras
    module AttrInject

      # A specialized pipeline element that injects the constructed service
      # with dependent services from the point's container.
      class InjectorElement < Needle::Pipeline::Element
        set_default_priority 0
        
        def call( *args )
          succ.
            call( *args ).
            inject_attributes( service_point.container )
        end

      end

      # Registers the InjectorElement pipeline element, and adds some new
      # service models (multiton_inject, prototype_inject, and
      # singleton_inject).
      def register_services( container )
        container.pipeline_elements[ :attr_inject ] = InjectorElement
        container.service_models.update(
          :multiton_inject  => [ :multiton, :attr_inject ],
          :prototype_inject => [ :attr_injector ],
          :singleton_inject => [ :singleton, :attr_inject ]
        )
      end
      module_function :register_services

    end
  end
end
