#ifndef MYASSERTIONTRAITS_H
#define MYASSERTIONTRAITS_H

#include <cppunit/TestAssert.h>

CPPUNIT_NS_BEGIN

//----------------------------------------------------------------------------
template <>
struct assertion_traits<const char*>
{
    static bool equal(const char *x, const char *y)
    {
        return !strcmp(x, y);
    }

    static std::string toString(const char *x)
    {
        OStringStream ost;
        ost << '"' << x << '"';
        return ost.str();
    }
};

CPPUNIT_NS_END

#endif //MYASSERTIONTRAITS_H
