/*
    Copyright (C) 2003 Otso Kiveks, <otso.kivekas@movial.fi>

    This file is part of Outo.

    Outo is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published 
    by the Free Software Foundation; either version 2.1 of the License, or
    (at your option) any later version.

    Outo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Outo; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#define _GNU_SOURCE

#include <stdio.h>
#include <string.h>
#include <sys/wait.h>

#include "report.h"

/*----------------- REPORTING --------------------*/

void begin_report()
{
}

void begin_lib_report(char *name)
{
  printf("\nTests in test suite %s\n", name);
}

void end_lib_report(stat *lib, char* name)
{
  printf("\nSummary for test suite %s:\n", name);
  printf("# of tests:  %i\n", lib->tests);
  printf("# of passed: %i\n", lib->pass);
  printf("# of failed: %i\n", lib->fail);
  printf("\n");

}

/** finishes the test report*/
void end_report(stat *total)
{
  printf("\n\nSummary of all test suites:\n");
  printf("# of test suites:  %i\n", total->cur);
  printf("# of tests:        %i\n", total->tests);
  printf("# of passed:       %i\n", total->pass);
  printf("# of failed:       %i\n", total->fail);
  printf("\n");

}

/** writes a test case result*/
void report(testcase* tcase, int statloc, stat *lib)
{
  /*just plain text for now... */

 
   if(tcase->ex_result==EXPECT_ASSERT){
      if(WIFSIGNALED(statloc) ){
        int sig = WTERMSIG(statloc);
        /* add generic assersig handling here */
        if(sig == SIGABRT || sig == SIGTRAP){
          PRINTT(lib->cur, tcase, 1);
          lib->pass++;
        }
        else{ 
          PRINTT_(lib->cur, tcase, 0);
          printf(" (got signal %s, not assert)\n", strsignal(sig) );
          lib->fail++;
        }
      } 
      else{ 
        PRINTT_(lib->cur, tcase, 0);          
        printf(" (didn't throw assert)\n");
        lib->fail++;
      }
   }
   else{ /* EXPECT_OK */ 
     if(WIFEXITED(statloc) ){
       
       PRINTT(lib->cur, tcase, WEXITSTATUS(statloc)==0);
       WEXITSTATUS(statloc)==0 ? lib->pass++ : lib->fail++;
     }
     else{ /* died on signal with EXPECTED_OK */
       PRINTT_(lib->cur, tcase, 0); 
       printf(" (got signal %s)\n", strsignal(WTERMSIG(statloc))); 
       lib->fail++;
     }
   }

   /*  PRINTT(tcase, statloc==0); */
  
}
