# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is designed by Igor Kekeljevic (http://www.admiror-ns.co.yu).

from core import models
from core.translation import _t

#---PIL
def init():
    global Image, ImageColor
    import Image, ImageColor
    
def brightness(image,amount=50):
    """Adjust brightness from black to white
    - amount: -1(black) 0 (unchanged) 1(white)
    - repeat: how many times it should be repeated"""
    if amount == 0:
        return image
    elif amount < 0:
        #fade to black
        im = Image.blend(
                image,
                Image.new(image.mode, image.size, 0),
                -amount/100.0
        )
    else:
        #fade to white
        im = Image.blend(
                image,
                Image.new(image.mode, image.size, 
                    ImageColor.getcolor('white',image.mode)),
                amount/100.0
        )
    #fix image transparency mask
    if image.mode == 'RGBA':
        im.putalpha(image.split()[-1])
    return im

#---Phatch
class Action(models.Action):
    label       = _t('Brightness')
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    init        = staticmethod(init)
    pil         = staticmethod(brightness)
    version     = '0.1'
    tags        = [_t('colours')]
    __doc__     = _t('Adjust brightness from black to white')
    
    def interface(self,fields):
        fields[_t('Amount')] = self.SliderField(50,-100,100)
    
    icon = \
'x\xda\x01p\x0b\x8f\xf4\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x0b\'IDATh\x81\xd5\x99}\x8c\x9c\xc7]\xc7?3\xf3\xbc\
\xec\xcb\xbd\xda\xb7\xf7\xeas\xac\xe4\xe2:i\xac\x928mP\x9a\x94\xaa/$\xc4i*\
\x02\xe1\x0fT(\x12B\xa0\x12U\xc0\x1fH\xfcE\xfeF\x88\x7f\x88\x00\x81\x00\x11\
\x89R\x91\xa8\xa8\x8d\x94\xd4\x10\xd1\x04\x1a[\xads\x89\x82\x89]_\xec\xd4v.\
\xb6\xef\xf6\xeev\xf7nw\x9f\x97yf~\xfc\xb1\xe7\xf8JZ\xb8\xf3\xad\x83\x18ivfw\
\x9f\xe7\xf9}?\xf3\xfb\xfdffg\x95\x88\xf0\xff\xb9\x047\xf3\xe1\x9f~Y\x95\xb2\
\x8c\x83\n\xe2\x8aa\xe1\xa5\xcfI\xab\xdf6T?=p\xef\xbc\n\x83:_M\x12\x9eHR\x0e\
\xbb\x82J\x14\xc4h\x0c\x89\xed\xa2\ry\xa5\xc4\xf9r\x99o\x19\xc3\x9f\x1c\x7fH\
\x96wk\xb3o\x00\x0f|[}\xaa\xd9\xe6\x1f\xb4\xabN\x1f\x1a\xbd\x8b\xc9\xea>\xf6\
\xc4c\x94\x83*\x08d.\xa5\x91\xad\xb2\xd4\xbd\xca\x99\xd5\xff\xa0\xe3\x1b\x9d\
\xb1\x1a\xbfw\xfc\xf3\xf2\x97\xff\xa7\x00\xea)\xa5?~\x1f\x7f\x9e\xac\xc7\xbf\
\xfe\xb1\xb1\x8f\x9b[\x87?B)(\x11\xe8\x90HG\x04&\x04\x01\xeb-\xd6Yr\x97\x93;\
\xcb\xc5\xf5wxc\xe9\xfb\x98\x81\xf5WB\xc7/|\xff\xe7e\xf5C\x07\xb8\xff\x98\
\x1aow\xf8\x9e\xb3\xe1\x81\x07f>K\xad<Al"B\x1d\x12\x06!\xa1\x0e1\x9biVH\xb1\
\t`\xb1\x85%s9\x1b\xf9\x06\xaf\xbc\xf7/d~c}\xef^\xbex\xfcg\xe5\xe5\x9dj\xd07\
\xac\x1eH3\x9e\xb3\x96\x03\xf7N\xfc4#\xa5a\xb4v\xa0\x0b\x08,\xa2r\x9cJ)T\x17\
\xab\xba8\x95\xe2u\x0e\xda"\xc6\x82v\xc4a\xc8}\x13\x0f\x80\x84C\x8d&_\x7f\
\xe4E\x15\x7fh\x00\x9f|I\xfdV\xb7\xc3\x83\x83q\x95\xd1\xd2\x08\xa2,^\xe7x\
\x9d\xe1U\x867)N%\x14\xaa\x8bS\xdd^K\x82\xd3i\xef{\x95\xe1UN\x18\x1a\xc6+5\
\xb2\x94\x89\xe5\x82g>\x14\x80O\x7fGM4\x9b\xfc\x91\t`Oe\x0f^\xf7F\xdc\xab\
\x0c\xaf3\x9cNz\xe2u\x17\xa7\xbb\x14\xba\x8b7\xc9\xfb\x9f{\x95\xe1T\x86#\xc3\
\x933Z\x1eEkX[\xe3\x17\xef?\xa6\x1e\xd9\x89\x96\x1bZ\x076\xba|\xcd;\x06\xa3\
\x08\xfc\xa6p\xa7\x0b\xb42\x18mpZ\xa3\xb4F+\x85\xa0\xf0"\x88@\xa1=N<\x85\xf2\
8\xe5p\xaa\xc0\xe1pd\x18\x03\xde\xa3\x1b-\xfe\x06\x98\xdc\xae\x96\x1d{\xe0\
\x91\x17U\xdci\xf3I\xadA+h\x17k\x14\xa4\x14*\xc5\xe9\x94B%x\x95\xe0t\x17g\
\xba\xf8\xa0W\x9d\xde\x0c%\x12\n\x95\xf4ZI)Hi\x15+\x98\xcd\xe7\xa5\t\x13\x0f\
\xfe\xb3\xfa\xdcv\xf5\xec\xd8\x03\xcd\x80/\x8b\'\xd6\x06\xb4\x06\xd1\x96\xd5\
\xfc=jA\r\x83A+\x8d2\xaa\xa7\xc6(@\xe1D\xf0\x02\xce\x0bVy\xacx,\x9e\\\x1c\
\x1b\xaeM\xd7\xb6P\xba\xf7<\xe7!I\xf9\r\xe0\xa5\x9b\x02`\xf3\xde\xe8\x0fU4b\
\x04\x94P\xcf/\x11F\x9e\xd1p\x04D\xa3D\xa3\x8dB\x1bp\n\xc4\xf7\x84Y%\x14\xca\
c\x95`\xbd\xa7\xe3\xba\\N/\x82\x16\xb4\x02\xb5\x19\x0fy\xc1G\xb7\xabg\xc7\
\x00\xce3e\x14\x8cT\xca\x94#\xc3Z\xba\x81ha\xd5-\xe2\xec\x06\xa3\xc1(\xa8\
\x08\xbc\x82\x00L\x00\xd6\x82U`\x11r/\xa4\xbe\xa0Q4i\xe6-D<\n\xe8\xbd\xf4JQ0\
z\xd3\x00\x10\xaa\x02T\x82\x12\x93\x03{\x18(E\\\\_\xa1\xb5\x04i\xa9\x85\x9dj\
1\xa0+T\x88\x89\x8a\x80\xd6e\xc5\xa9\x93]\xee\xfb|\x85\xb4\xb0$E\xceF\xda%\
\xb3\xc2\xd2y\x18\x98\xdc\x14\xbfe=\xf5Bi\xbbrv\x9c\xc4A\xc0\xeb\x85\xeb\xf5\
k\xf1\x14\xb7\x0e\x1edj`\x88\xcbo\xc3\xc9\xe7ac\r\xba\xb6K+op\xe9j\x9d\x7fzf\
\x99\x8b?l\xf3\xf2\xb1e\xd6\xb3\x06]\xdb\xc1y\xe1\x9d\xd7\xe0\x07\xdf\x05\
\xefz!&\xf4Z\x80R\xcc\xdb\xdb\xd6\xb3S\x80\xd0\xf0\xbc\x08O&6\xa7\xa4\xab\
\xccV\xe7($\xe3\xed\xd9\xd7Y>/\xbc\xfa\x1c\xec\xbb\xa3\x97\xc3\x8bg\xe1\xa7>\
\x03\xb5[\xe0{\xcf\xc3+_\x87\xda\x01\xa8_\x84N\x13\x06k\xa0\x03(,x\x0f~\xd3\
\x0bQ\xcc\xbfmW\xcf\x8e=p\xfc\x04/)E\xbe\xd2Nh\x17mf\xca\x87\xb9c\xe8~\x0e\
\xdf6\x8e\x00\x9f\xf8"\x84%\x08+\xf0\xc0/\xc1\xd8\x81\x9e\xb0#\x8f\xc0\xadG \
Oa\xe6\xa301\x07#S\xe0\x1c\xb8\xa2\xe7\x89k\x00\x81\xe6\xd9\x9b\x06 O\x89\
\xafVy\xb5\xd1.\xb8\xda\xbeL\xea\xda\xdc=\xf8\x05n\x1b9Hu\x08\xbam\x98\xb9\
\x03f>\x02:\xec\t\xces\xb09\x0cO\xc2\xfe\x8f\xc1\xd0$\xac.\xc2\xe0$\x14n\x13\
\xc2\xf7B\xa8Ra\xf1\xf8Cr\xf2\xa6\x01\x00\xc4\x86_\x03\xb2w[\xcb\x9c[\x9fg$\
\x9ce_\xf9Nf\xf7\x97\xa8\xbf\xdb\x13\x9c[\xc82\xc8r\xc83\xc8\xec&\x88\x85\
\xee:\xd8\x14\x82Jo\xf4\xdd&\x04 C\x03\xfc\xf6N\xb4\xdc\x10\xc0\x89\xa3rih\
\x88\xbf\xfea}\x83\xb7\xd6\xde\xe0d\xe3\x1b\x0c\x99\tn\xbf\xb5F\xe3rOp\x9eoi\
\xf3\xebPy\x0ek\x8b08\xd1\x8b\xfd\xc2\xd2\xdbr\x08\x0c\x8fp\xfc\xc4\xcf\xc9\
\xb7n:\x00\x80L\xf2;\xda\xb0\xfc\xd6\xd2\x05\xdeX\xfd\x0e\xcd|\x99\x03\xd3ct\
\x9b\xbd\x91\xcf\xf3\xde\xe8o\xf5B\x9e\xf5B\xa9\xf1\x1eT\xc6\xc0\x16p\xff-\
\xb7\x13\xeb\x88  \x1b\x8e\xf9\xf2Nu\xdc0\xc0kG\xc4\x8e\x0c\xf3\xe8{k\xdd\
\xfc\xd4\xf2[\x9co\x9d\xa6\xf0\x9e\xe1\xbd\x9a\xe6\xd5\xeb\x10\xb9\xbd>\xf2\
\xf9&Lg\x15\xa2!\xf8\xd5\xc3\x8f2\x1e\xdfN+\xcd\xa46\xceW_yX\xce\x7fh\x00\
\x00\xc7\x1f\x92\x93\xb5\x1a\xbf{\xfa\xca\x92\x9c]9\xc7Z\xa7\xc5\xe8\xb8\xa1\
ueK\x08\xa5\x90\xa5\x9b\xfd\x02ZW{\xe2\x8f\x1e\xba\x97\xa3\xd3O\xf2\x8d3\xdf\
fl\x94\xbf\xbf\xd1\xdf\xc6\xbb\x02\x008\xfe\xb0\xfcYy\xd0\x7f\xed\xed\x95e.\
\xaf\xafR\x1a\x85\xf6\xeaf\x12o\x89\xff\xcc\xf6 \xda\xcb0=\x1bR+\xed\xe3\x97\
_|\x94R\xc5\xff\xe7\xc9/\xc8\xaf\xdc\xa8\xfd]\x03\x00\xbc\xf6\xa8|\xc9\xe9\
\xe2\x07\xef6\xdb\xe4A\x81\xcb\xa0\xc8z\x8b\x93\xf3\xbd\xf6\xda*\xdb]\x81\
\xd1\xc9\x80\xbf}\xe3\x9b8U\xac\x0fT\xf9\xecnl\xf7\x05\x00\xa0Z\xe1\xefr+dV(\
\x8d@\xda\xf8\xe05\xb6\x03\xda@=Mp^\xa8V\xf9\xeen\xcf\x86\xfa\x06\x10Vx\xeeZ\
\xbf\xb4\x07\x92\x1f\x03\xd0]\x85\xf2\xd8\xf5\xf7q\xc4\xbf\xee\xd6n\xdf\x00\
\xfe\xfdg\xe4\x9c\xd6X\x80x\x04\x92U\xe8vac\x03\xd67z\xfd\xce2\xc4[6\xca\x06\
^\xdf\xad\xdd\xbe\x9e\x8d\x96c\xd3\\m\xb8Z}\x19\\\x0c\xcbK\\\xdf\xe7\x0b\xe0\
\xa1\xde\x82=\x01\x8c\x0c+\xa7*rf\xb76\xfb\n\xf0\x95\xf4\x8fK\xc7\xf6\xfe\
\x15o\xe9\x8b\xac\x0e$d\xd6\xe3\x8a\x9e\xf6 \x80\xf06\xc5@\x14p\xcb\xc0\x08\
\x07\xcf>h&\xdf\xba}?\x9f\xe2\xeanl\xf6\x15`H\x8f\xc9\x97\xe4)\xd6\xf5:\xae\
\xeaX/\xd6\xb8\x12,\x90\xb9.\xe5\x95\x1aj\xa5L\x92$x\xbf9%\r\xee>\x84\xfb~\
\xbc\xde\xe9t\x98\x99\x99\xa1\\.\x93\xa6)cW&YYYa\xa3\xd8 !\xe9\xb7\xb9\xfe\
\x02\x88\x08ccc\xac\xac\xac\xd0\xedvQJQ\xadV\x99\x9a\x9a\xa2R\xa9\xd0l6\xc9\
\xf3\xfc\xba\x07\xfaP\xfa\n\x10E\x91ZZZbbb\x82\xb9\xb99\x8c1\\\xbe|\x99+W\
\xae\xd0j\xb5\xe8t:}\x15\x0f}\x06H\x92D\xa6\xa7\xa7I\xd3\x94S\xa7N\x91\xa6)Q\
\x14a\x8c!\x8ec\xac\xb5\xb4\xdb\xed~\x9a\xec/\xc0\xda\xda\xdaF\x9e\xe7C\xc3\
\xc3\xc3\x1c:t\x08\xa5\x14\x9dN\x87\xa5\xa5%\xda\xed6n\xf3W\x0b\x80R\xcaYk\
\x17wk\xb3\xaf\x00\xa7N\x9d\xfa\x83\xe9\xe9\xe9gfffh\xb5ZdYF\x9e\xe7(\xa5\
\xe8v\xbb\x14E\x01\xf4r\xa5\xd3\xe9\xfc\xe3\xd3O?\xbdk\x80\xbe\xfeG\x06\xf0\
\xd8c\x8f\xfd\x85\xd6\xfa7K\xa5\x12q\x1c\x13\x86!J\xa9\xf7a\xb2,\xc39\xf7ZQ\
\x14\x0f\xbc\xf0\xc2\x0b\xd9n\xed\xf5m+q\xad\x1c9r\xe4+\xce\xb9\xdfo4\x1a\
\xadF\xa3\xc1\xf2\xf22KKK4\x9bMZ\xad\x96s\xce\xfdi\x10\x04\x0f\xf7C<\xd0s\
\xe7\x0e\xab\xdaN\r\xc3\xf0\xb01\xc6W\xabU\x19\x1c\x1c\x940\x0cE)\xf5\x87\
\xdb\xbd\x7f\xbbz\xb6\x1bBjK\xabO\x9f>\xad\xa3(z\xff4sqqQ\x01\xd4\xebu\xb5\
\xf5\xa6\'\x9f|\xf2\x13\xadV\xeb3\xde\xfb\xb1R\xa9t\xfc\xe8\xd1\xa3\xc7\x1e\
\x7f\xfc\xf1\xce\xd6kj\xb5\x9a\x00\xec\xdb\xb7O\x00\xe6\xe6\xe6d~~^\xdey\xe7\
\x1d\xff\xc4\x13Ol\x9ds\x7f\xac\xd0\xff\r@\xd1\x0b3}\xee\xdc9\x1d\x04\x81ZXX\
0\xf5z\xdd\xd4\xebu-"z}}]\xb7\xdbm\xad\x94\xd2\xd6Z\x95\xa6\xa9.\x8aB9\xe7\
\x94s\xeeG\x80\x8c1\x02\x10\xc7\xb1\x0f\x82@\x82 \x90J\xa5\xe2E\xc4\x0f\x0e\
\x0e\xfa\x91\x91\x11o\x8c\xf1\x07\x0f\x1etq\x1c\xbbZ\xad\xe6\xf3<\x97;\xef\
\xbc\xd3\x03~\x13\xe2G\x04\xffO\xb3\x90\x9a\x9f\x9f\x0f\xf6\xee\xddk.\\\xb8\
\x10$I\xa2\xdf|\xf3Ms\xe6\xcc\x19}\xf5\xeaU\xd3\xe9t\x82n\xb7\x1bZk\x83<\xcf\
C\xe7\\p\xad\x8a\x88\xf1\xde\x9b \x08\x94\x88\xbc\x9fgJ)_\x14\x85h\xad\x9d\
\xd6\xba\xd0Z;cLa\x8c)\xa2(\xb2q\x1c\xdbR\xa9T\x8c\x8f\x8f\x17\x87\x0e\x1dr\
\xb3\xb3\xb3\xfe\xc0\x81\x03\xae(\nW\xa9T\x8a\xb9\xb99\xbb]\x00\x05\xe8#G\
\x8e\x98\xb3g\xcf\x86\x0b\x0b\x0b\xfa\xd5W_\r.]\xba\x14...\x06\xf5z=L\x92$\
\x06"\x11\x89E$\x06b\x11\x89\x80\x08\x08\xb7T\xc3\xf5\xf3g\x07\x14\x9b5\x07r\
\xa5T\x0ed\xd7\xda8\x8e\xb3J\xa5\x92_\xbat\xc9\x8e\x8d\x8d\xd9\xbb\xee\xba\
\xcb\xdes\xcf=nzzZ\xcd\xcd\xcd}\xc0\x0b?i\x16\x92g\x9f}\x96\x0b\x17.\x00\xb0\
\xb6\xb6\xa6\x93$\xd1Y\x96\x19cL\x18\x04\xc15\xf1%\x11)\x01e\x11)\x03U`\x00\
\x18\x14\x91!\x11\x19\x16\x91\x11\x11\xd9\xb3YGEd\x18\x18\x02\x06\x81\x01\
\x11\xa9\x02U\x11)\x8bH\xd9{_\xd6Z\x97\xd24\x8d:\x9dN\xb8\xba\xba\x1a4\x1a\r\
\r0??\xff\x01\xa1?1\x846\x13\xa88q\xe2\x84\x9a\x9d\x9dUq\x1c\xab\x8b\x17/\
\x16\x0b\x0b\x0bjxx\x98V\xab%\xd6Z)\x8a\xc29\xe7\n\xe7\\\xee\xbd\xcf\xbc\xf7\
\x91\x88D"\x12\x8aH "\xc1\xe6@\x89R\xca)\xa5,Ph\xads\xa5\x94\xd5Z\xe7\xc6\
\x98\\k\x9d\x07A\x90W\xab\xd5|``\xc0\x8e\x8f\x8f\xe7SSSv\xef\xde\xbd\xb6\\.\
\xe7\xfb\xf6\xed\xb3sss\x8e\x1d\xe4\x80\x00nqqQ\xa2(rw\xdf}\xb7v\xce\x99\xd1\
\xd1QS\xaf\xd7C\xe7\x9ci6\x9bA\x92$&\xcb2\x93\xa6i\xa0\x942y\x9e\x07EQ\x18\
\xe7\x9cq\xce\x19\xef\xbd\x16\x11\xa5\x94\x12\xad\xb5\xd7Z{c\x8c\x0b\x82\xc0\
\x05A\xe0\x80"\x8a"\x17E\x91\xabV\xabE\xb5Zu\xde{;<<l\xf7\xef\xdf\xef\xc6\
\xc6\xc6\xdc\xe1\xc3\x87\xdd\xdc\xdc\x9cSJ\xc9\x7f\x9ft\xfe\x0b\xa6&\x926\
\xd8\x8d\xfa\xa5\x00\x00\x00\x00IEND\xaeB`\x82\xb6>\x9f:'
