/***************************************************************************
 *   Copyright (C) 2007 by Κωνσταντίνος Σμάνης   *
 *   kon.smanis@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation                                              *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301 USA                                             *
 ***************************************************************************/

#include "config.h"

configuration Config::settings;

Config::Config()
{
	read();
}

void Config::read()
{
	QSettings application_settings;
//GENERAL
	//general
	settings.menu = application_settings.value( "general/menu", true ).toBool();
	settings.completion = application_settings.value( "general/completion", 0 ).toInt();
	settings.autobackup = application_settings.value( "general/autobackup", true ).toBool();
	//colors
	settings.default_color = application_settings.value( "general/default_color", QColor( Qt::green ) ).value<QColor>();
	//toolbar
	settings.size = application_settings.value( "general/size", 32 ).toInt();
	settings.style = application_settings.value( "general/style", 0 ).toInt();
//PATHS
	settings.menulst = application_settings.value( "paths/menulst", MENU_LST_PATH ).toString();
	settings.devicemap = application_settings.value( "paths/devicemap", DEVICE_MAP_PATH ).toString();
	settings.mtab = application_settings.value( "paths/mtab", MTAB_PATH ).toString();
//LANGUAGE
	settings.language = application_settings.value( "language/language" ).toString();
//WINDOW
	settings.window_size = application_settings.value( "window/size" ).toSize();
	settings.window_geometry = application_settings.value( "window/geometry" ).toByteArray();
	settings.window_state = application_settings.value( "window/state" ).toByteArray();
//OTHER
	settings.firstrun = application_settings.value( "other/firstrun", true ).toBool();

	application_settings.deleteLater();
}
void Config::write()
{
	QSettings application_settings;
//GENERAL
	//general
	application_settings.setValue( "general/menu", settings.menu );
	application_settings.setValue( "general/completion", settings.completion );
	application_settings.setValue( "general/autobackup", settings.autobackup );
	//colors
	application_settings.setValue( "general/default_color", settings.default_color );
	//toolbar
	application_settings.setValue( "general/size", settings.size );
	application_settings.setValue( "general/style", settings.style );
//PATHS
	application_settings.setValue( "paths/menulst", settings.menulst );
	application_settings.setValue( "paths/devicemap", settings.devicemap );
	application_settings.setValue( "paths/mtab", settings.mtab );
//LANGUAGE
	application_settings.setValue( "language/language", settings.language );

	application_settings.deleteLater();
}
void Config::writeValue( const QString key, const QVariant value )
{
	QSettings application_settings;

	application_settings.setValue( key, value );

	application_settings.deleteLater();	
}
