/***************************************************************************
 *   Copyright (C) 2007 by Κωνσταντίνος Σμάνης   *
 *   kon.smanis@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation                                              *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301 USA                                             *
 ***************************************************************************/

#ifndef DATA_H
#define DATA_H

#ifndef MENU_LST_PATH
	#define MENU_LST_PATH "/boot/grub/menu.lst"
#endif
#ifndef DEVICE_MAP_PATH
	#define DEVICE_MAP_PATH "/boot/grub/device.map"
#endif
#ifndef MTAB_PATH
	#define MTAB_PATH "/etc/mtab"
#endif

#include <QString>

class GRUBItem
{
public:
	inline QString title() const { return TITLE; };
	inline QString root() const { return ROOT; };
	inline QString kernel() const { return KERNEL; };
	inline QString initrd() const { return INITRD; };
	inline QString chainLoader() const { return CHAINLOADER; };
	inline bool quiet() const { return QUIET; };
	inline bool saveDefault() const { return SAVEDEFAULT; };
	inline bool makeActive() const { return MAKEACTIVE; };
	inline bool lock() const { return LOCK; };

	inline void setTitle( QString title ) { TITLE = title; };
	inline void setRoot( QString root ) { ROOT = root; };
	inline void setKernel( QString kernel ) { KERNEL = kernel; };
	inline void setInitrd( QString initrd ) { INITRD = initrd; };
	inline void setChainLoader( QString chainLoader ) { CHAINLOADER = chainLoader; };
	inline void setQuiet( bool option ) { QUIET = option; };
	inline void setSaveDefault( bool option ) { SAVEDEFAULT = option; };
	inline void setMakeActive( bool option ) { MAKEACTIVE = option; };
	inline void setLock( bool option ) { LOCK = option; };

	void clear() { TITLE = QString(); ROOT = QString(); KERNEL = QString(); INITRD = QString(); CHAINLOADER = QString(); QUIET = false; SAVEDEFAULT = false; MAKEACTIVE = false; LOCK = false; };

	GRUBItem() { clear(); };
private:
	QString TITLE;
	QString ROOT;
	QString KERNEL;
	QString INITRD;
	QString CHAINLOADER;
	bool QUIET;
	bool SAVEDEFAULT;
	bool MAKEACTIVE;
	bool LOCK;
 };

class GRUBSettings
{
public:
	inline QString splashImage() const { return SPLASHIMAGE; };
	inline int default_entry() const { return DEFAULT_ENTRY; };
	inline int fallback() const {return FALLBACK; };
	inline int timeout() const { return TIMEOUT; };
	inline bool hiddenMenu() const { return HIDDENMENU; };
	inline QString color() const { return COLOR; };
	inline QString password() const { return PASSWORD; };

	inline void setSplashImage( QString splashimage ) { SPLASHIMAGE = splashimage; };
	inline void setDefault( int default_entry ) { DEFAULT_ENTRY = default_entry; };
	inline void setFallback( int fallback ) { FALLBACK = fallback; };
	inline void setTimeout( int timeout ) { TIMEOUT = timeout; };
	inline void setHiddenMenu( bool option ) { HIDDENMENU = option; };
	inline void setColor( QString color ) { COLOR = color; };
	inline void setPassword( QString password ) { PASSWORD = password; };

	void clear() { SPLASHIMAGE = QString(); DEFAULT_ENTRY = -1; FALLBACK = -1; TIMEOUT = -1; HIDDENMENU = false; COLOR = QString(); PASSWORD = QString(); };

	GRUBSettings() { clear(); };
private:
	QString SPLASHIMAGE;
	int DEFAULT_ENTRY;
	int FALLBACK;
	int TIMEOUT;
	bool HIDDENMENU;
	QString COLOR;
	QString PASSWORD;
 };

class Device
{
public:
	inline QString device() const { return DEVICE; };
	inline QString partition() const { return PARTITION; };
	inline QString grubDevice() const { return GRUBDEVICE; };
	inline QString grubPartition() const { return GRUBPARTITION; };
	inline QString mountpoint() const { return MOUNTPOINT; };
	inline QString uuid() const { return UUID; };

	inline void setDevice( QString device ) { DEVICE = device; };
	inline void setPartition( QString partition ) { PARTITION = partition; };
	inline void setGRUBDevice( QString grubdevice ) { GRUBDEVICE = grubdevice; };
	inline void setGRUBPartition( QString grubpartition ) { GRUBPARTITION = grubpartition; };
	inline void setMountPoint( QString mountpoint ) { MOUNTPOINT = mountpoint; };
	inline void setUuid( QString uuid ) { UUID = uuid; };

	void clear() { DEVICE = QString(); PARTITION = QString(); GRUBDEVICE = QString(); GRUBPARTITION = QString(); MOUNTPOINT = QString(); UUID = QString(); };

	Device() { clear(); };
	Device( QString partition, QString device, QString mountpoint ) { clear(); setPartition( partition ); setDevice( device ); setMountPoint( mountpoint ); };
private:
	QString DEVICE;
	QString PARTITION;
	QString GRUBDEVICE;
	QString GRUBPARTITION;
	QString MOUNTPOINT;
	QString UUID;
 };

#endif
