#!/usr/bin/python2

## samba-share.py - Contains the startup script for system-config-samba
## Copyright (C) 2004 Red Hat, Inc.
## Copyright (C) 2004 Brent Fox <bfox@redhat.com>

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import sys
import getopt
import os
import sambaBackend
import sambaUserData
import sambaParser

##
## I18N
##
from rhpl.translate import _, N_
import rhpl.translate as translate
translate.textdomain ("system-config-samba")

TRUE = 1
FALSE = 0


class sambaCli:
    def __init__(self):
#        self.sambaBackend = sambaBackend.SambaBackend()
        self.sambaParser = sambaParser.SambaParser(self)

    def addShare(self, dir, perm, hosts):
        if dir == "":
            self.usage()
            return

        try:
            os.listdir(dir)
        except:
            print (("%s is not a valid directory." % dir))
            return

        if perm == "":
            print (("Please specify a permission"))
            self.usage()
            return

        if perm != "ro" and perm != "rw":
            print (("%s is not a valid permission." % perm))
            self.usage()
            return

        if hosts == "":
            print (("Please specify an IP."))
            self.usage()
            return

        sambaDataObject = sambaData.sambaData()
        sambaDataObject.set_directory(dir)
        sambaDataObject.set_hosts(hosts)
        sambaDataObject.set_permissions(perm)
        
        if async != None:
            sambaDataObject.set_sync("async")
        else:
            sambaDataObject.set_sync("sync")

        self.sambaBackend.addEntry(sambaDataObject)
        self.sambaBackend.writeFile(self.sambaBackend.getEntries())
        self.sambaBackend.startSamba()
        self.sambaBackend.exportFs()    
        
    def usage(self):
        print ("""Usage: samba-share [OPTION...]
       --help             Print out this message.
       --dir <path>       Specify directory.
       --perm <perm>      "ro" for read only.  "rw" for read/write.
       --list             List the existing SAMBA shares.""")


    def listShares(self):
        self.sambaParser.printList()

def useCliMode(dir, perm, hosts):
    sambaCli = sambaCli(dir, perm, hosts)


if os.getuid() > 0 or os.geteuid() > 0:
    print _("You must be root to run samba-share.")
    import sys
    sys.exit(0)

dir = ""
perm = ""
hosts = ""
async = None

try:
    args, opts = getopt.getopt(sys.argv[1:], "dph:la", ["help", "dir=", "perm=", "ip=", "list", "async"])
except getopt.GetoptError, exc:
    print exc.msg
    sambaCli().usage()
    sys.exit(2)

for (arg, value) in args:
    if arg in ("-h", "--help"):
        sambaCli().usage()
        sys.exit(1)
    if arg in ("-l", "--list"):
        sambaCli().listShares()
        sys.exit(1)
    if arg in ("-d", "--dir"):
        dir = value
    if arg in ("-p", "--perm"):
        perm = value
    if arg in ("-i", "--ip"):
        hosts = value
    if arg in ("-a", "--async"):
        async = value

sambaCli().addShare(dir, perm, hosts)
