/*
 * find all usb-device interfaces, and make them available in a single string
 *
 * Copyright (C) 2008 Kay Sievers <kay.sievers@vrfy.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdint.h>

#define USB_DT_DEVICE			0x01
#define USB_DT_INTERFACE		0x04

static int devinfo(const char *syspath)
{
	char filename[1024];
	int fd;
	ssize_t size;
	unsigned char buf[18 + 65535];
	unsigned int pos;
	struct usb_interface_descriptor {
		u_int8_t	bLength;
		u_int8_t	bDescriptorType;
		u_int8_t	bInterfaceNumber;
		u_int8_t	bAlternateSetting;
		u_int8_t	bNumEndpoints;
		u_int8_t	bInterfaceClass;
		u_int8_t	bInterfaceSubClass;
		u_int8_t	bInterfaceProtocol;
		u_int8_t	iInterface;
	};

	strcpy(filename, "/sys");
	strcat(filename, syspath);
	strcat(filename, "/descriptors");
	fd = open(filename, O_RDONLY);
	if (fd < 0) {
		fprintf(stderr, "error opening USB device 'descriptors' file\n");
		return -1;
	}
	size = read(fd, buf, sizeof(buf));
	close(fd);
	if (size < 18 || size == sizeof(buf))
		return -1;

	printf("ID_USB_INTERFACES=:");
	pos = 0;
	while (pos < sizeof(buf)) {
		struct usb_interface_descriptor *desc;

		desc = (struct usb_interface_descriptor *) &buf[pos];
		if (desc->bLength < 3)
			break;

		if (desc->bDescriptorType == USB_DT_INTERFACE)
			printf("%02x%02x%02x:", desc->bInterfaceClass, desc->bInterfaceSubClass, desc->bInterfaceProtocol);
		pos += desc->bLength;
	}
	printf("\n");
	return 0;
}

int main(int argc, char *argv[])
{
	const char *devpath = argv[1];

	if (devpath == NULL) {
		fprintf(stderr, "Usage: usbdev_id <devpath>\n");
		return 1;
	}
	devinfo(devpath);
	return 0;
}
