/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_evcontain.h>
//#include <vdkb2/vdkb_labelbutton.h>
#include <vdkb2/vdkb_form.h>
#include <vdk/vdk.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_prjman.h>
#include <vdkb2/vdkb_objinspect.h>
#include <stdlib.h>
#include <vdkb2/vdkb_frame.h>
#include <vdkb2/vdkb_evbox.h>
#include <vdkb2/vdkb_fixed.h>
#include <vdkb2/vdkb_widpopmenu.h>
#include "./pixmaps/shadow.xpm"
/*
================================
symbolic constants to templatize
a bit
================================
*/
// for methods and other stuff
#define CLASS VDKBFrame
// put here vdk class name string
#define VDK_CLASS "VDKFrame"
// put here vdk class name
#define VDK_ANCESTOR  VDKFrame
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "frame"
extern char* wi_widget_prompts[];
static char buff[128];
static char *shadows[] =
{
"shadow_none","shadow_in","shadow_out","shadow_etched_in",
"shadow_etched_out",0
};
static char *aligns[] =
{
"l_justify","c_justify","r_justify",0
};

int CLASS::Counter = 0;

/*
 properties
 */
char* vdkframe_props[] =
{
LABEL,
SHADOW,
ALIGN,
0
};

DEFINE_EVENT_LIST(CLASS,VDKBEventContainer);
DEFINE_SIGNAL_LIST(CLASS,VDKBEventContainer);


/*
 */
bool
CLASS:: DelBox(VDKObject* sender)
{
  // destroy inner gtk+ placeholder widget
  gtk_widget_destroy(container);
  // call ancestor delete box
  VDKBEventContainer::DelBox(sender);
  // notify to inspector that object was deleted
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      VDKBProjectManager* prjman =
	dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
      if(prjman && prjman->objInspector)
	prjman->objInspector->SetActive(NULL);
    }
return true;
}

/*
 */
bool
CLASS::SetBoxSize(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      ownerform->SetBoxSize(NULL);
    }
  return true;
}
//===========================================
/*
 */
CLASS::CLASS(char* name, VDKForm* owner):
  VDKBEventContainer(name,owner)
{
  Counter++;
  VDKBObject::object = this;
  VDKBEventContainer::mode = mode;
  Init();
}

/*
 */
CLASS::CLASS(char* name,VDKBEventContainer* outer):
    VDKBEventContainer(name,outer->Owner())
{
  VDKBObject::object = this;
  Counter++;
  outerbox = outer;
  Init();
 }
/*
 */
void
CLASS::Init()
{
  int t;
  // add  frame properties
  // names. (Others props are prepended  by VDKBObject constructor)
  for(t=0; vdkframe_props[t]; t++)
    proplist.add(VDKBProperty(vdkframe_props[t]));
  if(name)
    SetPropValue(LABEL,name);
  AddBox(name);
  //AddCanvas(w,h);
  // makes a pop menu
  popmenu = new VDKBContainerPopMenu(this);
  setsize = new VDKMenuItem(popmenu,_(wi_widget_prompts[19]));
  selectparent =  new VDKMenuItem(popmenu,_(wi_widget_prompts[20]));
  SignalConnect(selectparent,"activate",
		&CLASS::SelectParentContainer);
  delBox = new VDKMenuItem(popmenu,_(wi_widget_prompts[30]));
  SignalConnect(delBox,"activate",&CLASS::DelBox);
  SignalConnect(setsize,"activate",&CLASS::SetBoxSize);
  CONNECT_COMMON_EVENTS;
  /* assign this as parent so this can receive signals  */
  popmenu->Parent(this);
  popmenu->Setup();
  /*
    better add it to owner, so will be surely
    destroyed even if never popped
  */
  Owner()->AddItem(popmenu);
  // plm patch
  SetSize(100,100);
}
/*
 */
void
CLASS::AddBox(char* name)
{
  container = gtk_frame_new(NULL/*name*/);
  gtk_container_add(GTK_CONTAINER(widget),container);
  gtk_widget_show(container);
}

/*
extra args unused
 */
void
CLASS::AddWidget(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
  if(BinCheck(wid))
    {
      // adding a nested box set border width to 10
      gtk_container_add(GTK_CONTAINER(container),wid->Widget());
      VDKBObject* vdkbobj = dynamic_cast<VDKBObject*>(wid);
      if(vdkbobj)
	{
	  VDKBEventBox* box = dynamic_cast<VDKBEventBox*>(vdkbobj);
	  if(box)
	    {
	      box->BorderWidth(0);
	      box->SetPropValue(BORDERWIDTH,"0");
	    }
	}
      VDKBEventContainer::Add(wid,l_justify,expand,fill,padding);
    }
  else
    wid->Destroy();
}
/*
extra args used
 */
void
CLASS::Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
AddWidget(wid);
}
/*
  This method is called by global MakeWidget() in vdkb_design.cc
  MakeWidget() scans a table that maps class id's with each
  static MakeWidget() for each class. Class id's are generated
  during clicks on widget palette.
  On return:
  0 - successfull
  1 - unsupported widget
  2 - target is not a container
  3 - no active widget
*/
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable frame counter
  // to ensure unicity
  int result = 0;
  CLASS* frame = NULL;
  VDKBEventBox *box1 = NULL;
  if(owner->Active)
    {
      for(sprintf(buff,"%s%d",VDK_WIDGET,CLASS::Counter);
	  owner->ChildWithName(buff)!= (VDKObject*) NULL;
	  CLASS::Counter++)
	sprintf(buff,"%s%d",VDK_WIDGET,CLASS::Counter);
      frame = new CLASS(buff,owner);
      // add a box to frame
      for(sprintf(buff,"VBox%d",VDKBEventBox::Counter);
	  owner->ChildWithName(buff) != (VDKObject*) NULL;
	  VDKBEventBox::Counter++)
	sprintf(buff,"VBox%d",VDKBEventBox::Counter);
      box1 = new VDKBEventBox(buff,frame);
      box1->SetPropValue(JUSTIFY_INTERNAL,"l_justify");
      frame->AddWidget(box1,l_justify,true,true,true,true);
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(owner->Active);
      if(container)
	{
	  if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      frame->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      frame->SetPropValue(EXPAND_INTERNAL,buff);
	      // others than justify and flag unuseful
	      container->AddWidget(frame,int(event->x),
				   int(event->y),
				   true,true,true);
	    }
	  else
	    container->AddWidget(frame);
	  frame->outerbox = container;
	}
      else if(! owner->Active->AddToParent(frame,ev))
	// target isn't a container
	  result =  2;
    }
  else
    // no active widget
    result = 3;
  // 0 on success
  if(result && frame)
     frame->Destroy();
 return result;
}
////////////////////////////////////////////////////////////////////
/*
 */
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  VDKBEventContainer::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s\"%s\";",PROP_LABEL, (char*) GetProp(LABEL));
  fprintf(fp,"\n\t%s%s;", PROP_SHADOW,(char*) GetProp(SHADOW));
  fprintf(fp,"\n\t%s%s;", PROP_ALIGN,(char*) GetProp(ALIGN));
}

char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char shadow[32];
  char temp[256];
  char bw[16];
  char label[128];
  char arg[128];
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return NULL;
  else
    source = new char[1024];
  strcpy(shadow,"shadow_etched_in");
  bool nls_support = parser.CheckNLSSupport();
  // get label
  if(parser.GetParam(label,buffer, PROP_LABEL) && strcmp(label,NIHIL_PROP))
    {
      if(nls_support)
	sprintf(temp,"\n%s = new %s(this,_(\"%s\"),v_box,%s);"
	      ,obj_name,VDK_CLASS,label,shadow);
      else
	sprintf(temp,"\n%s = new %s(this,\"%s\",v_box,%s);"
	  ,obj_name,VDK_CLASS,label,shadow);
      strcpy(source,temp);
    }
  else
    {
      sprintf(temp,"\n%s = new %s(this,NULL,v_box,%s);"
	  ,obj_name,VDK_CLASS,shadow);
      strcpy(source,temp);
    }
  // get shadow
  if(parser.GetParam(arg,buffer,PROP_SHADOW) && strcmp(arg,NIHIL_PROP))
    {
      int ndx = atoi(arg);
      ndx = (ndx >= 0) && (ndx <= 4) ? ndx : 0;
      sprintf(temp,"\n%s->Shadow = %s;", obj_name,shadows[ndx]);
      strcat(source,temp);
    }
  // get align
  if(parser.GetParam(arg,buffer,PROP_ALIGN) && strcmp(arg,NIHIL_PROP))
    {
      int ndx = atoi(arg);
      ndx = (ndx >= 0) && (ndx <= 2) ? ndx : 0;
      sprintf(temp,"\n%s->Align = %s;",
	      obj_name,aligns[ndx]);
      strcat(source,temp);
    }
  // get size
  VDKPoint size = parser.Size(buffer);
  if(size.X() > 0 || size.Y() > 0)
    {
      sprintf(temp,"\n%s->SetSize(%d,%d);",obj_name,size.X(),size.Y());
      strcat(source,temp);
    }
  if(strcmp(obj_parent,NIHIL_PROP))
    sprintf(temp,"\n%s->Add(%s",obj_parent,obj_name);
  else
    sprintf(temp,"\nAdd(%s",obj_name);
  strcat(source,temp);
  // prepares arguments for add widget to container
  char justify[16],expand[16],fill[16],padding[16];
  if(parser.GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
     parser.GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
     parser.GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
     parser.GetParam(padding,buffer,PROP_PADDING_INTERNAL))
    {
      sprintf(temp,",%s,%s,%s,%s);",
	      justify,expand,fill,padding);
      strcat(source,temp);
    }
  else
    {
      sprintf(temp,");");
      strcat(source,temp);
    }

  if(parser.GetParam(bw,buffer,PROP_BORDERWIDTH) &&
     strcmp(bw,NIHIL_PROP))
    {
      sprintf(temp,"\n%s->BorderWidth(%s);",obj_name,bw);
      strcat(source,temp);
    }
  return source;
}
/*
 */
bool
CLASS::CreateWidget(VDKBGuiForm* owner, char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  CLASS* box;
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return false;
  // get mode and size
  VDKPoint size = parser.Size(buffer);
  // get packing args
  int justification = l_justify;
  int expand=0,fill=0,padding=0;
  int bw; // border width
  char arg[32];
  if(parser.GetParam(arg,buffer,PROP_JUSTIFY_INTERNAL))
     justification = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_EXPAND_INTERNAL))
    expand = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_FILL_INTERNAL))
    fill = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_PADDING_INTERNAL))
    padding = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_BORDERWIDTH) &&
     strcmp(arg,NIHIL_PROP))
    bw = atoi(arg);
  else
    bw = -1;
  // no parent, widget will be added to owner form innerbox
  if(!strcmp(obj_parent,NIHIL_PROP))
    {
      box = new CLASS(obj_name,owner->InnerBox());
      owner->AddWidget(box,justification,expand,fill,padding);
    }
  // get parent container address
  else
    {
      VDKObject* p = owner->ChildWithName(obj_parent);
      VDKBEventContainer* container = p ?
	dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
      if(container)
	{
	  box = new CLASS(obj_name,container);
	  container->AddWidget(box,justification,expand,fill,padding,true);
	  box->outerbox = container;
	}
      else
	// FIX ME: user warning
	return false;
    }
  // call ancestor to set common properties
  VDKBObject::CreateWidget(box,buffer,parser);
  if(size.X() > 0 || size.Y() > 0)
    box->ObjectFromVDK()->SetSize(size.X(),size.Y());
  // label
  if(parser.GetParam(arg,buffer, PROP_LABEL) &&
     strcmp(arg,NIHIL_PROP) )
    {
      box->SetPropValue(LABEL,arg);
      gtk_frame_set_label(GTK_FRAME(box->container),arg);
    }
  else
    {
      box->SetPropValue(LABEL,NIHIL_PROP);
      gtk_frame_set_label(GTK_FRAME(box->container),NULL);
    }

  // shadow
  if(parser.GetParam(arg,buffer,PROP_SHADOW) &&
     strcmp(arg,NIHIL_PROP))
    {
      box->SetPropValue(SHADOW,arg);
      int sh = atoi(arg);
      gtk_frame_set_shadow_type(GTK_FRAME(box->container),
				(GtkShadowType) sh);
    }
  // align
  if(parser.GetParam(arg,buffer,PROP_ALIGN) &&
     strcmp(arg,NIHIL_PROP))
    {
      box->SetPropValue(ALIGN,arg);
      int sh = atoi(arg);
      gtk_frame_set_label_align(GTK_FRAME(box->container),
				0.0+0.5*sh,0.0);
    }
  if(bw >= 0)
    {
      char local[16];
      box->BorderWidth(bw);
      sprintf(local,"%d",bw);
      box->SetPropValue(BORDERWIDTH,local);
    }
return true;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
This is called by object inspector when a widget
is selected by user, thus to allow widget to set
his own property controls.
 */
VDKObjectContainer*
CLASS::ExtraWidget(VDKBObjectInspector* isp)
{
  VDKBox* tframe = dynamic_cast<VDKBox*>(VDKBEventContainer::ExtraWidget(isp));
  if(!tframe)
    return NULL;
  VDKTable *table = new VDKTable(inspector,2,2);
  VDKBox* box = new VDKBox(inspector,h_box);
  set = new VDKCustomButton(inspector,(const char**) shadow_xpm,NULL);
  set->Relief = (GtkReliefStyle) 2;
  set->SetTip(_(wi_widget_prompts[33]));
  box->Add(set,l_justify,false,false,0);
  set->Parent(this);
  SignalConnect(set,"clicked",&CLASS::OnSetShadowAndAlign);
  box->Add(new VDKLabel(inspector,_(wi_widget_prompts[32]),GTK_JUSTIFY_RIGHT),l_justify,true,true,5);
  table->AddToCell(box,0,0);
  // label
  char* lbl = (char*) GetProp(LABEL);
  bool isNihil = !strcmp((char*) GetProp(LABEL),NIHIL_PROP);
  label = new VDKEntry(inspector,0,isNihil ? NULL : lbl);
  label->SetSize(80,-1);
  table->AddToCell(label,0,1);
  label->Parent(this);
  SignalConnect(label,"activate",&CLASS::OnSetLabel);
  // shadow
  shadow = new VDKCombo(inspector,NULL);
  shadow->SetSize(80,-1);
  StringList sl;
  int t = 0;
  for(;shadows[t];t++)
    sl.add(VDKString(shadows[t]));
  shadow->PopdownStrings = sl;
  table->AddToCell(shadow,1,0);
  int r = atoi(GetProp(SHADOW));
  shadow->SelectItem(r);
  // align
  align = new VDKCombo(inspector,NULL);
  align->SetSize(80,-1);
  StringList sa;
  for(t=0;aligns[t];t++)
    sa.add(VDKString(aligns[t]));
  align->PopdownStrings = sa;
  r = atoi(GetProp("Align"));
  align->SelectItem(r);
  table->AddToCell(align,1,1);
  tframe->Add(table,l_justify,false,false,false);
  return tframe;
}

/*
 */
bool
CLASS::OnSetLabel(VDKObject*)
{
  if(strlen(label->Text)>0)
    {
    sprintf(buff,"%s",(char*) label->Text);
    gtk_frame_set_label(GTK_FRAME(container),buff);
    }
  else
    {
      sprintf(buff,NIHIL_PROP);
      gtk_frame_set_label(GTK_FRAME(container),"");
    }
  SetPropValue(LABEL,buff);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS:: OnSetShadowAndAlign(VDKObject*)
{
  int sel = shadow->Selected;
  sprintf(buff,"%d", sel >= 0 ? sel : 0);
  SetPropValue(SHADOW,buff);
  int shd = atoi(buff);
  gtk_frame_set_shadow_type(GTK_FRAME(container),(GtkShadowType) shd);

  sel = align->Selected;
  sprintf(buff,"%d", sel >= 0 ? sel : 0);
  SetPropValue(ALIGN,buff);
  int alg = atoi(buff);
  gtk_frame_set_label_align (GTK_FRAME(container),0.0+alg*0.5,0.0);
  inspector->FormNeedToBeChanged();
  return true;
}





