/*  beef - Flexible Brainfuck interpreter
 *  Copyright (C) 2005-2007  KiyuKo <eof AT kiyuko DOT org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *  Homepage: http://www.kiyuko.org/beef
 */

#include "beef.h"

void eval (struct instruction *current, char on_eof)
{
  long i;

  /* Continue as long as the istruction is not the last */
  while (current->type != ']') {
    switch (current->type) {

      case '>':
        /* Repeat current->quantity times */
        for (i = 0; i < (current->quantity); i++) {
          if (tape->next == NULL) {
            /* Create new cell if necessary */
            tape->next = new_cell ();
            (tape->next)->previous = tape;
          }
          /* Move forward one cell */
          tape = tape->next;
        }
        break;

      case '<':
        /* Repeat current->quantity times */
        for (i = 0; i < (current->quantity); i++) {
          if (tape->previous == NULL) {
            /* Create new cell if necessary */
            tape->previous = new_cell ();
            (tape->previous)->next = tape;
          }
          /* Move left one cell */
          tape = tape->previous;
        }
        break;

      case '+':
        /* Repeat current->quantity times */
        for (i = 0; i < (current->quantity); i++) {
          /* Increase cell content by one */
          (tape->content)++;
        }
        break;
	
      case '-':
        /* Repeat current->quantity times */
        for (i = 0; i < (current->quantity); i++) {
          /* Decrease cell content by one */
          (tape->content)--;
        }
        break;

      case '.':
        /* Repeat current->quantity times */
        for (i = 0; i < (current->quantity); i++) {
          /* Print the char which is in the current cell */
          fputc (tape->content, stdout);
        }
        break;
      case ',':
        /* Repeat current->quantity times */
        for (i = 0; i < (current->quantity); i++) {
          char temp;
          /* Read a char from stdin */
          temp = fgetc (stdin);
          /* Special case: the char is EOF */
          if (temp == EOF) {
            temp = '\0';
            switch (on_eof) {
              case STORE_ZERO:
                temp = '\0';
                break;
              case STORE_EOF:
                temp = EOF;
                break;
              case DO_NOTHING:
                temp = tape->content;
                break;
            }
          }
          /* Save char in the current cell */
          tape->content = temp;
        }
        break;

      case '[':
        /* Repeat as long as the current cell is not empty */
        while (tape->content != '\0') {
          /* Run the loop */
          eval (current->loop, on_eof);
        }
        break;

      case '#':
        /* Repeat current->quantity times */
        for (i = 0; i < (current->quantity); i++) {
          /* Show the content of the tape on screen */
          tape_dump ();
        }
        break;

      case ']':
        break;

      default:
        /* Do nothing */
        break;
    }
    /* Move forward one cell */
    current = current->next;
  }
}

