import string
import sys
try:
    import weakref
except ImportError:
    def logInstanceCreation(instance, name=None):
        pass
else:
    def logInstanceCreation(instance, name=None):
        if name is None:
            name=instance.__class__.__name__
        if not tracked_classes.has_key(name):
            tracked_classes[name]=[]
        tracked_classes[name].append(weakref.ref(instance))
tracked_classes={}
def string_to_classes(s):
    if s=='*':
        c=tracked_classes.keys()
        c.sort()
        return c
    else:
        return string.split(s)
def countLoggedInstances(classes, file=sys.stdout):
    for classname in string_to_classes(classes):
        file.write("%s: %d\n" % (classname, len(tracked_classes[classname])))
def listLoggedInstances(classes, file=sys.stdout):
    for classname in string_to_classes(classes):
        file.write('\n%s:\n' % classname)
        for ref in tracked_classes[classname]:
            obj=ref()
            if obj is not None:
                file.write('    %s\n' % repr(obj))
def dumpLoggedInstances(classes, file=sys.stdout):
    for classname in string_to_classes(classes):
        file.write('\n%s:\n' % classname)
        for ref in tracked_classes[classname]:
            obj=ref()
            if obj is not None:
                file.write('    %s:\n' % obj)
                for key, value in obj.__dict__.items():
                    file.write('        %20s : %s\n' % (key, value))
if sys.platform[:5]=="linux":
    def memory():
        mstr=open('/proc/self/stat').read()
        mstr=string.split(mstr)[22]
        return int(mstr)
else:
    try:
        import resource
    except ImportError:
        def memory():
            return 0
    else:
        def memory():
            res=resource.getrusage(resource.RUSAGE_SELF)
            return res[4]
