/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.35
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package be.belgium.eid;
import java.util.*;
/******************************************************************************//**
  * This class represent a reader.
  * A reader object can be obtained from the ReaderSet
  *		either by its index (getReaderByNum()) or by its name (getReaderByName()).
  * Once you have a reader object, it can be checked if a card is present (isCardPresent()).
  * Using the type of card (getCardType()),
  *		 a card object can be obtained using:
  *			getCard(), getEIDCard(), getKidsCard(), getForeignerCard() or getSISCard()
  *********************************************************************************/
public class BEID_ReaderContext extends BEID_Object {
  private long swigCPtr;

  protected BEID_ReaderContext(long cPtr, boolean cMemoryOwn) {
    super(beidlibJava_WrapperJNI.SWIGBEID_ReaderContextUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BEID_ReaderContext obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      beidlibJava_WrapperJNI.delete_BEID_ReaderContext(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

	private static int		m_counter = 0;							// static counter to keep the nr of SetEventCallback we've done
	private static HashMap	m_CallbackContainer = new HashMap();	// static map to keep the data for each callback

	//------------------------------------------------------------
	// this function is called from C++ wrapper side as callback function.
	// It will receive the key in the map, from which it can recover
	// the callback helper class. This helper class contains the callback object
	// and the data object for this callback.
	// As such, the callback class will call, via the interface function of the callback object,
	// the Java application. The data object is passed as an argument.
	// In the application, this data from the dataobject can be read for whatever reason.
	//------------------------------------------------------------
	public static void doJavaCallBack( int iKey, long lRet, long ulState )
	{
		Integer key = new Integer(iKey);
		CallbackHelper callbackHelper = (CallbackHelper)m_CallbackContainer.get( key );
		callbackHelper.m_callbackObject.getEvent(lRet, ulState, callbackHelper.m_callbackData);
	}

	/**
	  * Constructor using a fileType and fileName (virtual card reader)
	  */
  public BEID_ReaderContext(BEID_FileType fileType, String fileName) {
    this(beidlibJava_WrapperJNI.new_BEID_ReaderContext__SWIG_0(fileType.swigValue(), fileName), true);
  }

	/**
	  * Constructor using a fileType and its content (for compatibility with SetRawFile())
	  */
  public BEID_ReaderContext(BEID_FileType fileType, BEID_ByteArray data) {
    this(beidlibJava_WrapperJNI.new_BEID_ReaderContext__SWIG_1(fileType.swigValue(), BEID_ByteArray.getCPtr(data), data), true);
  }

	/**
	  * Constructor using Raw data for an Eid card
	  *		No reader are connected (m_reader=NULL)
	  */
  public BEID_ReaderContext(BEID_RawData_Eid data) {
    this(beidlibJava_WrapperJNI.new_BEID_ReaderContext__SWIG_2(BEID_RawData_Eid.getCPtr(data), data), true);
  }

	/**
	  * Constructor using Raw data for a Sis card
	  *		No reader are connected (m_reader=NULL)
	  */
  public BEID_ReaderContext(BEID_RawData_Sis data) {
    this(beidlibJava_WrapperJNI.new_BEID_ReaderContext__SWIG_3(BEID_RawData_Sis.getCPtr(data), data), true);
  }
	/** Get the name of the reader */
  public String getName() throws java.lang.Exception {
    return beidlibJava_WrapperJNI.BEID_ReaderContext_getName(swigCPtr, this);
  }
	/** Return true if a card is present in the reader and false otherwise */
  public boolean isCardPresent() throws java.lang.Exception {
    return beidlibJava_WrapperJNI.BEID_ReaderContext_isCardPresent(swigCPtr, this);
  }

	/**
	  * Release the card
	  *
	  * @param bAllReference If true all the invalid reference/pointer are destroyed.
	  * THIS PARAMETER IS THREAD UNSAFE.
	  * You have to be sure that you will not use any old reference/pointer after calling this function
	  */
  public void releaseCard(boolean bAllReference) throws java.lang.Exception {
    beidlibJava_WrapperJNI.BEID_ReaderContext_releaseCard__SWIG_0(swigCPtr, this, bAllReference);
  }

  public void releaseCard() throws java.lang.Exception {
    beidlibJava_WrapperJNI.BEID_ReaderContext_releaseCard__SWIG_1(swigCPtr, this);
  }

	/**
	  * Check if the card in the reader is changed
	  * @param ulOldId the Id received when setting the callback for this reader
	  */
  public boolean isCardChanged(BEID_ulwrapper ulOldId) throws java.lang.Exception {
	  long pID = beidlibJava_WrapperJNI.new_ulongp();				// get a C++ ptr
	  beidlibJava_WrapperJNI.ulongp_assign(pID,ulOldId.m_long);
	  boolean retval = beidlibJava_WrapperJNI.BEID_ReaderContext_isCardChanged(swigCPtr, this, pID);
	  ulOldId.m_long = beidlibJava_WrapperJNI.ulongp_value(pID);
	  beidlibJava_WrapperJNI.delete_ulongp(pID);
	  return retval;
}

	/**
	 * Return the type of the card in the reader.
	 *
	 * Throws BEID_ExNoCardPresent() exception if no card is present
	 */
  public BEID_CardType getCardType() throws java.lang.Exception {
    return BEID_CardType.swigToEnum(beidlibJava_WrapperJNI.BEID_ReaderContext_getCardType(swigCPtr, this));
  }

	/**
	 * Get the card in the reader
	 *		Instantiation is made regarding the type of the card
	 *			(BEID_EIDCard, BEID_KidsCard, BEID_ForeignerCard or BEID_SISCard)
	 *
	 * If no card is present in the reader, exception BEID_ExNoCardPresent() is thrown
	 * If the card type is not supported, exception BEID_ExCardTypeUnknown() is thrown
	 */
  public BEID_Card getCard() throws java.lang.Exception {
    return new BEID_Card(beidlibJava_WrapperJNI.BEID_ReaderContext_getCard(swigCPtr, this), false);
  }

	/**
	 * Get the EIDcard in the reader
	 *		Instantiation is made regarding the type of the card
	 *			(BEID_EIDCard, BEID_KidsCard, BEID_ForeignerCard)
	 *
	 * If no card is present in the reader, exception BEID_ExNoCardPresent is thrown
	 * If the card is not an EIDcard, exception BEID_ExCardBadType is thrown
	 */
  public BEID_EIDCard getEIDCard() throws java.lang.Exception {
    return new BEID_EIDCard(beidlibJava_WrapperJNI.BEID_ReaderContext_getEIDCard(swigCPtr, this), false);
  }

 	/**
	 * Get the KidsCard in the reader
	 *
	 * If no card is present in the reader, exception BEID_ExNoCardPresent is thrown
	 * If the card is not a KidsCard, exception BEID_ExCardBadType is thrown
	 */
  public BEID_KidsCard getKidsCard() throws java.lang.Exception {
    return new BEID_KidsCard(beidlibJava_WrapperJNI.BEID_ReaderContext_getKidsCard(swigCPtr, this), false);
  }

 	/**
	 * Get the ForeignerCard in the reader
	 *
	 * If no card is present in the reader, exception BEID_ExNoCardPresent is thrown
	 * If the card is not a ForeignerCard, exception BEID_ExCardBadType is thrown
	 */
  public BEID_ForeignerCard getForeignerCard() throws java.lang.Exception {
    return new BEID_ForeignerCard(beidlibJava_WrapperJNI.BEID_ReaderContext_getForeignerCard(swigCPtr, this), false);
  }

 	/**
	 * Get the SISCard in the reader
	 *
	 * If no card is present in the reader, exception BEID_ExNoCardPresent is thrown
	 * If the card is not a SISCard, exception BEID_ExCardBadType is thrown
	 */
  public BEID_SISCard getSISCard() throws java.lang.Exception {
    return new BEID_SISCard(beidlibJava_WrapperJNI.BEID_ReaderContext_getSISCard(swigCPtr, this), false);
  }

	/**
	 * Specify a callback object to be used each time a
	 * card is inserted/removed in/from this reader.
	 *
	 * @return A handle that can be used to stop the callbacks when they are no longer needed.
	 */
  public long SetEventCallback(Callback callback, Object pvRef) throws java.lang.Exception {
	m_counter++;
	Integer key = new Integer(m_counter);
	m_CallbackContainer.put(key, new CallbackHelper(callback, pvRef));
	long result = beidlibJava_WrapperJNI.BEID_ReaderContext_SetEventCallback(swigCPtr, this, 0, m_counter);
	return result;
}

	/**
	  * Stop the callback for this card reader
	  * @param ulHandle the handle returned by SetEventCallback()
	  */
  public void StopEventCallback(long ulHandle) throws java.lang.Exception {
    beidlibJava_WrapperJNI.BEID_ReaderContext_StopEventCallback(swigCPtr, this, ulHandle);

	Set CallbackContainerKeys = m_CallbackContainer.keySet();
	Iterator itr = CallbackContainerKeys.iterator();

	while (itr.hasNext())
	{
		Integer		   key		= (Integer)itr.next();
		CallbackHelper cbHelper = (CallbackHelper)m_CallbackContainer.get(key);

		if (cbHelper.m_handle == ulHandle)
		{
			m_CallbackContainer.remove(key);
			break;
		}
	}
}
	/** Begin a transaction with the reader */
  public void BeginTransaction() throws java.lang.Exception {
    beidlibJava_WrapperJNI.BEID_ReaderContext_BeginTransaction(swigCPtr, this);
  }
	/** End the transaction */
  public void EndTransaction() throws java.lang.Exception {
    beidlibJava_WrapperJNI.BEID_ReaderContext_EndTransaction(swigCPtr, this);
  }
	/** Return true if this is a virtual reader (created from a file) */
  public boolean isVirtualReader() throws java.lang.Exception {
    return beidlibJava_WrapperJNI.BEID_ReaderContext_isVirtualReader(swigCPtr, this);
  }

}
